# Generated by Django 3.2.8 on 2021-10-25 11:56

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import huscy.projects.models.reserach_unit


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ResearchUnit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True)),
                ('code', models.CharField(blank=True, default=huscy.projects.models.reserach_unit.get_default_value_for_code, max_length=32, unique=True)),
                ('principal_investigator', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('local_id', models.PositiveIntegerField()),
                ('title', models.CharField(max_length=126)),
                ('description', models.TextField(blank=True, default='')),
                ('principal_investigator', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
                ('research_unit', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='projects.researchunit')),
            ],
            options={
                'ordering': ('-id',),
                'unique_together': {('local_id', 'research_unit')},
            },
        ),
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_coordinator', models.BooleanField(default=False)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='projects.project')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'project')},
            },
        ),
    ]
