"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @experimental
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        this.serviceAccountName = (_b = options === null || options === void 0 ? void 0 : options.serviceAccountName) !== null && _b !== void 0 ? _b : 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_c = options === null || options === void 0 ? void 0 : options.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        this.createServiceAccount = (_d = options === null || options === void 0 ? void 0 : options.createServiceAccount) !== null && _d !== void 0 ? _d : true;
        this.certManager = (_e = options === null || options === void 0 ? void 0 : options.certManager) !== null && _e !== void 0 ? _e : true;
        if (this.certManager === true) {
            new cdk8s.Include(this, 'certificate-manager', {
                url: 'https://raw.githubusercontent.com/Hunter-Thompson/my-etcd/main/cert-manager-v1.0.2.yaml',
            });
        }
        new cdk8s.Include(this, 'alb-crds', {
            url: path.join(__dirname, '../crds.yaml'),
        });
        const webhookAnnotations = options.argoCertIgnore ? { 'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert', 'argocd.argoproj.io/compare-options': 'IgnoreExtraneous', 'argocd.argoproj.io/hook': 'Skip' } : { 'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert' };
        new k8s.KubeMutatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-webhook', {
            metadata: {
                annotations: webhookAnnotations,
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-v1-pod',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mpod.elbv2.k8s.aws',
                    namespaceSelector: {
                        matchExpressions: [
                            {
                                key: 'elbv2.k8s.aws/pod-readiness-gate-inject',
                                operator: 'In',
                                values: ['enabled'],
                            },
                        ],
                    },
                    rules: [{
                            apiGroups: [''],
                            apiVersions: ['v1'],
                            operations: [
                                'CREATE',
                            ],
                            resources: ['pods'],
                        }],
                    sideEffects: 'None',
                },
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
        if (options.createServiceAccount === true) {
            new k8s.KubeServiceAccount(this, 'aws-load-balancer-controller-sa', {
                metadata: {
                    labels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            });
        }
        new k8s.KubeRole(this, 'aws-load-balancer-controller-leader-election-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-role',
                namespace: this.namespace,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: ['create'],
                }, {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: ['aws-load-balancer-controller-leader'],
                    verbs: ['get', 'update', 'patch'],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'leader-cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'ClusterRole',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: `${this.serviceAccountName}-role`,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['events'],
                    verbs: [
                        'create',
                        'patch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['namespaces'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['secrets'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['services'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['services/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['ingressclassparams'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings'],
                    verbs: [
                        'create',
                        'delete',
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingressclasses'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
            ],
        });
        new k8s.KubeRoleBinding(this, 'aws-load-balancer-controller-leader-election-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-rolebinding',
                namespace: this.namespace,
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'aws-load-balancer-controller-leader-election-role',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new k8s.KubeClusterRoleBinding(this, 'aws-load-balancer-controller-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-rolebinding',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: `${this.serviceAccountName}-role`,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.KubeService(this, 'aws-load-balancer-webhook-service', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook-service',
                namespace: this.namespace,
            },
            spec: {
                ports: [
                    {
                        port: 443,
                        targetPort: 9443,
                    },
                ],
                selector: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
            },
        });
        new k8s.KubeDeployment(this, 'aws-load-balancer-controller-deployment', {
            metadata: {
                labels: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                namespace: this.namespace,
                name: this.deploymentName,
            },
            spec: {
                replicas: (_f = options === null || options === void 0 ? void 0 : options.replicas) !== null && _f !== void 0 ? _f : 1,
                selector: {
                    matchLabels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            'app.kubernetes.io/component': 'controller',
                            'app.kubernetes.io/name': this.serviceAccountName,
                            ...options.labels,
                        },
                    },
                    spec: {
                        containers: [{
                                name: 'controller',
                                image: (_g = options === null || options === void 0 ? void 0 : options.image) !== null && _g !== void 0 ? _g : 'amazon/aws-alb-ingress-controller:v2.2.0',
                                args: this.argsFunc(options.args),
                                env: this.envFunc(options.env),
                                livenessProbe: {
                                    failureThreshold: 2,
                                    httpGet: {
                                        path: '/healthz',
                                        port: 61779,
                                        scheme: 'HTTP',
                                    },
                                    initialDelaySeconds: 30,
                                    timeoutSeconds: 10,
                                },
                                ports: [
                                    {
                                        containerPort: 9443,
                                        name: 'webhook-server',
                                        protocol: 'TCP',
                                    },
                                ],
                                resources: {
                                    limits: {
                                        cpu: '200m',
                                        memory: '500Mi',
                                    },
                                    requests: {
                                        cpu: '100m',
                                        memory: '200Mi',
                                    },
                                },
                                securityContext: {
                                    allowPrivilegeEscalation: false,
                                    readOnlyRootFilesystem: true,
                                    runAsNonRoot: true,
                                },
                                volumeMounts: [
                                    {
                                        mountPath: '/tmp/k8s-webhook-server/serving-certs',
                                        name: 'cert',
                                        readOnly: true,
                                    },
                                ],
                            }],
                        securityContext: {
                            fsGroup: 1337,
                        },
                        serviceAccountName: `${this.serviceAccountName}`,
                        terminationGracePeriodSeconds: 10,
                        priorityClassName: 'system-cluster-critical',
                        volumes: [{
                                name: 'cert',
                                secret: {
                                    defaultMode: 420,
                                    secretName: 'aws-load-balancer-webhook-tls',
                                },
                            }],
                    },
                },
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-serving-cert', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Certificate',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-serving-cert',
                namespace: this.namespace,
            },
            spec: {
                dnsNames: [
                    'aws-load-balancer-webhook-service.kube-system.svc',
                    'aws-load-balancer-webhook-service.kube-system.svc.cluster.local',
                ],
                issuerRef: {
                    kind: 'Issuer',
                    name: 'aws-load-balancer-selfsigned-issuer',
                },
                secretName: 'aws-load-balancer-webhook-tls',
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-selfsigned-issuer', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Issuer',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-selfsigned-issuer',
                namespace: this.namespace,
            },
            spec: {
                selfSigned: {},
            },
        });
        new k8s.KubeValidatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-selfsigned-issuer-valid', {
            metadata: {
                annotations: webhookAnnotations,
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/validate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'vtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerController", version: "0.2.5" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hd3MtbG9hZC1iYWxhbmNlci1jb250cm9sbGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLCtCQUErQjtBQUMvQiwyQ0FBdUM7QUFDdkMscUNBQXFDOzs7Ozs7OztBQW1DckMsTUFBYSx5QkFBMEIsU0FBUSxzQkFBUzs7OztJQWF0RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE9BQXlDOztRQUNqRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxrQkFBa0IsU0FBRyxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsa0JBQWtCLG1DQUFJLDhCQUE4QixDQUFDO1FBQ3hGLElBQUksQ0FBQyxjQUFjLEdBQUcsOEJBQThCLENBQUM7UUFDckQsSUFBSSxDQUFDLFdBQVcsR0FBRyxPQUFPLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxTQUFTLFNBQUcsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLFNBQVMsbUNBQUksYUFBYSxDQUFDO1FBQ3JELElBQUksQ0FBQyxvQkFBb0IsU0FBRyxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsb0JBQW9CLG1DQUFJLElBQUksQ0FBQztRQUNsRSxJQUFJLENBQUMsV0FBVyxTQUFHLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxXQUFXLG1DQUFJLElBQUksQ0FBQztRQUVoRCxJQUFJLElBQUksQ0FBQyxXQUFXLEtBQUssSUFBSSxFQUFFO1lBQzdCLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUscUJBQXFCLEVBQUU7Z0JBQzdDLEdBQUcsRUFBRSx5RkFBeUY7YUFDL0YsQ0FBQyxDQUFDO1NBQ0o7UUFFRCxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNsQyxHQUFHLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsY0FBYyxDQUFDO1NBQzFDLENBQUMsQ0FBQztRQUVILE1BQU0sa0JBQWtCLEdBQTRCLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLEVBQUUsZ0NBQWdDLEVBQUUsNENBQTRDLEVBQUUsb0NBQW9DLEVBQUUsa0JBQWtCLEVBQUUseUJBQXlCLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsZ0NBQWdDLEVBQUUsNENBQTRDLEVBQUUsQ0FBQztRQUdsVixJQUFJLEdBQUcsQ0FBQyx1Q0FBdUMsQ0FBQyxJQUFJLEVBQUUsMkJBQTJCLEVBQUU7WUFDakYsUUFBUSxFQUFFO2dCQUNSLFdBQVcsRUFBRSxrQkFBa0I7Z0JBQy9CLE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxJQUFJLEVBQUUsMkJBQTJCO2FBQ2xDO1lBQ0QsUUFBUSxFQUFFO2dCQUNSO29CQUNFLFlBQVksRUFBRTt3QkFDWixRQUFRLEVBQUUsTUFBTTt3QkFDaEIsT0FBTyxFQUFFOzRCQUNQLElBQUksRUFBRSxtQ0FBbUM7NEJBQ3pDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzs0QkFDekIsSUFBSSxFQUFFLGdCQUFnQjt5QkFDdkI7cUJBQ0Y7b0JBQ0QsYUFBYSxFQUFFLE1BQU07b0JBQ3JCLElBQUksRUFBRSxvQkFBb0I7b0JBQzFCLGlCQUFpQixFQUFFO3dCQUNqQixnQkFBZ0IsRUFBRTs0QkFDaEI7Z0NBQ0UsR0FBRyxFQUFFLHlDQUF5QztnQ0FDOUMsUUFBUSxFQUFFLElBQUk7Z0NBQ2QsTUFBTSxFQUFFLENBQUMsU0FBUyxDQUFDOzZCQUNwQjt5QkFDRjtxQkFDRjtvQkFDRCxLQUFLLEVBQUUsQ0FBQzs0QkFDTixTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7NEJBQ2YsV0FBVyxFQUFFLENBQUMsSUFBSSxDQUFDOzRCQUNuQixVQUFVLEVBQUU7Z0NBQ1YsUUFBUTs2QkFDVDs0QkFDRCxTQUFTLEVBQUUsQ0FBQyxNQUFNLENBQUM7eUJBQ3BCLENBQUM7b0JBQ0YsV0FBVyxFQUFFLE1BQU07aUJBQ3BCO2dCQUNEO29CQUNFLFlBQVksRUFBRTt3QkFDWixRQUFRLEVBQUUsTUFBTTt3QkFDaEIsT0FBTyxFQUFFOzRCQUNQLElBQUksRUFBRSxtQ0FBbUM7NEJBQ3pDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzs0QkFDekIsSUFBSSxFQUFFLGtEQUFrRDt5QkFDekQ7cUJBQ0Y7b0JBQ0QsYUFBYSxFQUFFLE1BQU07b0JBQ3JCLElBQUksRUFBRSxtQ0FBbUM7b0JBQ3pDLEtBQUssRUFBRSxDQUFDOzRCQUNOLFNBQVMsRUFBRSxDQUFDLGVBQWUsQ0FBQzs0QkFDNUIsV0FBVyxFQUFFLENBQUMsU0FBUyxDQUFDOzRCQUN4QixVQUFVLEVBQUU7Z0NBQ1YsUUFBUTtnQ0FDUixRQUFROzZCQUNUOzRCQUNELFNBQVMsRUFBRSxDQUFDLHFCQUFxQixDQUFDO3lCQUNuQyxDQUFDO29CQUNGLFdBQVcsRUFBRSxNQUFNO2lCQUNwQjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxPQUFPLENBQUMsb0JBQW9CLEtBQUssSUFBSSxFQUFFO1lBQ3pDLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRSxpQ0FBaUMsRUFBRTtnQkFDbEUsUUFBUSxFQUFFO29CQUNSLE1BQU0sRUFBRTt3QkFDTiw2QkFBNkIsRUFBRSxZQUFZO3dCQUMzQyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO3dCQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO3FCQUNsQjtvQkFDRCxJQUFJLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtvQkFDN0IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2lCQUMxQjthQUNGLENBQUMsQ0FBQztTQUNKO1FBRUQsSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxtREFBbUQsRUFBRTtZQUMxRSxRQUFRLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSxtREFBbUQ7Z0JBQ3pELFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzthQUMxQjtZQUNELEtBQUssRUFBRTtnQkFDTDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7b0JBQ2YsU0FBUyxFQUFFLENBQUMsWUFBWSxDQUFDO29CQUN6QixLQUFLLEVBQUUsQ0FBQyxRQUFRLENBQUM7aUJBQ2xCLEVBQUU7b0JBQ0QsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLFlBQVksQ0FBQztvQkFDekIsYUFBYSxFQUFFLENBQUMscUNBQXFDLENBQUM7b0JBQ3RELEtBQUssRUFBRSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUUsT0FBTyxDQUFDO2lCQUNsQzthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxxQkFBcUIsRUFBRTtZQUMvQyxVQUFVLEVBQUUsOEJBQThCO1lBQzFDLElBQUksRUFBRSxhQUFhO1lBQ25CLFFBQVEsRUFBRTtnQkFDUixNQUFNLEVBQUU7b0JBQ04sd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtvQkFDakQsR0FBRyxPQUFPLENBQUMsTUFBTTtpQkFDbEI7Z0JBQ0QsSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixPQUFPO2FBQ3hDO1lBQ0QsS0FBSyxFQUFFO2dCQUNMO29CQUNFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDZixTQUFTLEVBQUUsQ0FBQyxXQUFXLENBQUM7b0JBQ3hCLEtBQUssRUFBRTt3QkFDTCxLQUFLO3dCQUNMLE1BQU07d0JBQ04sT0FBTztxQkFDUjtpQkFDRjtnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7b0JBQ2YsU0FBUyxFQUFFLENBQUMsUUFBUSxDQUFDO29CQUNyQixLQUFLLEVBQUU7d0JBQ0wsUUFBUTt3QkFDUixPQUFPO3FCQUNSO2lCQUNGO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDZixTQUFTLEVBQUUsQ0FBQyxZQUFZLENBQUM7b0JBQ3pCLEtBQUssRUFBRTt3QkFDTCxLQUFLO3dCQUNMLE1BQU07d0JBQ04sT0FBTztxQkFDUjtpQkFDRjtnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7b0JBQ2YsU0FBUyxFQUFFLENBQUMsT0FBTyxDQUFDO29CQUNwQixLQUFLLEVBQUU7d0JBQ0wsS0FBSzt3QkFDTCxNQUFNO3dCQUNOLE9BQU87cUJBQ1I7aUJBQ0Y7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLE1BQU0sQ0FBQztvQkFDbkIsS0FBSyxFQUFFO3dCQUNMLEtBQUs7d0JBQ0wsTUFBTTt3QkFDTixPQUFPO3FCQUNSO2lCQUNGO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDZixTQUFTLEVBQUUsQ0FBQyxhQUFhLENBQUM7b0JBQzFCLEtBQUssRUFBRTt3QkFDTCxPQUFPO3dCQUNQLFFBQVE7cUJBQ1Q7aUJBQ0Y7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLFNBQVMsQ0FBQztvQkFDdEIsS0FBSyxFQUFFO3dCQUNMLEtBQUs7d0JBQ0wsTUFBTTt3QkFDTixPQUFPO3FCQUNSO2lCQUNGO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDZixTQUFTLEVBQUUsQ0FBQyxVQUFVLENBQUM7b0JBQ3ZCLEtBQUssRUFBRTt3QkFDTCxLQUFLO3dCQUNMLE1BQU07d0JBQ04sT0FBTzt3QkFDUCxRQUFRO3dCQUNSLE9BQU87cUJBQ1I7aUJBQ0Y7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLGlCQUFpQixDQUFDO29CQUM5QixLQUFLLEVBQUU7d0JBQ0wsT0FBTzt3QkFDUCxRQUFRO3FCQUNUO2lCQUNGO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLGVBQWUsQ0FBQztvQkFDNUIsU0FBUyxFQUFFLENBQUMsb0JBQW9CLENBQUM7b0JBQ2pDLEtBQUssRUFBRTt3QkFDTCxLQUFLO3dCQUNMLE1BQU07d0JBQ04sT0FBTztxQkFDUjtpQkFDRjtnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxlQUFlLENBQUM7b0JBQzVCLFNBQVMsRUFBRSxDQUFDLHFCQUFxQixDQUFDO29CQUNsQyxLQUFLLEVBQUU7d0JBQ0wsUUFBUTt3QkFDUixRQUFRO3dCQUNSLEtBQUs7d0JBQ0wsTUFBTTt3QkFDTixPQUFPO3dCQUNQLFFBQVE7d0JBQ1IsT0FBTztxQkFDUjtpQkFDRjtnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxlQUFlLENBQUM7b0JBQzVCLFNBQVMsRUFBRSxDQUFDLDRCQUE0QixDQUFDO29CQUN6QyxLQUFLLEVBQUU7d0JBQ0wsT0FBTzt3QkFDUCxRQUFRO3FCQUNUO2lCQUNGO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLFlBQVksQ0FBQztvQkFDekIsU0FBUyxFQUFFLENBQUMsV0FBVyxDQUFDO29CQUN4QixLQUFLLEVBQUU7d0JBQ0wsS0FBSzt3QkFDTCxNQUFNO3dCQUNOLE9BQU87d0JBQ1AsUUFBUTt3QkFDUixPQUFPO3FCQUNSO2lCQUNGO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLFlBQVksQ0FBQztvQkFDekIsU0FBUyxFQUFFLENBQUMsa0JBQWtCLENBQUM7b0JBQy9CLEtBQUssRUFBRTt3QkFDTCxPQUFPO3dCQUNQLFFBQVE7cUJBQ1Q7aUJBQ0Y7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsbUJBQW1CLENBQUM7b0JBQ2hDLFNBQVMsRUFBRSxDQUFDLGdCQUFnQixDQUFDO29CQUM3QixLQUFLLEVBQUU7d0JBQ0wsS0FBSzt3QkFDTCxNQUFNO3dCQUNOLE9BQU87cUJBQ1I7aUJBQ0Y7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsbUJBQW1CLENBQUM7b0JBQ2hDLFNBQVMsRUFBRSxDQUFDLFdBQVcsQ0FBQztvQkFDeEIsS0FBSyxFQUFFO3dCQUNMLEtBQUs7d0JBQ0wsTUFBTTt3QkFDTixPQUFPO3dCQUNQLFFBQVE7d0JBQ1IsT0FBTztxQkFDUjtpQkFDRjtnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQztvQkFDaEMsU0FBUyxFQUFFLENBQUMsa0JBQWtCLENBQUM7b0JBQy9CLEtBQUssRUFBRTt3QkFDTCxPQUFPO3dCQUNQLFFBQVE7cUJBQ1Q7aUJBQ0Y7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsMERBQTBELEVBQUU7WUFDeEYsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxJQUFJLEVBQUUsMERBQTBEO2dCQUNoRSxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7YUFDMUI7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsUUFBUSxFQUFFLDJCQUEyQjtnQkFDckMsSUFBSSxFQUFFLE1BQU07Z0JBQ1osSUFBSSxFQUFFLG1EQUFtRDthQUMxRDtZQUNELFFBQVEsRUFBRTtnQkFDUjtvQkFDRSxJQUFJLEVBQUUsZ0JBQWdCO29CQUN0QixJQUFJLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtvQkFDN0IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2lCQUMxQjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsc0JBQXNCLENBQUMsSUFBSSxFQUFFLDBDQUEwQyxFQUFFO1lBQy9FLFFBQVEsRUFBRTtnQkFDUixNQUFNLEVBQUU7b0JBQ04sd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtvQkFDakQsR0FBRyxPQUFPLENBQUMsTUFBTTtpQkFDbEI7Z0JBQ0QsSUFBSSxFQUFFLDBDQUEwQzthQUNqRDtZQUNELE9BQU8sRUFBRTtnQkFDUCxRQUFRLEVBQUUsMkJBQTJCO2dCQUNyQyxJQUFJLEVBQUUsYUFBYTtnQkFDbkIsSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixPQUFPO2FBQ3hDO1lBQ0QsUUFBUSxFQUFFO2dCQUNSO29CQUNFLElBQUksRUFBRSxnQkFBZ0I7b0JBQ3RCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztvQkFDekIsSUFBSSxFQUFFLElBQUksQ0FBQyxrQkFBa0I7aUJBQzlCO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLEdBQUcsQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLG1DQUFtQyxFQUFFO1lBQzdELFFBQVEsRUFBRTtnQkFDUixNQUFNLEVBQUU7b0JBQ04sd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtvQkFDakQsR0FBRyxPQUFPLENBQUMsTUFBTTtpQkFDbEI7Z0JBQ0QsSUFBSSxFQUFFLG1DQUFtQztnQkFDekMsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2FBQzFCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLEtBQUssRUFBRTtvQkFDTDt3QkFDRSxJQUFJLEVBQUUsR0FBRzt3QkFDVCxVQUFVLEVBQUUsSUFBSTtxQkFDakI7aUJBQ0Y7Z0JBQ0QsUUFBUSxFQUFFO29CQUNSLDZCQUE2QixFQUFFLFlBQVk7b0JBQzNDLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7aUJBQ2xEO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLHlDQUF5QyxFQUFFO1lBQ3RFLFFBQVEsRUFBRTtnQkFDUixNQUFNLEVBQUU7b0JBQ04sNkJBQTZCLEVBQUUsWUFBWTtvQkFDM0Msd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtvQkFDakQsR0FBRyxPQUFPLENBQUMsTUFBTTtpQkFDbEI7Z0JBQ0QsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2dCQUN6QixJQUFJLEVBQUUsSUFBSSxDQUFDLGNBQWM7YUFDMUI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osUUFBUSxRQUFFLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxRQUFRLG1DQUFJLENBQUM7Z0JBQ2hDLFFBQVEsRUFBRTtvQkFDUixXQUFXLEVBQUU7d0JBQ1gsNkJBQTZCLEVBQUUsWUFBWTt3QkFDM0Msd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjt3QkFDakQsR0FBRyxPQUFPLENBQUMsTUFBTTtxQkFDbEI7aUJBQ0Y7Z0JBQ0QsUUFBUSxFQUFFO29CQUNSLFFBQVEsRUFBRTt3QkFDUixNQUFNLEVBQUU7NEJBQ04sNkJBQTZCLEVBQUUsWUFBWTs0QkFDM0Msd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjs0QkFDakQsR0FBRyxPQUFPLENBQUMsTUFBTTt5QkFDbEI7cUJBQ0Y7b0JBQ0QsSUFBSSxFQUFFO3dCQUNKLFVBQVUsRUFBRSxDQUFDO2dDQUNYLElBQUksRUFBRSxZQUFZO2dDQUNsQixLQUFLLFFBQUUsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLEtBQUssbUNBQUksMENBQTBDO2dDQUNuRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDO2dDQUNqQyxHQUFHLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDO2dDQUM5QixhQUFhLEVBQUU7b0NBQ2IsZ0JBQWdCLEVBQUUsQ0FBQztvQ0FDbkIsT0FBTyxFQUFFO3dDQUNQLElBQUksRUFBRSxVQUFVO3dDQUNoQixJQUFJLEVBQUUsS0FBSzt3Q0FDWCxNQUFNLEVBQUUsTUFBTTtxQ0FDZjtvQ0FDRCxtQkFBbUIsRUFBRSxFQUFFO29DQUN2QixjQUFjLEVBQUUsRUFBRTtpQ0FDbkI7Z0NBQ0QsS0FBSyxFQUFFO29DQUNMO3dDQUNFLGFBQWEsRUFBRSxJQUFJO3dDQUNuQixJQUFJLEVBQUUsZ0JBQWdCO3dDQUN0QixRQUFRLEVBQUUsS0FBSztxQ0FDaEI7aUNBQ0Y7Z0NBQ0QsU0FBUyxFQUFFO29DQUNULE1BQU0sRUFBRTt3Q0FDTixHQUFHLEVBQUUsTUFBTTt3Q0FDWCxNQUFNLEVBQUUsT0FBTztxQ0FDaEI7b0NBQ0QsUUFBUSxFQUFFO3dDQUNSLEdBQUcsRUFBRSxNQUFNO3dDQUNYLE1BQU0sRUFBRSxPQUFPO3FDQUNoQjtpQ0FDRjtnQ0FDRCxlQUFlLEVBQUU7b0NBQ2Ysd0JBQXdCLEVBQUUsS0FBSztvQ0FDL0Isc0JBQXNCLEVBQUUsSUFBSTtvQ0FDNUIsWUFBWSxFQUFFLElBQUk7aUNBQ25CO2dDQUNELFlBQVksRUFBRTtvQ0FDWjt3Q0FDRSxTQUFTLEVBQUUsdUNBQXVDO3dDQUNsRCxJQUFJLEVBQUUsTUFBTTt3Q0FDWixRQUFRLEVBQUUsSUFBSTtxQ0FDZjtpQ0FDRjs2QkFDRixDQUFDO3dCQUNGLGVBQWUsRUFBRTs0QkFDZixPQUFPLEVBQUUsSUFBSTt5QkFDZDt3QkFDRCxrQkFBa0IsRUFBRSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsRUFBRTt3QkFDaEQsNkJBQTZCLEVBQUUsRUFBRTt3QkFDakMsaUJBQWlCLEVBQUUseUJBQXlCO3dCQUM1QyxPQUFPLEVBQUUsQ0FBQztnQ0FDUixJQUFJLEVBQUUsTUFBTTtnQ0FDWixNQUFNLEVBQUU7b0NBQ04sV0FBVyxFQUFFLEdBQUc7b0NBQ2hCLFVBQVUsRUFBRSwrQkFBK0I7aUNBQzVDOzZCQUNGLENBQUM7cUJBQ0g7aUJBQ0Y7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsZ0NBQWdDLEVBQUU7WUFDMUQsVUFBVSxFQUFFLDBCQUEwQjtZQUN0QyxJQUFJLEVBQUUsYUFBYTtZQUNuQixRQUFRLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSxnQ0FBZ0M7Z0JBQ3RDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzthQUMxQjtZQUNELElBQUksRUFBRTtnQkFDSixRQUFRLEVBQUU7b0JBQ1IsbURBQW1EO29CQUNuRCxpRUFBaUU7aUJBQ2xFO2dCQUNELFNBQVMsRUFBRTtvQkFDVCxJQUFJLEVBQUUsUUFBUTtvQkFDZCxJQUFJLEVBQUUscUNBQXFDO2lCQUM1QztnQkFDRCxVQUFVLEVBQUUsK0JBQStCO2FBQzVDO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxxQ0FBcUMsRUFBRTtZQUMvRCxVQUFVLEVBQUUsMEJBQTBCO1lBQ3RDLElBQUksRUFBRSxRQUFRO1lBQ2QsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxJQUFJLEVBQUUscUNBQXFDO2dCQUMzQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7YUFDMUI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osVUFBVSxFQUFFLEVBQUU7YUFDZjtTQUNGLENBQUMsQ0FBQztRQUdILElBQUksR0FBRyxDQUFDLHlDQUF5QyxDQUFDLElBQUksRUFBRSwyQ0FBMkMsRUFBRTtZQUNuRyxRQUFRLEVBQUU7Z0JBQ1IsV0FBVyxFQUFFLGtCQUFrQjtnQkFDL0IsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSwyQkFBMkI7YUFDbEM7WUFDRCxRQUFRLEVBQUU7Z0JBQ1I7b0JBQ0UsWUFBWSxFQUFFO3dCQUNaLFFBQVEsRUFBRSxNQUFNO3dCQUNoQixPQUFPLEVBQUU7NEJBQ1AsSUFBSSxFQUFFLG1DQUFtQzs0QkFDekMsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTOzRCQUN6QixJQUFJLEVBQUUsb0RBQW9EO3lCQUMzRDtxQkFDRjtvQkFDRCxhQUFhLEVBQUUsTUFBTTtvQkFDckIsSUFBSSxFQUFFLG1DQUFtQztvQkFDekMsS0FBSyxFQUFFLENBQUM7NEJBQ04sU0FBUyxFQUFFLENBQUMsZUFBZSxDQUFDOzRCQUM1QixXQUFXLEVBQUUsQ0FBQyxTQUFTLENBQUM7NEJBQ3hCLFVBQVUsRUFBRTtnQ0FDVixRQUFRO2dDQUNSLFFBQVE7NkJBQ1Q7NEJBQ0QsU0FBUyxFQUFFLENBQUMscUJBQXFCLENBQUM7eUJBQ25DLENBQUM7b0JBQ0YsV0FBVyxFQUFFLE1BQU07aUJBQ3BCO2FBQ0Y7U0FDRixDQUFDLENBQUM7SUFFTCxDQUFDO0lBQ08sUUFBUSxDQUFDLElBQWU7UUFDOUIsTUFBTSxXQUFXLEdBQUcsQ0FBQyxxQkFBcUIsRUFBRSxrQkFBa0IsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDbEYsSUFBSSxJQUFJLEVBQUU7WUFDUixJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3hDO1FBQ0QsT0FBTyxXQUFXLENBQUM7SUFDckIsQ0FBQztJQUNPLE9BQU8sQ0FBQyxNQUE2QjtRQUMzQyxPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDOztBQXhpQkgsOERBeWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBjZGs4cyBmcm9tICdjZGs4cyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGs4cyBmcm9tICcuL2ltcG9ydHMvazhzJztcblxuZXhwb3J0IGludGVyZmFjZSBFbnZWYXIge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2YWx1ZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBd3NMb2FkQmFsYW5jZXJDb250cm9sbGVyT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNlcnRNYW5hZ2VyPzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbGFiZWxzPzogeyBbbmFtZTogc3RyaW5nXTogc3RyaW5nIH07XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbmFtZXNwYWNlPzogc3RyaW5nIDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNsdXN0ZXJOYW1lOiBzdHJpbmcgO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY3JlYXRlU2VydmljZUFjY291bnQ/OiBib29sZWFuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2VydmljZUFjY291bnROYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpbWFnZT86IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhcmdzPzogc3RyaW5nW107XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW52PzogRW52VmFyW107XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXBsaWNhcz86IG51bWJlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXJnb0NlcnRJZ25vcmU/OiBib29sZWFuO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXdzTG9hZEJhbGFuY2VyQ29udHJvbGxlciBleHRlbmRzIENvbnN0cnVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNlcnRNYW5hZ2VyPzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjcmVhdGVTZXJ2aWNlQWNjb3VudD86IGJvb2xlYW47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgc2VydmljZUFjY291bnROYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgY2x1c3Rlck5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBkZXBsb3ltZW50TmFtZTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgbmFtZXNwYWNlOiBzdHJpbmcgO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBvcHRpb25zOiBBd3NMb2FkQmFsYW5jZXJDb250cm9sbGVyT3B0aW9ucykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUgPSBvcHRpb25zPy5zZXJ2aWNlQWNjb3VudE5hbWUgPz8gJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXInO1xuICAgIHRoaXMuZGVwbG95bWVudE5hbWUgPSAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlcic7XG4gICAgdGhpcy5jbHVzdGVyTmFtZSA9IG9wdGlvbnMuY2x1c3Rlck5hbWU7XG4gICAgdGhpcy5uYW1lc3BhY2UgPSBvcHRpb25zPy5uYW1lc3BhY2UgPz8gJ2t1YmUtc3lzdGVtJztcbiAgICB0aGlzLmNyZWF0ZVNlcnZpY2VBY2NvdW50ID0gb3B0aW9ucz8uY3JlYXRlU2VydmljZUFjY291bnQgPz8gdHJ1ZTtcbiAgICB0aGlzLmNlcnRNYW5hZ2VyID0gb3B0aW9ucz8uY2VydE1hbmFnZXIgPz8gdHJ1ZTtcblxuICAgIGlmICh0aGlzLmNlcnRNYW5hZ2VyID09PSB0cnVlKSB7XG4gICAgICBuZXcgY2RrOHMuSW5jbHVkZSh0aGlzLCAnY2VydGlmaWNhdGUtbWFuYWdlcicsIHtcbiAgICAgICAgdXJsOiAnaHR0cHM6Ly9yYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tL0h1bnRlci1UaG9tcHNvbi9teS1ldGNkL21haW4vY2VydC1tYW5hZ2VyLXYxLjAuMi55YW1sJyxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIG5ldyBjZGs4cy5JbmNsdWRlKHRoaXMsICdhbGItY3JkcycsIHtcbiAgICAgIHVybDogcGF0aC5qb2luKF9fZGlybmFtZSwgJy4uL2NyZHMueWFtbCcpLFxuICAgIH0pO1xuXG4gICAgY29uc3Qgd2ViaG9va0Fubm90YXRpb25zOiB7W2tleTogc3RyaW5nXTogc3RyaW5nfSA9IG9wdGlvbnMuYXJnb0NlcnRJZ25vcmUgPyB7ICdjZXJ0LW1hbmFnZXIuaW8vaW5qZWN0LWNhLWZyb20nOiAna3ViZS1zeXN0ZW0vYXdzLWxvYWQtYmFsYW5jZXItc2VydmluZy1jZXJ0JywgJ2FyZ29jZC5hcmdvcHJvai5pby9jb21wYXJlLW9wdGlvbnMnOiAnSWdub3JlRXh0cmFuZW91cycsICdhcmdvY2QuYXJnb3Byb2ouaW8vaG9vayc6ICdTa2lwJyB9IDogeyAnY2VydC1tYW5hZ2VyLmlvL2luamVjdC1jYS1mcm9tJzogJ2t1YmUtc3lzdGVtL2F3cy1sb2FkLWJhbGFuY2VyLXNlcnZpbmctY2VydCcgfTtcblxuXG4gICAgbmV3IGs4cy5LdWJlTXV0YXRpbmdXZWJob29rQ29uZmlndXJhdGlvblYxQmV0YTEodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2snLCB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBhbm5vdGF0aW9uczogd2ViaG9va0Fubm90YXRpb25zLFxuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vaycsXG4gICAgICB9LFxuICAgICAgd2ViaG9va3M6IFtcbiAgICAgICAge1xuICAgICAgICAgIGNsaWVudENvbmZpZzoge1xuICAgICAgICAgICAgY2FCdW5kbGU6ICdDZz09JyxcbiAgICAgICAgICAgIHNlcnZpY2U6IHtcbiAgICAgICAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2stc2VydmljZScsXG4gICAgICAgICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICAgICAgICAgIHBhdGg6ICcvbXV0YXRlLXYxLXBvZCcsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgICAgZmFpbHVyZVBvbGljeTogJ0ZhaWwnLFxuICAgICAgICAgIG5hbWU6ICdtcG9kLmVsYnYyLms4cy5hd3MnLFxuICAgICAgICAgIG5hbWVzcGFjZVNlbGVjdG9yOiB7XG4gICAgICAgICAgICBtYXRjaEV4cHJlc3Npb25zOiBbXG4gICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICBrZXk6ICdlbGJ2Mi5rOHMuYXdzL3BvZC1yZWFkaW5lc3MtZ2F0ZS1pbmplY3QnLFxuICAgICAgICAgICAgICAgIG9wZXJhdG9yOiAnSW4nLFxuICAgICAgICAgICAgICAgIHZhbHVlczogWydlbmFibGVkJ10sXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBdLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgcnVsZXM6IFt7XG4gICAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgICBhcGlWZXJzaW9uczogWyd2MSddLFxuICAgICAgICAgICAgb3BlcmF0aW9uczogW1xuICAgICAgICAgICAgICAnQ1JFQVRFJyxcbiAgICAgICAgICAgIF0sXG4gICAgICAgICAgICByZXNvdXJjZXM6IFsncG9kcyddLFxuICAgICAgICAgIH1dLFxuICAgICAgICAgIHNpZGVFZmZlY3RzOiAnTm9uZScsXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBjbGllbnRDb25maWc6IHtcbiAgICAgICAgICAgIGNhQnVuZGxlOiAnQ2c9PScsXG4gICAgICAgICAgICBzZXJ2aWNlOiB7XG4gICAgICAgICAgICAgIG5hbWU6ICdhd3MtbG9hZC1iYWxhbmNlci13ZWJob29rLXNlcnZpY2UnLFxuICAgICAgICAgICAgICBuYW1lc3BhY2U6IHRoaXMubmFtZXNwYWNlLFxuICAgICAgICAgICAgICBwYXRoOiAnL211dGF0ZS1lbGJ2Mi1rOHMtYXdzLXYxYmV0YTEtdGFyZ2V0Z3JvdXBiaW5kaW5nJyxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgICBmYWlsdXJlUG9saWN5OiAnRmFpbCcsXG4gICAgICAgICAgbmFtZTogJ210YXJnZXRncm91cGJpbmRpbmcuZWxidjIuazhzLmF3cycsXG4gICAgICAgICAgcnVsZXM6IFt7XG4gICAgICAgICAgICBhcGlHcm91cHM6IFsnZWxidjIuazhzLmF3cyddLFxuICAgICAgICAgICAgYXBpVmVyc2lvbnM6IFsndjFiZXRhMSddLFxuICAgICAgICAgICAgb3BlcmF0aW9uczogW1xuICAgICAgICAgICAgICAnQ1JFQVRFJyxcbiAgICAgICAgICAgICAgJ1VQREFURScsXG4gICAgICAgICAgICBdLFxuICAgICAgICAgICAgcmVzb3VyY2VzOiBbJ3RhcmdldGdyb3VwYmluZGluZ3MnXSxcbiAgICAgICAgICB9XSxcbiAgICAgICAgICBzaWRlRWZmZWN0czogJ05vbmUnLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICB9KTtcbiAgICBpZiAob3B0aW9ucy5jcmVhdGVTZXJ2aWNlQWNjb3VudCA9PT0gdHJ1ZSkge1xuICAgICAgbmV3IGs4cy5LdWJlU2VydmljZUFjY291bnQodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItc2EnLCB7XG4gICAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ2NvbnRyb2xsZXInLFxuICAgICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgbmFtZTogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIG5ldyBrOHMuS3ViZVJvbGUodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItbGVhZGVyLWVsZWN0aW9uLXJvbGUnLCB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1sZWFkZXItZWxlY3Rpb24tcm9sZScsXG4gICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICB9LFxuICAgICAgcnVsZXM6IFtcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnY29uZmlnbWFwcyddLFxuICAgICAgICAgIHZlcmJzOiBbJ2NyZWF0ZSddLFxuICAgICAgICB9LCB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJyddLFxuICAgICAgICAgIHJlc291cmNlczogWydjb25maWdtYXBzJ10sXG4gICAgICAgICAgcmVzb3VyY2VOYW1lczogWydhd3MtbG9hZC1iYWxhbmNlci1jb250cm9sbGVyLWxlYWRlciddLFxuICAgICAgICAgIHZlcmJzOiBbJ2dldCcsICd1cGRhdGUnLCAncGF0Y2gnXSxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBuZXcgY2RrOHMuQXBpT2JqZWN0KHRoaXMsICdsZWFkZXItY2x1c3Rlci1yb2xlJywge1xuICAgICAgYXBpVmVyc2lvbjogJ3JiYWMuYXV0aG9yaXphdGlvbi5rOHMuaW8vdjEnLFxuICAgICAga2luZDogJ0NsdXN0ZXJSb2xlJyxcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIGxhYmVsczoge1xuICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgLi4ub3B0aW9ucy5sYWJlbHMsXG4gICAgICAgIH0sXG4gICAgICAgIG5hbWU6IGAke3RoaXMuc2VydmljZUFjY291bnROYW1lfS1yb2xlYCxcbiAgICAgIH0sXG4gICAgICBydWxlczogW1xuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJyddLFxuICAgICAgICAgIHJlc291cmNlczogWydlbmRwb2ludHMnXSxcbiAgICAgICAgICB2ZXJiczogW1xuICAgICAgICAgICAgJ2dldCcsXG4gICAgICAgICAgICAnbGlzdCcsXG4gICAgICAgICAgICAnd2F0Y2gnLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2V2ZW50cyddLFxuICAgICAgICAgIHZlcmJzOiBbXG4gICAgICAgICAgICAnY3JlYXRlJyxcbiAgICAgICAgICAgICdwYXRjaCcsXG4gICAgICAgICAgXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnbmFtZXNwYWNlcyddLFxuICAgICAgICAgIHZlcmJzOiBbXG4gICAgICAgICAgICAnZ2V0JyxcbiAgICAgICAgICAgICdsaXN0JyxcbiAgICAgICAgICAgICd3YXRjaCcsXG4gICAgICAgICAgXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnbm9kZXMnXSxcbiAgICAgICAgICB2ZXJiczogW1xuICAgICAgICAgICAgJ2dldCcsXG4gICAgICAgICAgICAnbGlzdCcsXG4gICAgICAgICAgICAnd2F0Y2gnLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ3BvZHMnXSxcbiAgICAgICAgICB2ZXJiczogW1xuICAgICAgICAgICAgJ2dldCcsXG4gICAgICAgICAgICAnbGlzdCcsXG4gICAgICAgICAgICAnd2F0Y2gnLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ3BvZHMvc3RhdHVzJ10sXG4gICAgICAgICAgdmVyYnM6IFtcbiAgICAgICAgICAgICdwYXRjaCcsXG4gICAgICAgICAgICAndXBkYXRlJyxcbiAgICAgICAgICBdLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJyddLFxuICAgICAgICAgIHJlc291cmNlczogWydzZWNyZXRzJ10sXG4gICAgICAgICAgdmVyYnM6IFtcbiAgICAgICAgICAgICdnZXQnLFxuICAgICAgICAgICAgJ2xpc3QnLFxuICAgICAgICAgICAgJ3dhdGNoJyxcbiAgICAgICAgICBdLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJyddLFxuICAgICAgICAgIHJlc291cmNlczogWydzZXJ2aWNlcyddLFxuICAgICAgICAgIHZlcmJzOiBbXG4gICAgICAgICAgICAnZ2V0JyxcbiAgICAgICAgICAgICdsaXN0JyxcbiAgICAgICAgICAgICdwYXRjaCcsXG4gICAgICAgICAgICAndXBkYXRlJyxcbiAgICAgICAgICAgICd3YXRjaCcsXG4gICAgICAgICAgXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnc2VydmljZXMvc3RhdHVzJ10sXG4gICAgICAgICAgdmVyYnM6IFtcbiAgICAgICAgICAgICdwYXRjaCcsXG4gICAgICAgICAgICAndXBkYXRlJyxcbiAgICAgICAgICBdLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJ2VsYnYyLms4cy5hd3MnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnaW5ncmVzc2NsYXNzcGFyYW1zJ10sXG4gICAgICAgICAgdmVyYnM6IFtcbiAgICAgICAgICAgICdnZXQnLFxuICAgICAgICAgICAgJ2xpc3QnLFxuICAgICAgICAgICAgJ3dhdGNoJyxcbiAgICAgICAgICBdLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJ2VsYnYyLms4cy5hd3MnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsndGFyZ2V0Z3JvdXBiaW5kaW5ncyddLFxuICAgICAgICAgIHZlcmJzOiBbXG4gICAgICAgICAgICAnY3JlYXRlJyxcbiAgICAgICAgICAgICdkZWxldGUnLFxuICAgICAgICAgICAgJ2dldCcsXG4gICAgICAgICAgICAnbGlzdCcsXG4gICAgICAgICAgICAncGF0Y2gnLFxuICAgICAgICAgICAgJ3VwZGF0ZScsXG4gICAgICAgICAgICAnd2F0Y2gnLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnZWxidjIuazhzLmF3cyddLFxuICAgICAgICAgIHJlc291cmNlczogWyd0YXJnZXRncm91cGJpbmRpbmdzL3N0YXR1cyddLFxuICAgICAgICAgIHZlcmJzOiBbXG4gICAgICAgICAgICAncGF0Y2gnLFxuICAgICAgICAgICAgJ3VwZGF0ZScsXG4gICAgICAgICAgXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWydleHRlbnNpb25zJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2luZ3Jlc3NlcyddLFxuICAgICAgICAgIHZlcmJzOiBbXG4gICAgICAgICAgICAnZ2V0JyxcbiAgICAgICAgICAgICdsaXN0JyxcbiAgICAgICAgICAgICdwYXRjaCcsXG4gICAgICAgICAgICAndXBkYXRlJyxcbiAgICAgICAgICAgICd3YXRjaCcsXG4gICAgICAgICAgXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWydleHRlbnNpb25zJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2luZ3Jlc3Nlcy9zdGF0dXMnXSxcbiAgICAgICAgICB2ZXJiczogW1xuICAgICAgICAgICAgJ3BhdGNoJyxcbiAgICAgICAgICAgICd1cGRhdGUnLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnbmV0d29ya2luZy5rOHMuaW8nXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnaW5ncmVzc2NsYXNzZXMnXSxcbiAgICAgICAgICB2ZXJiczogW1xuICAgICAgICAgICAgJ2dldCcsXG4gICAgICAgICAgICAnbGlzdCcsXG4gICAgICAgICAgICAnd2F0Y2gnLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnbmV0d29ya2luZy5rOHMuaW8nXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnaW5ncmVzc2VzJ10sXG4gICAgICAgICAgdmVyYnM6IFtcbiAgICAgICAgICAgICdnZXQnLFxuICAgICAgICAgICAgJ2xpc3QnLFxuICAgICAgICAgICAgJ3BhdGNoJyxcbiAgICAgICAgICAgICd1cGRhdGUnLFxuICAgICAgICAgICAgJ3dhdGNoJyxcbiAgICAgICAgICBdLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJ25ldHdvcmtpbmcuazhzLmlvJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2luZ3Jlc3Nlcy9zdGF0dXMnXSxcbiAgICAgICAgICB2ZXJiczogW1xuICAgICAgICAgICAgJ3BhdGNoJyxcbiAgICAgICAgICAgICd1cGRhdGUnLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgbmV3IGs4cy5LdWJlUm9sZUJpbmRpbmcodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItbGVhZGVyLWVsZWN0aW9uLXJvbGViaW5kaW5nJywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItbGVhZGVyLWVsZWN0aW9uLXJvbGViaW5kaW5nJyxcbiAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgIH0sXG4gICAgICByb2xlUmVmOiB7XG4gICAgICAgIGFwaUdyb3VwOiAncmJhYy5hdXRob3JpemF0aW9uLms4cy5pbycsXG4gICAgICAgIGtpbmQ6ICdSb2xlJyxcbiAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItbGVhZGVyLWVsZWN0aW9uLXJvbGUnLFxuICAgICAgfSxcbiAgICAgIHN1YmplY3RzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBraW5kOiAnU2VydmljZUFjY291bnQnLFxuICAgICAgICAgIG5hbWU6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgbmV3IGs4cy5LdWJlQ2x1c3RlclJvbGVCaW5kaW5nKHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci1jb250cm9sbGVyLXJvbGViaW5kaW5nJywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItcm9sZWJpbmRpbmcnLFxuICAgICAgfSxcbiAgICAgIHJvbGVSZWY6IHtcbiAgICAgICAgYXBpR3JvdXA6ICdyYmFjLmF1dGhvcml6YXRpb24uazhzLmlvJyxcbiAgICAgICAga2luZDogJ0NsdXN0ZXJSb2xlJyxcbiAgICAgICAgbmFtZTogYCR7dGhpcy5zZXJ2aWNlQWNjb3VudE5hbWV9LXJvbGVgLFxuICAgICAgfSxcbiAgICAgIHN1YmplY3RzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBraW5kOiAnU2VydmljZUFjY291bnQnLFxuICAgICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICAgICAgbmFtZTogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgbmV3IGs4cy5LdWJlU2VydmljZSh0aGlzLCAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vay1zZXJ2aWNlJywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2stc2VydmljZScsXG4gICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICBwb3J0czogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIHBvcnQ6IDQ0MyxcbiAgICAgICAgICAgIHRhcmdldFBvcnQ6IDk0NDMsXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgICAgc2VsZWN0b3I6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ2NvbnRyb2xsZXInLFxuICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgbmV3IGs4cy5LdWJlRGVwbG95bWVudCh0aGlzLCAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1kZXBsb3ltZW50Jywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL2NvbXBvbmVudCc6ICdjb250cm9sbGVyJyxcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lc3BhY2U6IHRoaXMubmFtZXNwYWNlLFxuICAgICAgICBuYW1lOiB0aGlzLmRlcGxveW1lbnROYW1lLFxuICAgICAgfSxcbiAgICAgIHNwZWM6IHtcbiAgICAgICAgcmVwbGljYXM6IG9wdGlvbnM/LnJlcGxpY2FzID8/IDEsXG4gICAgICAgIHNlbGVjdG9yOiB7XG4gICAgICAgICAgbWF0Y2hMYWJlbHM6IHtcbiAgICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9jb21wb25lbnQnOiAnY29udHJvbGxlcicsXG4gICAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgICAgLi4ub3B0aW9ucy5sYWJlbHMsXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgICAgdGVtcGxhdGU6IHtcbiAgICAgICAgICBtZXRhZGF0YToge1xuICAgICAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9jb21wb25lbnQnOiAnY29udHJvbGxlcicsXG4gICAgICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHNwZWM6IHtcbiAgICAgICAgICAgIGNvbnRhaW5lcnM6IFt7XG4gICAgICAgICAgICAgIG5hbWU6ICdjb250cm9sbGVyJyxcbiAgICAgICAgICAgICAgaW1hZ2U6IG9wdGlvbnM/LmltYWdlID8/ICdhbWF6b24vYXdzLWFsYi1pbmdyZXNzLWNvbnRyb2xsZXI6djIuMi4wJyxcbiAgICAgICAgICAgICAgYXJnczogdGhpcy5hcmdzRnVuYyhvcHRpb25zLmFyZ3MpLFxuICAgICAgICAgICAgICBlbnY6IHRoaXMuZW52RnVuYyhvcHRpb25zLmVudiksXG4gICAgICAgICAgICAgIGxpdmVuZXNzUHJvYmU6IHtcbiAgICAgICAgICAgICAgICBmYWlsdXJlVGhyZXNob2xkOiAyLFxuICAgICAgICAgICAgICAgIGh0dHBHZXQ6IHtcbiAgICAgICAgICAgICAgICAgIHBhdGg6ICcvaGVhbHRoeicsXG4gICAgICAgICAgICAgICAgICBwb3J0OiA2MTc3OSxcbiAgICAgICAgICAgICAgICAgIHNjaGVtZTogJ0hUVFAnLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgaW5pdGlhbERlbGF5U2Vjb25kczogMzAsXG4gICAgICAgICAgICAgICAgdGltZW91dFNlY29uZHM6IDEwLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBwb3J0czogW1xuICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgIGNvbnRhaW5lclBvcnQ6IDk0NDMsXG4gICAgICAgICAgICAgICAgICBuYW1lOiAnd2ViaG9vay1zZXJ2ZXInLFxuICAgICAgICAgICAgICAgICAgcHJvdG9jb2w6ICdUQ1AnLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIHJlc291cmNlczoge1xuICAgICAgICAgICAgICAgIGxpbWl0czoge1xuICAgICAgICAgICAgICAgICAgY3B1OiAnMjAwbScsXG4gICAgICAgICAgICAgICAgICBtZW1vcnk6ICc1MDBNaScsXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICByZXF1ZXN0czoge1xuICAgICAgICAgICAgICAgICAgY3B1OiAnMTAwbScsXG4gICAgICAgICAgICAgICAgICBtZW1vcnk6ICcyMDBNaScsXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgc2VjdXJpdHlDb250ZXh0OiB7XG4gICAgICAgICAgICAgICAgYWxsb3dQcml2aWxlZ2VFc2NhbGF0aW9uOiBmYWxzZSxcbiAgICAgICAgICAgICAgICByZWFkT25seVJvb3RGaWxlc3lzdGVtOiB0cnVlLFxuICAgICAgICAgICAgICAgIHJ1bkFzTm9uUm9vdDogdHJ1ZSxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgdm9sdW1lTW91bnRzOiBbXG4gICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgbW91bnRQYXRoOiAnL3RtcC9rOHMtd2ViaG9vay1zZXJ2ZXIvc2VydmluZy1jZXJ0cycsXG4gICAgICAgICAgICAgICAgICBuYW1lOiAnY2VydCcsXG4gICAgICAgICAgICAgICAgICByZWFkT25seTogdHJ1ZSxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgfV0sXG4gICAgICAgICAgICBzZWN1cml0eUNvbnRleHQ6IHtcbiAgICAgICAgICAgICAgZnNHcm91cDogMTMzNyxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBzZXJ2aWNlQWNjb3VudE5hbWU6IGAke3RoaXMuc2VydmljZUFjY291bnROYW1lfWAsXG4gICAgICAgICAgICB0ZXJtaW5hdGlvbkdyYWNlUGVyaW9kU2Vjb25kczogMTAsXG4gICAgICAgICAgICBwcmlvcml0eUNsYXNzTmFtZTogJ3N5c3RlbS1jbHVzdGVyLWNyaXRpY2FsJyxcbiAgICAgICAgICAgIHZvbHVtZXM6IFt7XG4gICAgICAgICAgICAgIG5hbWU6ICdjZXJ0JyxcbiAgICAgICAgICAgICAgc2VjcmV0OiB7XG4gICAgICAgICAgICAgICAgZGVmYXVsdE1vZGU6IDQyMCxcbiAgICAgICAgICAgICAgICBzZWNyZXROYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vay10bHMnLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfV0sXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBuZXcgY2RrOHMuQXBpT2JqZWN0KHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci1zZXJ2aW5nLWNlcnQnLCB7XG4gICAgICBhcGlWZXJzaW9uOiAnY2VydC1tYW5hZ2VyLmlvL3YxYWxwaGEyJyxcbiAgICAgIGtpbmQ6ICdDZXJ0aWZpY2F0ZScsXG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItc2VydmluZy1jZXJ0JyxcbiAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgIH0sXG4gICAgICBzcGVjOiB7XG4gICAgICAgIGRuc05hbWVzOiBbXG4gICAgICAgICAgJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2stc2VydmljZS5rdWJlLXN5c3RlbS5zdmMnLFxuICAgICAgICAgICdhd3MtbG9hZC1iYWxhbmNlci13ZWJob29rLXNlcnZpY2Uua3ViZS1zeXN0ZW0uc3ZjLmNsdXN0ZXIubG9jYWwnLFxuICAgICAgICBdLFxuICAgICAgICBpc3N1ZXJSZWY6IHtcbiAgICAgICAgICBraW5kOiAnSXNzdWVyJyxcbiAgICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItc2VsZnNpZ25lZC1pc3N1ZXInLFxuICAgICAgICB9LFxuICAgICAgICBzZWNyZXROYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vay10bHMnLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIG5ldyBjZGs4cy5BcGlPYmplY3QodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLXNlbGZzaWduZWQtaXNzdWVyJywge1xuICAgICAgYXBpVmVyc2lvbjogJ2NlcnQtbWFuYWdlci5pby92MWFscGhhMicsXG4gICAgICBraW5kOiAnSXNzdWVyJyxcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIGxhYmVsczoge1xuICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgLi4ub3B0aW9ucy5sYWJlbHMsXG4gICAgICAgIH0sXG4gICAgICAgIG5hbWU6ICdhd3MtbG9hZC1iYWxhbmNlci1zZWxmc2lnbmVkLWlzc3VlcicsXG4gICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICBzZWxmU2lnbmVkOiB7fSxcbiAgICAgIH0sXG4gICAgfSk7XG5cblxuICAgIG5ldyBrOHMuS3ViZVZhbGlkYXRpbmdXZWJob29rQ29uZmlndXJhdGlvblYxQmV0YTEodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLXNlbGZzaWduZWQtaXNzdWVyLXZhbGlkJywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgYW5ub3RhdGlvbnM6IHdlYmhvb2tBbm5vdGF0aW9ucyxcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2snLFxuICAgICAgfSxcbiAgICAgIHdlYmhvb2tzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBjbGllbnRDb25maWc6IHtcbiAgICAgICAgICAgIGNhQnVuZGxlOiAnQ2c9PScsXG4gICAgICAgICAgICBzZXJ2aWNlOiB7XG4gICAgICAgICAgICAgIG5hbWU6ICdhd3MtbG9hZC1iYWxhbmNlci13ZWJob29rLXNlcnZpY2UnLFxuICAgICAgICAgICAgICBuYW1lc3BhY2U6IHRoaXMubmFtZXNwYWNlLFxuICAgICAgICAgICAgICBwYXRoOiAnL3ZhbGlkYXRlLWVsYnYyLWs4cy1hd3MtdjFiZXRhMS10YXJnZXRncm91cGJpbmRpbmcnLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIGZhaWx1cmVQb2xpY3k6ICdGYWlsJyxcbiAgICAgICAgICBuYW1lOiAndnRhcmdldGdyb3VwYmluZGluZy5lbGJ2Mi5rOHMuYXdzJyxcbiAgICAgICAgICBydWxlczogW3tcbiAgICAgICAgICAgIGFwaUdyb3VwczogWydlbGJ2Mi5rOHMuYXdzJ10sXG4gICAgICAgICAgICBhcGlWZXJzaW9uczogWyd2MWJldGExJ10sXG4gICAgICAgICAgICBvcGVyYXRpb25zOiBbXG4gICAgICAgICAgICAgICdDUkVBVEUnLFxuICAgICAgICAgICAgICAnVVBEQVRFJyxcbiAgICAgICAgICAgIF0sXG4gICAgICAgICAgICByZXNvdXJjZXM6IFsndGFyZ2V0Z3JvdXBiaW5kaW5ncyddLFxuICAgICAgICAgIH1dLFxuICAgICAgICAgIHNpZGVFZmZlY3RzOiAnTm9uZScsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gIH1cbiAgcHJpdmF0ZSBhcmdzRnVuYyhhcmdzPzogc3RyaW5nW10pOnN0cmluZ1tdIHtcbiAgICBjb25zdCBkZWZhdWx0QXJncyA9IFsnLS1pbmdyZXNzLWNsYXNzPWFsYicsIGAtLWNsdXN0ZXItbmFtZT0ke3RoaXMuY2x1c3Rlck5hbWV9YF07XG4gICAgaWYgKGFyZ3MpIHtcbiAgICAgIGFyZ3MuZm9yRWFjaChlID0+IGRlZmF1bHRBcmdzLnB1c2goZSkpO1xuICAgIH1cbiAgICByZXR1cm4gZGVmYXVsdEFyZ3M7XG4gIH1cbiAgcHJpdmF0ZSBlbnZGdW5jKGVudlNldD86IEVudlZhcltdIHwgdW5kZWZpbmVkKTpFbnZWYXJbXSB8IHVuZGVmaW5lZCB7XG4gICAgcmV0dXJuIGVudlNldDtcbiAgfVxufVxuIl19