"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DependenciesUpgradeMechanism = exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const github_1 = require("./github");
const ignore_file_1 = require("./ignore-file");
const projenrc_1 = require("./javascript/projenrc");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const publisher_1 = require("./publisher");
const tasks_1 = require("./tasks");
const upgrade_dependencies_1 = require("./upgrade-dependencies");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_c = options.workflowNodeVersion) !== null && _c !== void 0 ? _c : this.package.minNodeVersion;
        this._version = new version_1.Version(this, {
            initialVersion: options.initialVersion,
        });
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        // first, execute projen as the first thing during build
        if ((_d = options.projenDuringBuild) !== null && _d !== void 0 ? _d : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_e = options.npmignoreEnabled) !== null && _e !== void 0 ? _e : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_f = options.gitignore) === null || _f === void 0 ? void 0 : _f.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_g = options.npmignore) === null || _g === void 0 ? void 0 : _g.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_h = this.npmignore) === null || _h === void 0 ? void 0 : _h.exclude(`/${common_1.PROJEN_RC}`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_k = options.projenDevDependency) !== null && _k !== void 0 ? _k : true;
        if (projen) {
            const projenVersion = (_l = options.projenVersion) !== null && _l !== void 0 ? _l : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_m = options.buildWorkflow) !== null && _m !== void 0 ? _m : (this.parent ? false : true);
        const mutableBuilds = (_o = options.mutableBuild) !== null && _o !== void 0 ? _o : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_p = options.antitamper) !== null && _p !== void 0 ? _p : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_q = options.jest) !== null && _q !== void 0 ? _q : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_r = options.buildWorkflow) !== null && _r !== void 0 ? _r : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const updateRepo = new Array();
            const gitDiffStepId = 'git_diff';
            const hasChangesCondName = 'has_changes';
            const hasChanges = `steps.${gitDiffStepId}.outputs.${hasChangesCondName}`;
            const repoFullName = 'github.event.pull_request.head.repo.full_name';
            // use "git diff --exit code" to check if there were changes in the repo
            // and create a step output that will be used in subsequent steps.
            updateRepo.push({
                name: 'Check for changes',
                id: gitDiffStepId,
                run: `git diff --exit-code || echo "::set-output name=${hasChangesCondName}::true"`,
            });
            // only if we had changes, commit them and push to the repo note that for
            // forks, this will fail (because the workflow doesn't have permissions.
            // this indicates to users that they need to update their branch manually.
            updateRepo.push({
                if: hasChanges,
                name: 'Commit and push changes (if changed)',
                run: `git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch}`,
            });
            // if we pushed changes, we need to manually update the status check so
            // that the PR will be green (we won't get here for forks with updates
            // because the push would have failed).
            updateRepo.push({
                if: hasChanges,
                name: 'Update status check (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/\${{ ${repoFullName} }}/check-runs`,
                    `-F name="${buildJobId}"`,
                    '-F head_sha="$(git rev-parse HEAD)"',
                    '-F status="completed"',
                    '-F conclusion="success"',
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            const workflow = this.createBuildWorkflow('Build', {
                jobId: buildJobId,
                trigger: {
                    pull_request: {},
                },
                checkoutWith: mutableBuilds ? {
                    ref: branch,
                    repository: repo,
                } : undefined,
                postSteps: updateRepo,
                antitamperDisabled: mutableBuilds,
                image: options.workflowContainerImage,
                codeCov: (_s = options.codeCov) !== null && _s !== void 0 ? _s : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        if ((_t = options.releaseWorkflow) !== null && _t !== void 0 ? _t : (this.parent ? false : true)) {
            const defaultReleaseBranch = (_u = options.defaultReleaseBranch) !== null && _u !== void 0 ? _u : 'main';
            const releaseBranches = (_v = options.releaseBranches) !== null && _v !== void 0 ? _v : [defaultReleaseBranch];
            const trigger = {};
            if ((_w = options.releaseEveryCommit) !== null && _w !== void 0 ? _w : true) {
                trigger.push = { branches: releaseBranches };
            }
            if (options.releaseSchedule) {
                trigger.schedule = { cron: options.releaseSchedule };
            }
            const artifactDirectory = (_x = options.artifactsDirectory) !== null && _x !== void 0 ? _x : 'dist';
            const getVersion = 'v$(node -p \"require(\'./package.json\').version\")';
            const jobId = 'release';
            const releaseSteps = [];
            // to avoid race conditions between two commits trying to release the same
            // version, we check if the head sha is identical to the remote sha. if
            // not, we will skip the release and just finish the build.
            const gitRemoteStep = 'git_remote';
            const latestCommitOutput = 'latest_commit';
            const noNewCommits = `\${{ steps.${gitRemoteStep}.outputs.${latestCommitOutput} == github.sha }}`;
            releaseSteps.push({
                name: 'Check for new commits',
                id: gitRemoteStep,
                run: `echo ::set-output name=${latestCommitOutput}::"$(git ls-remote origin -h \${{ github.ref }} | cut -f1)"`,
            });
            releaseSteps.push({
                name: 'Create release',
                if: noNewCommits,
                run: [
                    `gh release create ${getVersion}`,
                    `-F ${this._version.changelogFile}`,
                    `-t ${getVersion}`,
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            releaseSteps.push({
                name: 'Unbump',
                run: this.runTaskCommand(this._version.unbumpTask),
            });
            releaseSteps.push({
                name: 'Upload artifact',
                if: noNewCommits,
                uses: 'actions/upload-artifact@v2.1.1',
                with: {
                    name: artifactDirectory,
                    path: artifactDirectory,
                },
            });
            const workflow = this.createBuildWorkflow('Release', {
                jobId: jobId,
                trigger,
                env: {
                    RELEASE: 'true',
                },
                preBuildSteps: [
                    {
                        name: 'Bump to next version',
                        run: this.runTaskCommand(this._version.bumpTask),
                    },
                    ...(_y = options.releaseWorkflowSetupSteps) !== null && _y !== void 0 ? _y : [],
                ],
                postSteps: releaseSteps,
                image: options.workflowContainerImage,
                codeCov: false,
                checkoutWith: {
                    // we must use 'fetch-depth=0' in order to fetch all tags
                    // otherwise tags are not checked out
                    'fetch-depth': 0,
                },
            });
            this.releaseWorkflow = workflow;
            this.publisher = new publisher_1.Publisher(this, {
                workflow: this.releaseWorkflow,
                artifactName: artifactDirectory,
                buildJobId: jobId,
                jsiiReleaseVersion: options.jsiiReleaseVersion,
            });
            if ((_z = options.releaseToNpm) !== null && _z !== void 0 ? _z : false) {
                this.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseBranches) {
                throw new Error('"releaseBranches" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_0 = this.github) === null || _0 === void 0 ? void 0 : _0.mergify) {
            this.autoMerge = new github_1.AutoMerge(this, {
                buildJob: this.buildWorkflowJobId,
                autoMergeLabel: options.mergifyAutoMergeLabel,
            });
            (_1 = this.npmignore) === null || _1 === void 0 ? void 0 : _1.exclude('/.mergify.yml');
        }
        if (options.dependabot !== undefined && options.depsUpgrade) {
            throw new Error("'dependabot' cannot be configured together with 'depsUpgrade'");
        }
        const defaultDependenciesUpgrade = ((_2 = options.dependabot) !== null && _2 !== void 0 ? _2 : false) ? DependenciesUpgradeMechanism.dependabot()
            : DependenciesUpgradeMechanism.githubWorkflow();
        const dependenciesUpgrade = (_3 = options.depsUpgrade) !== null && _3 !== void 0 ? _3 : defaultDependenciesUpgrade;
        dependenciesUpgrade.bind(this);
        if (dependenciesUpgrade.ignoresProjen && this.package.packageName !== 'projen') {
            const projenAutoMerge = (_4 = options.projenUpgradeAutoMerge) !== null && _4 !== void 0 ? _4 : true;
            new upgrade_dependencies_1.UpgradeDependencies(this, {
                include: ['projen'],
                taskName: 'upgrade-projen',
                ignoreProjen: false,
                workflow: !!options.projenUpgradeSecret,
                workflowOptions: {
                    schedule: upgrade_dependencies_1.UpgradeDependenciesSchedule.expressions((_5 = options.projenUpgradeSchedule) !== null && _5 !== void 0 ? _5 : ['0 6 * * *']),
                    secret: options.projenUpgradeSecret,
                    labels: (projenAutoMerge && ((_6 = this.autoMerge) === null || _6 === void 0 ? void 0 : _6.autoMergeLabel))
                        ? [this.autoMerge.autoMergeLabel]
                        : [],
                },
            });
        }
        if ((_7 = options.pullRequestTemplate) !== null && _7 !== void 0 ? _7 : true) {
            (_8 = this.github) === null || _8 === void 0 ? void 0 : _8.addPullRequestTemplate(...(_9 = options.pullRequestTemplateContents) !== null && _9 !== void 0 ? _9 : []);
        }
        const projenrcJs = (_10 = options.projenrcJs) !== null && _10 !== void 0 ? _10 : true;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (deprecated) Determines how tasks are executed when invoked as npm scripts (yarn/npm run xyz).
     *
     * @deprecated use `package.npmTaskExecution`
     */
    get npmTaskExecution() { return this.package.npmTaskExecution; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addLicense(options) {
        var _c;
        if (this.package.license) {
            new license_1.License(this, this.package.license, {
                copyrightOwner: (_c = options.copyrightOwner) !== null && _c !== void 0 ? _c : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _c, _d, _e, _f, _g;
        const buildJobId = options.jobId;
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflow_dispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_c = options.preBuildSteps) !== null && _c !== void 0 ? _c : [];
        const preCheckoutSteps = (_d = options.preCheckoutSteps) !== null && _d !== void 0 ? _d : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_e = options.postSteps) !== null && _e !== void 0 ? _e : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --ignore-space-at-eol --exit-code',
            }];
        const job = {
            'runs-on': 'ubuntu-latest',
            'env': {
                CI: 'true',
                ...(_f = options.env) !== null && _f !== void 0 ? _f : {},
            },
            ...condition,
            'steps': [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Automation"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_g = this.jest) === null || _g === void 0 ? void 0 : _g.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                ...postSteps,
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        workflow.addJobs({ [buildJobId]: job });
        return workflow;
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        switch (this.package.npmTaskExecution) {
            case node_package_1.NpmTaskExecution.PROJEN: return `${this.package.projenCommand} ${task.name}`;
            case node_package_1.NpmTaskExecution.SHELL: return `${this.runScriptCommand} ${task.name}`;
            default:
                throw new Error(`invalid npmTaskExecution mode: ${this.package.npmTaskExecution}`);
        }
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.17.95" };
/**
 * (experimental) Dependencies upgrade mechanism.
 *
 * @experimental
 */
class DependenciesUpgradeMechanism {
    constructor(binder, _ignoresProjen) {
        this.binder = binder;
        this._ignoresProjen = _ignoresProjen;
    }
    /**
     * (experimental) Upgrade via dependabot.
     *
     * @experimental
     */
    static dependabot(options = {}) {
        return new DependenciesUpgradeMechanism((project) => {
            var _c;
            (_c = project.github) === null || _c === void 0 ? void 0 : _c.addDependabot(options);
        }, options.ignoreProjen);
    }
    /**
     * (experimental) Upgrade via a custom github workflow.
     *
     * @experimental
     */
    static githubWorkflow(options = {}) {
        return new DependenciesUpgradeMechanism((project) => {
            new upgrade_dependencies_1.UpgradeDependencies(project, options);
        }, options.ignoreProjen);
    }
    /**
     * @experimental
     */
    get ignoresProjen() {
        var _c;
        // we ignore projen by default because it requires 'workflow' permissions to run.
        // nor depenedabot nor the default github token has those permissions.
        return (_c = this._ignoresProjen) !== null && _c !== void 0 ? _c : true;
    }
    /**
     * @experimental
     */
    bind(project) {
        this.binder(project);
    }
}
exports.DependenciesUpgradeMechanism = DependenciesUpgradeMechanism;
_b = JSII_RTTI_SYMBOL_1;
DependenciesUpgradeMechanism[_b] = { fqn: "projen.DependenciesUpgradeMechanism", version: "0.17.95" };
/**
 * (experimental) Disable.
 *
 * @experimental
 */
DependenciesUpgradeMechanism.NONE = new DependenciesUpgradeMechanism((_) => ({}), true);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9kZS1wcm9qZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL25vZGUtcHJvamVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHFDQUFpRTtBQUNqRSxxQ0FBd0U7QUFFeEUsK0NBQTJDO0FBQzNDLG9EQUFrRTtBQUNsRSxpQ0FBMkM7QUFDM0MsdUNBQW9DO0FBQ3BDLGlEQUF1RztBQUN2Ryx1Q0FBb0Q7QUFDcEQsMkNBQXdDO0FBQ3hDLG1DQUE2QztBQUM3QyxpRUFBc0g7QUFDdEgsdUNBQW9DO0FBRXBDLE1BQU0sYUFBYSxHQUFHLFFBQVEsQ0FBQzs7Ozs7O0FBc1QvQixJQUFZLFdBVVg7QUFWRCxXQUFZLFdBQVc7SUFJckIsNkRBQVksQ0FBQTtJQUtaLCtDQUFLLENBQUE7QUFDUCxDQUFDLEVBVlcsV0FBVyxHQUFYLG1CQUFXLEtBQVgsbUJBQVcsUUFVdEI7Ozs7OztBQUtELE1BQWEsV0FBWSxTQUFRLGlCQUFPOzs7O0lBZ0l0QyxZQUFZLE9BQTJCOztRQUNyQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksMEJBQVcsQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFFOUMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLENBQUMsR0FBRyxFQUFFO1lBQzVCLFFBQVEsSUFBSSxDQUFDLGNBQWMsRUFBRTtnQkFDM0IsS0FBSyxpQ0FBa0IsQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLFNBQVMsQ0FBQztnQkFDOUMsS0FBSyxpQ0FBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLFVBQVUsQ0FBQztnQkFDaEQsS0FBSyxpQ0FBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLFVBQVUsQ0FBQztnQkFDaEQsT0FBTyxDQUFDLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyw4QkFBOEIsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDLENBQUM7YUFDL0U7UUFDSCxDQUFDLENBQUMsRUFBRSxDQUFDO1FBRUwsSUFBSSxDQUFDLFdBQVcsU0FBRyxPQUFPLENBQUMsbUJBQW1CLG1DQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDO1FBRTlFLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxpQkFBTyxDQUFDLElBQUksRUFBRTtZQUNoQyxjQUFjLEVBQUUsT0FBTyxDQUFDLGNBQWM7U0FDdkMsQ0FBQyxDQUFDO1FBRUgsb0VBQW9FO1FBQ3BFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLE1BQU0sRUFBRSwyREFBMkQsQ0FBQyxDQUFDO1FBRS9GLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLEVBQUU7WUFDekMsV0FBVyxFQUFFLGNBQWM7WUFDM0IsUUFBUSxFQUFFLG9CQUFZLENBQUMsS0FBSztTQUM3QixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFO1lBQ2xELFdBQVcsRUFBRSx3QkFBd0I7WUFDckMsUUFBUSxFQUFFLG9CQUFZLENBQUMsSUFBSTtTQUM1QixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFO1lBQ25DLFdBQVcsRUFBRSxXQUFXO1lBQ3hCLFFBQVEsRUFBRSxvQkFBWSxDQUFDLElBQUk7U0FDNUIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBRTFDLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUU7WUFDckMsV0FBVyxFQUFFLG1DQUFtQztZQUNoRCxRQUFRLEVBQUUsb0JBQVksQ0FBQyxLQUFLO1NBQzdCLENBQUMsQ0FBQztRQUVILHdEQUF3RDtRQUN4RCxVQUFJLE9BQU8sQ0FBQyxpQkFBaUIsbUNBQUksSUFBSSxFQUFFO1lBQ3JDLHNFQUFzRTtZQUN0RSw2Q0FBNkM7WUFDN0MsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7Z0JBQ2hCLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQzthQUN6QztTQUNGO1FBRUQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUV6QixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDO1FBQzFDLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUM7UUFFNUMsVUFBSSxPQUFPLENBQUMsZ0JBQWdCLG1DQUFJLElBQUksRUFBRTtZQUNwQyxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksd0JBQVUsQ0FBQyxJQUFJLEVBQUUsWUFBWSxDQUFDLENBQUM7U0FDckQ7UUFFRCxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztRQUUzQixVQUFJLE9BQU8sQ0FBQyxTQUFTLDBDQUFFLE1BQU0sRUFBRTtZQUM3QixLQUFLLE1BQU0sQ0FBQyxJQUFJLE9BQU8sQ0FBQyxTQUFTLEVBQUU7Z0JBQ2pDLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQzNCO1NBQ0Y7UUFFRCxVQUFJLE9BQU8sQ0FBQyxTQUFTLDBDQUFFLE1BQU0sRUFBRTtZQUM3QixJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRTtnQkFDbkIsTUFBTSxJQUFJLEtBQUssQ0FBQywyRkFBMkYsQ0FBQyxDQUFDO2FBQzlHO1lBRUQsS0FBSyxNQUFNLENBQUMsSUFBSSxPQUFPLENBQUMsU0FBUyxFQUFFO2dCQUNqQyxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQzthQUMzQjtTQUNGO1FBR0QsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUMxRCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sRUFBRSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxRQUFRLENBQUMsQ0FBQztRQUUvRCxNQUFBLElBQUksQ0FBQyxTQUFTLDBDQUFFLE9BQU8sQ0FBQyxJQUFJLGtCQUFTLEVBQUUsRUFBRTtRQUN6QyxNQUFBLElBQUksQ0FBQyxTQUFTLDBDQUFFLE9BQU8sQ0FBQyxJQUFJLG1CQUFVLEVBQUUsRUFBRTtRQUMxQyxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxJQUFJLGtCQUFTLEVBQUUsQ0FBQyxDQUFDO1FBRXhDLE1BQU0sTUFBTSxTQUFHLE9BQU8sQ0FBQyxtQkFBbUIsbUNBQUksSUFBSSxDQUFDO1FBQ25ELElBQUksTUFBTSxFQUFFO1lBQ1YsTUFBTSxhQUFhLFNBQUcsT0FBTyxDQUFDLGFBQWEsbUNBQUksSUFBSSx1QkFBYyxFQUFFLENBQUM7WUFDcEUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLGFBQWEsRUFBRSxDQUFDLENBQUM7U0FDNUM7UUFFRCxJQUFJLENBQUMsT0FBTyxDQUFDLG9CQUFvQixFQUFFO1lBQ2pDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztTQUN2STtRQUVELE1BQU0sWUFBWSxTQUFHLE9BQU8sQ0FBQyxhQUFhLG1DQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMzRSxNQUFNLGFBQWEsU0FBRyxPQUFPLENBQUMsWUFBWSxtQ0FBSSxJQUFJLENBQUM7UUFFbkQsaUZBQWlGO1FBQ2pGLHVEQUF1RDtRQUN2RCxJQUFJLENBQUMsVUFBVSxHQUFHLFlBQVksSUFBSSxPQUFDLE9BQU8sQ0FBQyxVQUFVLG1DQUFJLElBQUksQ0FBQyxDQUFDO1FBRS9ELDRCQUE0QjtRQUM1Qiw2Q0FBNkM7UUFDN0MsVUFBSSxPQUFPLENBQUMsSUFBSSxtQ0FBSSxJQUFJLEVBQUU7WUFDeEIsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLFdBQUksQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1NBQ2pEO1FBRUQsVUFBSSxPQUFPLENBQUMsYUFBYSxtQ0FBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDekQsTUFBTSxNQUFNLEdBQUcsMkNBQTJDLENBQUM7WUFDM0QsTUFBTSxJQUFJLEdBQUcsc0RBQXNELENBQUM7WUFDcEUsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDO1lBRTNCLE1BQU0sVUFBVSxHQUFHLElBQUksS0FBSyxFQUFPLENBQUM7WUFDcEMsTUFBTSxhQUFhLEdBQUcsVUFBVSxDQUFDO1lBQ2pDLE1BQU0sa0JBQWtCLEdBQUcsYUFBYSxDQUFDO1lBQ3pDLE1BQU0sVUFBVSxHQUFHLFNBQVMsYUFBYSxZQUFZLGtCQUFrQixFQUFFLENBQUM7WUFDMUUsTUFBTSxZQUFZLEdBQUcsK0NBQStDLENBQUM7WUFFckUsd0VBQXdFO1lBQ3hFLGtFQUFrRTtZQUNsRSxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNkLElBQUksRUFBRSxtQkFBbUI7Z0JBQ3pCLEVBQUUsRUFBRSxhQUFhO2dCQUNqQixHQUFHLEVBQUUsbURBQW1ELGtCQUFrQixTQUFTO2FBQ3BGLENBQUMsQ0FBQztZQUVILHlFQUF5RTtZQUN6RSx3RUFBd0U7WUFDeEUsMEVBQTBFO1lBQzFFLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ2QsRUFBRSxFQUFFLFVBQVU7Z0JBQ2QsSUFBSSxFQUFFLHNDQUFzQztnQkFDNUMsR0FBRyxFQUFFLDZFQUE2RSxNQUFNLEVBQUU7YUFDM0YsQ0FBQyxDQUFDO1lBRUgsdUVBQXVFO1lBQ3ZFLHNFQUFzRTtZQUN0RSx1Q0FBdUM7WUFDdkMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDZCxFQUFFLEVBQUUsVUFBVTtnQkFDZCxJQUFJLEVBQUUsa0NBQWtDO2dCQUN4QyxHQUFHLEVBQUU7b0JBQ0gsUUFBUTtvQkFDUixTQUFTO29CQUNULGVBQWUsWUFBWSxnQkFBZ0I7b0JBQzNDLFlBQVksVUFBVSxHQUFHO29CQUN6QixxQ0FBcUM7b0JBQ3JDLHVCQUF1QjtvQkFDdkIseUJBQXlCO2lCQUMxQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7Z0JBQ1gsR0FBRyxFQUFFO29CQUNILFlBQVksRUFBRSw2QkFBNkI7aUJBQzVDO2FBQ0YsQ0FBQyxDQUFDO1lBRUgsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRTtnQkFDakQsS0FBSyxFQUFFLFVBQVU7Z0JBQ2pCLE9BQU8sRUFBRTtvQkFDUCxZQUFZLEVBQUUsRUFBRztpQkFDbEI7Z0JBRUQsWUFBWSxFQUFFLGFBQWEsQ0FBQyxDQUFDLENBQUM7b0JBQzVCLEdBQUcsRUFBRSxNQUFNO29CQUNYLFVBQVUsRUFBRSxJQUFJO2lCQUNqQixDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUViLFNBQVMsRUFBRSxVQUFVO2dCQUVyQixrQkFBa0IsRUFBRSxhQUFhO2dCQUNqQyxLQUFLLEVBQUUsT0FBTyxDQUFDLHNCQUFzQjtnQkFDckMsT0FBTyxRQUFFLE9BQU8sQ0FBQyxPQUFPLG1DQUFJLEtBQUs7Z0JBQ2pDLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxrQkFBa0I7YUFDL0MsQ0FBQyxDQUFDO1lBRUgsSUFBSSxDQUFDLGFBQWEsR0FBRyxRQUFRLENBQUM7WUFDOUIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFVBQVUsQ0FBQztTQUN0QztRQUVELFVBQUksT0FBTyxDQUFDLGVBQWUsbUNBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxFQUFFO1lBQzNELE1BQU0sb0JBQW9CLFNBQUcsT0FBTyxDQUFDLG9CQUFvQixtQ0FBSSxNQUFNLENBQUM7WUFDcEUsTUFBTSxlQUFlLFNBQUcsT0FBTyxDQUFDLGVBQWUsbUNBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1lBRTFFLE1BQU0sT0FBTyxHQUE2QixFQUFHLENBQUM7WUFFOUMsVUFBSSxPQUFPLENBQUMsa0JBQWtCLG1DQUFJLElBQUksRUFBRTtnQkFDdEMsT0FBTyxDQUFDLElBQUksR0FBRyxFQUFFLFFBQVEsRUFBRSxlQUFlLEVBQUUsQ0FBQzthQUM5QztZQUVELElBQUksT0FBTyxDQUFDLGVBQWUsRUFBRTtnQkFDM0IsT0FBTyxDQUFDLFFBQVEsR0FBRyxFQUFFLElBQUksRUFBRSxPQUFPLENBQUMsZUFBZSxFQUFFLENBQUM7YUFDdEQ7WUFFRCxNQUFNLGlCQUFpQixTQUFHLE9BQU8sQ0FBQyxrQkFBa0IsbUNBQUksTUFBTSxDQUFDO1lBQy9ELE1BQU0sVUFBVSxHQUFHLHFEQUFxRCxDQUFDO1lBQ3pFLE1BQU0sS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUV4QixNQUFNLFlBQVksR0FBVSxFQUFFLENBQUM7WUFFL0IsMEVBQTBFO1lBQzFFLHVFQUF1RTtZQUN2RSwyREFBMkQ7WUFDM0QsTUFBTSxhQUFhLEdBQUcsWUFBWSxDQUFDO1lBQ25DLE1BQU0sa0JBQWtCLEdBQUcsZUFBZSxDQUFDO1lBQzNDLE1BQU0sWUFBWSxHQUFHLGNBQWMsYUFBYSxZQUFZLGtCQUFrQixtQkFBbUIsQ0FBQztZQUVsRyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNoQixJQUFJLEVBQUUsdUJBQXVCO2dCQUM3QixFQUFFLEVBQUUsYUFBYTtnQkFDakIsR0FBRyxFQUFFLDBCQUEwQixrQkFBa0IsNkRBQTZEO2FBQy9HLENBQUMsQ0FBQztZQUVILFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2hCLElBQUksRUFBRSxnQkFBZ0I7Z0JBQ3RCLEVBQUUsRUFBRSxZQUFZO2dCQUNoQixHQUFHLEVBQUU7b0JBQ0gscUJBQXFCLFVBQVUsRUFBRTtvQkFDakMsTUFBTSxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRTtvQkFDbkMsTUFBTSxVQUFVLEVBQUU7aUJBQ25CLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztnQkFDWCxHQUFHLEVBQUU7b0JBQ0gsWUFBWSxFQUFFLDZCQUE2QjtpQkFDNUM7YUFDRixDQUFDLENBQUM7WUFFSCxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNoQixJQUFJLEVBQUUsUUFBUTtnQkFDZCxHQUFHLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQzthQUNuRCxDQUFDLENBQUM7WUFFSCxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNoQixJQUFJLEVBQUUsaUJBQWlCO2dCQUN2QixFQUFFLEVBQUUsWUFBWTtnQkFDaEIsSUFBSSxFQUFFLGdDQUFnQztnQkFDdEMsSUFBSSxFQUFFO29CQUNKLElBQUksRUFBRSxpQkFBaUI7b0JBQ3ZCLElBQUksRUFBRSxpQkFBaUI7aUJBQ3hCO2FBQ0YsQ0FBQyxDQUFDO1lBRUgsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLFNBQVMsRUFBRTtnQkFDbkQsS0FBSyxFQUFFLEtBQUs7Z0JBQ1osT0FBTztnQkFDUCxHQUFHLEVBQUU7b0JBQ0gsT0FBTyxFQUFFLE1BQU07aUJBQ2hCO2dCQUNELGFBQWEsRUFBRTtvQkFDYjt3QkFDRSxJQUFJLEVBQUUsc0JBQXNCO3dCQUM1QixHQUFHLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQztxQkFDakQ7b0JBQ0QsU0FBRyxPQUFPLENBQUMseUJBQXlCLG1DQUFJLEVBQUU7aUJBQzNDO2dCQUNELFNBQVMsRUFBRSxZQUFZO2dCQUN2QixLQUFLLEVBQUUsT0FBTyxDQUFDLHNCQUFzQjtnQkFDckMsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsWUFBWSxFQUFFO29CQUNaLHlEQUF5RDtvQkFDekQscUNBQXFDO29CQUNyQyxhQUFhLEVBQUUsQ0FBQztpQkFDakI7YUFDRixDQUFDLENBQUM7WUFFSCxJQUFJLENBQUMsZUFBZSxHQUFHLFFBQVEsQ0FBQztZQUVoQyxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUkscUJBQVMsQ0FBQyxJQUFJLEVBQUU7Z0JBQ25DLFFBQVEsRUFBRSxJQUFJLENBQUMsZUFBZTtnQkFDOUIsWUFBWSxFQUFFLGlCQUFpQjtnQkFDL0IsVUFBVSxFQUFFLEtBQUs7Z0JBQ2pCLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxrQkFBa0I7YUFDL0MsQ0FBQyxDQUFDO1lBRUgsVUFBSSxPQUFPLENBQUMsWUFBWSxtQ0FBSSxLQUFLLEVBQUU7Z0JBQ2pDLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDO29CQUMxQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVO29CQUNoQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXO29CQUNsQyxjQUFjLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjO2lCQUM1QyxDQUFDLENBQUM7YUFDSjtTQUNGO2FBQU07WUFDTCxxRkFBcUY7WUFDckYsSUFBSSxPQUFPLENBQUMsWUFBWSxFQUFFO2dCQUN4QixNQUFNLElBQUksS0FBSyxDQUFDLGtEQUFrRCxDQUFDLENBQUM7YUFDckU7WUFFRCxJQUFJLE9BQU8sQ0FBQyxlQUFlLEVBQUU7Z0JBQzNCLE1BQU0sSUFBSSxLQUFLLENBQUMscURBQXFELENBQUMsQ0FBQzthQUN4RTtZQUVELElBQUksT0FBTyxDQUFDLGtCQUFrQixFQUFFO2dCQUM5QixNQUFNLElBQUksS0FBSyxDQUFDLHdEQUF3RCxDQUFDLENBQUM7YUFDM0U7WUFFRCxJQUFJLE9BQU8sQ0FBQyxlQUFlLEVBQUU7Z0JBQzNCLE1BQU0sSUFBSSxLQUFLLENBQUMscURBQXFELENBQUMsQ0FBQzthQUN4RTtTQUNGO1FBRUQsVUFBSSxJQUFJLENBQUMsTUFBTSwwQ0FBRSxPQUFPLEVBQUU7WUFDeEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLGtCQUFTLENBQUMsSUFBSSxFQUFFO2dCQUNuQyxRQUFRLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtnQkFDakMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxxQkFBcUI7YUFDOUMsQ0FBQyxDQUFDO1lBQ0gsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsZUFBZSxFQUFFO1NBQzFDO1FBRUQsSUFBSSxPQUFPLENBQUMsVUFBVSxLQUFLLFNBQVMsSUFBSSxPQUFPLENBQUMsV0FBVyxFQUFFO1lBQzNELE1BQU0sSUFBSSxLQUFLLENBQUMsK0RBQStELENBQUMsQ0FBQztTQUNsRjtRQUVELE1BQU0sMEJBQTBCLEdBQUcsT0FBQyxPQUFPLENBQUMsVUFBVSxtQ0FBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsNEJBQTRCLENBQUMsVUFBVSxFQUFFO1lBQzFHLENBQUMsQ0FBQyw0QkFBNEIsQ0FBQyxjQUFjLEVBQUUsQ0FBQztRQUNsRCxNQUFNLG1CQUFtQixTQUFHLE9BQU8sQ0FBQyxXQUFXLG1DQUFJLDBCQUEwQixDQUFDO1FBQzlFLG1CQUFtQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUUvQixJQUFJLG1CQUFtQixDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsS0FBSyxRQUFRLEVBQUU7WUFFOUUsTUFBTSxlQUFlLFNBQUcsT0FBTyxDQUFDLHNCQUFzQixtQ0FBSSxJQUFJLENBQUM7WUFFL0QsSUFBSSwwQ0FBbUIsQ0FBQyxJQUFJLEVBQUU7Z0JBQzVCLE9BQU8sRUFBRSxDQUFDLFFBQVEsQ0FBQztnQkFDbkIsUUFBUSxFQUFFLGdCQUFnQjtnQkFDMUIsWUFBWSxFQUFFLEtBQUs7Z0JBQ25CLFFBQVEsRUFBRSxDQUFDLENBQUMsT0FBTyxDQUFDLG1CQUFtQjtnQkFDdkMsZUFBZSxFQUFFO29CQUNmLFFBQVEsRUFBRSxrREFBMkIsQ0FBQyxXQUFXLE9BQUMsT0FBTyxDQUFDLHFCQUFxQixtQ0FBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO29CQUNqRyxNQUFNLEVBQUUsT0FBTyxDQUFDLG1CQUFtQjtvQkFDbkMsTUFBTSxFQUFFLENBQUMsZUFBZSxXQUFJLElBQUksQ0FBQyxTQUFTLDBDQUFFLGNBQWMsQ0FBQSxDQUFDO3dCQUN6RCxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQzt3QkFDakMsQ0FBQyxDQUFDLEVBQUU7aUJBQ1A7YUFDRixDQUFDLENBQUM7U0FDSjtRQUVELFVBQUksT0FBTyxDQUFDLG1CQUFtQixtQ0FBSSxJQUFJLEVBQUU7WUFDdkMsTUFBQSxJQUFJLENBQUMsTUFBTSwwQ0FBRSxzQkFBc0IsQ0FBQyxTQUFHLE9BQU8sQ0FBQywyQkFBMkIsbUNBQUksRUFBRSxFQUFFO1NBQ25GO1FBRUQsTUFBTSxVQUFVLFVBQUcsT0FBTyxDQUFDLFVBQVUscUNBQUksSUFBSSxDQUFDO1FBQzlDLElBQUksVUFBVSxFQUFFO1lBQ2QsSUFBSSxtQkFBUSxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsaUJBQWlCLENBQUMsQ0FBQztTQUMvQztJQUNILENBQUM7Ozs7SUE1Y0QsSUFBVyx3QkFBd0IsS0FBYyxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDOzs7O0lBS2hHLElBQVcsVUFBVSxLQUFhLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDOzs7Ozs7SUFpRG5FLElBQVcsY0FBYyxLQUF5QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQzs7Ozs7O0lBS3ZGLElBQVcsY0FBYyxLQUF5QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQzs7Ozs7O0lBd0J2RixJQUFXLGNBQWMsS0FBeUIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7Ozs7OztJQWlCdkYsSUFBVyxnQkFBZ0IsS0FBdUIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQzs7Ozs7O0lBS3pGLElBQVcsYUFBYSxLQUFhLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDOzs7O0lBS3pFLElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDO0lBQy9CLENBQUM7Ozs7SUE4Vk0sT0FBTyxDQUFDLElBQTRCO1FBQ3pDLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzVCLENBQUM7Ozs7Ozs7O0lBUU0sU0FBUyxDQUFDLElBQVksRUFBRSxPQUFlO1FBQzVDLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztJQUN4QyxDQUFDOzs7Ozs7O0lBTU0sWUFBWSxDQUFDLElBQVk7UUFDOUIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbEMsQ0FBQzs7Ozs7OztJQU1NLFNBQVMsQ0FBQyxJQUFZO1FBQzNCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdEMsQ0FBQzs7Ozs7O0lBTU0saUJBQWlCLENBQUMsR0FBRyxRQUFrQjtRQUM1QyxLQUFLLE1BQU0sQ0FBQyxJQUFJLFFBQVEsRUFBRTtZQUN4QixJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztTQUMxQjtJQUNILENBQUM7Ozs7OztJQU1NLGNBQWMsQ0FBQyxHQUFHLFFBQWtCO1FBQ3pDLEtBQUssTUFBTSxDQUFDLElBQUksUUFBUSxFQUFFO1lBQ3hCLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3ZCO0lBQ0gsQ0FBQzs7Ozs7O0lBTU0sZUFBZSxDQUFDLEdBQUcsUUFBa0I7UUFDMUMsS0FBSyxNQUFNLENBQUMsSUFBSSxRQUFRLEVBQUU7WUFDeEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDeEI7SUFDSCxDQUFDOzs7Ozs7O0lBTU0sU0FBUyxDQUFDLE1BQStCO1FBQzlDLEtBQUssTUFBTSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQ2xELElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQztTQUNwQztJQUNILENBQUM7Ozs7Ozs7SUFNTSxXQUFXLENBQUMsR0FBRyxRQUFrQjtRQUN0QyxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7Ozs7SUFFRCxJQUFXLG9CQUFvQjtRQUM3QixNQUFNLE9BQU8sR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO1FBQzVCLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRTtZQUNwQixPQUFPLENBQUMsSUFBSSxDQUFDO2dCQUNYLElBQUksRUFBRSxlQUFlO2dCQUNyQixJQUFJLEVBQUUsdUJBQXVCO2dCQUM3QixJQUFJLEVBQUUsRUFBRSxjQUFjLEVBQUUsSUFBSSxDQUFDLFdBQVcsRUFBRTthQUMzQyxDQUFDLENBQUM7U0FDSjtRQUVELE9BQU8sQ0FBQyxJQUFJLENBQUM7WUFDWCxJQUFJLEVBQUUsc0JBQXNCO1lBQzVCLEdBQUcsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWM7U0FDakMsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxPQUFPLENBQUM7SUFDakIsQ0FBQzs7Ozs7OztJQVdNLE9BQU8sQ0FBQyxHQUFHLElBQWM7UUFDOUIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxHQUFHLElBQUksQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7Ozs7SUFXTSxVQUFVLENBQUMsR0FBRyxJQUFjO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQztJQUMxQyxDQUFDOzs7Ozs7Ozs7OztJQWVNLFdBQVcsQ0FBQyxHQUFHLElBQWM7UUFDbEMsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxHQUFHLElBQUksQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7Ozs7Ozs7SUFjTSxjQUFjLENBQUMsR0FBRyxJQUFjO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRU8sVUFBVSxDQUFDLE9BQTJCOztRQUM1QyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFO1lBQ3hCLElBQUksaUJBQU8sQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUU7Z0JBQ3RDLGNBQWMsUUFBRSxPQUFPLENBQUMsY0FBYyxtQ0FBSSxPQUFPLENBQUMsVUFBVTtnQkFDNUQsZUFBZSxFQUFFLE9BQU8sQ0FBQyxlQUFlO2FBQ3pDLENBQUMsQ0FBQztTQUNKO0lBQ0gsQ0FBQztJQUVPLG1CQUFtQjtRQUN6QixJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FDcEIsUUFBUSxFQUNSLE1BQU0sRUFDTixPQUFPLEVBQ1AsZ0JBQWdCLEVBQ2hCLGlCQUFpQixFQUNqQixpQkFBaUIsRUFDakIsa0JBQWtCLEVBRWxCLDJEQUEyRCxFQUMzRCx5Q0FBeUMsRUFFekMsZ0JBQWdCLEVBQ2hCLE1BQU0sRUFDTixPQUFPLEVBQ1AsUUFBUSxFQUNSLFlBQVksRUFFWixtRUFBbUUsRUFDbkUsU0FBUyxFQUVULGtEQUFrRCxFQUNsRCxVQUFVLEVBQ1YsUUFBUSxFQUVSLHFCQUFxQixFQUNyQixhQUFhLEVBRWIsK0RBQStELEVBQy9ELGVBQWUsRUFFZiwwQkFBMEIsRUFDMUIsZUFBZSxFQUNmLGdCQUFnQixFQUVoQixvQkFBb0IsRUFDcEIsZUFBZSxFQUdmLHlCQUF5QixFQUN6QixjQUFjLEVBRWQsMEJBQTBCLEVBQzFCLE9BQU8sRUFFUCx1QkFBdUIsRUFDdkIsaUJBQWlCLEVBRWpCLGdEQUFnRCxFQUNoRCxRQUFRLENBQ1QsQ0FBQztJQUNKLENBQUM7SUFFTyxtQkFBbUIsQ0FBQyxJQUFZLEVBQUUsT0FBaUM7O1FBQ3pFLE1BQU0sVUFBVSxHQUFHLE9BQU8sQ0FBQyxLQUFLLENBQUM7UUFFakMsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsTUFBTSxFQUFFO1lBQUUsTUFBTSxJQUFJLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1NBQUU7UUFFdEQsTUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUUxQyxJQUFJLE9BQU8sQ0FBQyxPQUFPLEVBQUU7WUFDbkIsSUFBSSxPQUFPLENBQUMsT0FBTyxDQUFDLGFBQWEsRUFBRTtnQkFDakMsTUFBTSxJQUFJLEtBQUssQ0FBQyx5RUFBeUUsQ0FBQyxDQUFDO2FBQzVGO1lBRUQsUUFBUSxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7U0FDOUI7UUFFRCxRQUFRLENBQUMsRUFBRSxDQUFDO1lBQ1YsaUJBQWlCLEVBQUUsRUFBRTtTQUN0QixDQUFDLENBQUM7UUFFSCxNQUFNLFNBQVMsR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsRUFBRSxPQUFPLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNyRSxNQUFNLGFBQWEsU0FBRyxPQUFPLENBQUMsYUFBYSxtQ0FBSSxFQUFFLENBQUM7UUFDbEQsTUFBTSxnQkFBZ0IsU0FBRyxPQUFPLENBQUMsZ0JBQWdCLG1DQUFJLEVBQUUsQ0FBQztRQUN4RCxNQUFNLFlBQVksR0FBRyxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxPQUFPLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNoRixNQUFNLFNBQVMsU0FBRyxPQUFPLENBQUMsU0FBUyxtQ0FBSSxFQUFFLENBQUM7UUFFMUMsTUFBTSxlQUFlLEdBQUcsQ0FBQyxPQUFPLENBQUMsa0JBQWtCLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDL0UsSUFBSSxFQUFFLG1CQUFtQjtnQkFDekIsR0FBRyxFQUFFLDRDQUE0QzthQUNsRCxDQUFDLENBQUM7UUFFSCxNQUFNLEdBQUcsR0FBUTtZQUNmLFNBQVMsRUFBRSxlQUFlO1lBQzFCLEtBQUssRUFBRTtnQkFDTCxFQUFFLEVBQUUsTUFBTTtnQkFDVixTQUFHLE9BQU8sQ0FBQyxHQUFHLG1DQUFJLEVBQUU7YUFDckI7WUFDRCxHQUFHLFNBQVM7WUFDWixPQUFPLEVBQUU7Z0JBQ1AsR0FBRyxnQkFBZ0I7Z0JBRW5CLHFCQUFxQjtnQkFDckI7b0JBQ0UsSUFBSSxFQUFFLFVBQVU7b0JBQ2hCLElBQUksRUFBRSxxQkFBcUI7b0JBQzNCLEdBQUcsWUFBWTtpQkFDaEI7Z0JBRUQsdUJBQXVCO2dCQUN2QixHQUFHLElBQUksQ0FBQyxvQkFBb0I7Z0JBRTVCLGdFQUFnRTtnQkFDaEUsR0FBRyxlQUFlO2dCQUVsQix5Q0FBeUM7Z0JBQ3pDO29CQUNFLElBQUksRUFBRSxrQkFBa0I7b0JBQ3hCLEdBQUcsRUFBRTt3QkFDSCxtQ0FBbUM7d0JBQ25DLG1EQUFtRDtxQkFDcEQsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2lCQUNiO2dCQUVELDhDQUE4QztnQkFFOUMsR0FBRyxhQUFhO2dCQUVoQix5QkFBeUI7Z0JBQ3pCO29CQUNFLElBQUksRUFBRSxPQUFPO29CQUNiLEdBQUcsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7aUJBQ3pDO2dCQUVELDZEQUE2RDtnQkFDN0QsOEJBQThCO2dCQUM5QixHQUFHLENBQUMsT0FBTyxDQUFDLE9BQU8sSUFBSSxPQUFPLENBQUMsa0JBQWtCLENBQUMsV0FBSSxJQUFJLENBQUMsSUFBSSwwQ0FBRSxNQUFNLENBQUEsQ0FBQyxDQUFDLENBQUMsQ0FBQzt3QkFDekUsSUFBSSxFQUFFLDRCQUE0Qjt3QkFDbEMsSUFBSSxFQUFFLDJCQUEyQjt3QkFDakMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7NEJBQ2pDLEtBQUssRUFBRSxnQkFBZ0IsT0FBTyxDQUFDLGtCQUFrQixLQUFLOzRCQUN0RCxTQUFTLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsaUJBQWlCO3lCQUM5QyxDQUFDLENBQUMsQ0FBQzs0QkFDRixTQUFTLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsaUJBQWlCO3lCQUM5QztxQkFDRixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7Z0JBRVAsR0FBRyxTQUFTO2dCQUVaLHFFQUFxRTtnQkFDckUsMEZBQTBGO2dCQUMxRixHQUFHLGVBQWU7YUFDbkI7U0FDRixDQUFDO1FBRUYsSUFBSSxPQUFPLENBQUMsS0FBSyxFQUFFO1lBQ2pCLEdBQUcsQ0FBQyxTQUFTLEdBQUcsRUFBRSxLQUFLLEVBQUUsT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFDO1NBQzFDO1FBRUQsUUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUV4QyxPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDOzs7Ozs7Ozs7Ozs7SUFVTSxjQUFjLENBQUMsSUFBVTtRQUM5QixRQUFRLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLEVBQUU7WUFDckMsS0FBSywrQkFBZ0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ2xGLEtBQUssK0JBQWdCLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDNUU7Z0JBQ0UsTUFBTSxJQUFJLEtBQUssQ0FBQyxrQ0FBa0MsSUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUM7U0FDdEY7SUFDSCxDQUFDOztBQTN5Qkgsa0NBNHlCQzs7Ozs7Ozs7QUFvRUQsTUFBYSw0QkFBNEI7SUF5QnZDLFlBQ21CLE1BQXNDLEVBQ3RDLGNBQXdCO1FBRHhCLFdBQU0sR0FBTixNQUFNLENBQWdDO1FBQ3RDLG1CQUFjLEdBQWQsY0FBYyxDQUFVO0lBQUcsQ0FBQzs7Ozs7O0lBakJ4QyxNQUFNLENBQUMsVUFBVSxDQUFDLFVBQTZCLEVBQUU7UUFDdEQsT0FBTyxJQUFJLDRCQUE0QixDQUFDLENBQUMsT0FBb0IsRUFBRSxFQUFFOztZQUMvRCxNQUFBLE9BQU8sQ0FBQyxNQUFNLDBDQUFFLGFBQWEsQ0FBQyxPQUFPLEVBQUU7UUFDekMsQ0FBQyxFQUFFLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMzQixDQUFDOzs7Ozs7SUFLTSxNQUFNLENBQUMsY0FBYyxDQUFDLFVBQXNDLEVBQUU7UUFDbkUsT0FBTyxJQUFJLDRCQUE0QixDQUFDLENBQUMsT0FBb0IsRUFBRSxFQUFFO1lBQy9ELElBQUksMENBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQzVDLENBQUMsRUFBRSxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDM0IsQ0FBQzs7OztJQU1ELElBQVcsYUFBYTs7UUFDdEIsaUZBQWlGO1FBQ2pGLHNFQUFzRTtRQUN0RSxhQUFPLElBQUksQ0FBQyxjQUFjLG1DQUFJLElBQUksQ0FBQztJQUNyQyxDQUFDOzs7O0lBRU0sSUFBSSxDQUFDLE9BQW9CO1FBQzlCLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDdkIsQ0FBQzs7QUFyQ0gsb0VBc0NDOzs7Ozs7OztBQWpDd0IsaUNBQUksR0FBRyxJQUFJLDRCQUE0QixDQUFDLENBQUMsQ0FBYyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUFJPSkVOX0RJUiwgUFJPSkVOX1JDLCBQUk9KRU5fVkVSU0lPTiB9IGZyb20gJy4vY29tbW9uJztcbmltcG9ydCB7IEF1dG9NZXJnZSwgRGVwZW5kYWJvdE9wdGlvbnMsIEdpdGh1YldvcmtmbG93IH0gZnJvbSAnLi9naXRodWInO1xuaW1wb3J0IHsgTWVyZ2lmeU9wdGlvbnMgfSBmcm9tICcuL2dpdGh1Yi9tZXJnaWZ5JztcbmltcG9ydCB7IElnbm9yZUZpbGUgfSBmcm9tICcuL2lnbm9yZS1maWxlJztcbmltcG9ydCB7IFByb2plbnJjLCBQcm9qZW5yY09wdGlvbnMgfSBmcm9tICcuL2phdmFzY3JpcHQvcHJvamVucmMnO1xuaW1wb3J0IHsgSmVzdCwgSmVzdE9wdGlvbnMgfSBmcm9tICcuL2plc3QnO1xuaW1wb3J0IHsgTGljZW5zZSB9IGZyb20gJy4vbGljZW5zZSc7XG5pbXBvcnQgeyBOb2RlUGFja2FnZSwgTnBtVGFza0V4ZWN1dGlvbiwgTm9kZVBhY2thZ2VNYW5hZ2VyLCBOb2RlUGFja2FnZU9wdGlvbnMgfSBmcm9tICcuL25vZGUtcGFja2FnZSc7XG5pbXBvcnQgeyBQcm9qZWN0LCBQcm9qZWN0T3B0aW9ucyB9IGZyb20gJy4vcHJvamVjdCc7XG5pbXBvcnQgeyBQdWJsaXNoZXIgfSBmcm9tICcuL3B1Ymxpc2hlcic7XG5pbXBvcnQgeyBUYXNrLCBUYXNrQ2F0ZWdvcnkgfSBmcm9tICcuL3Rhc2tzJztcbmltcG9ydCB7IFVwZ3JhZGVEZXBlbmRlbmNpZXMsIFVwZ3JhZGVEZXBlbmRlbmNpZXNPcHRpb25zLCBVcGdyYWRlRGVwZW5kZW5jaWVzU2NoZWR1bGUgfSBmcm9tICcuL3VwZ3JhZGUtZGVwZW5kZW5jaWVzJztcbmltcG9ydCB7IFZlcnNpb24gfSBmcm9tICcuL3ZlcnNpb24nO1xuXG5jb25zdCBQUk9KRU5fU0NSSVBUID0gJ3Byb2plbic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTm9kZVByb2plY3RPcHRpb25zIGV4dGVuZHMgUHJvamVjdE9wdGlvbnMsIE5vZGVQYWNrYWdlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb3B5cmlnaHRPd25lcj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29weXJpZ2h0UGVyaW9kPzogc3RyaW5nO1xuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcm9qZW5WZXJzaW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJvamVuRGV2RGVwZW5kZW5jeT86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVmYXVsdFJlbGVhc2VCcmFuY2g6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBidWlsZFdvcmtmbG93PzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbXV0YWJsZUJ1aWxkPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvZGVDb3Y/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29kZUNvdlRva2VuU2VjcmV0Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWxlYXNlV29ya2Zsb3c/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlbGVhc2VFdmVyeUNvbW1pdD86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlbGVhc2VTY2hlZHVsZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlbGVhc2VCcmFuY2hlcz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgd29ya2Zsb3dCb290c3RyYXBTdGVwcz86IGFueVtdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgd29ya2Zsb3dDb250YWluZXJJbWFnZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVsZWFzZVdvcmtmbG93U2V0dXBTdGVwcz86IGFueVtdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVsZWFzZVRvTnBtPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYW50aXRhbXBlcj86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHdvcmtmbG93Tm9kZVZlcnNpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZXBlbmRhYm90PzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVwZW5kYWJvdE9wdGlvbnM/OiBEZXBlbmRhYm90T3B0aW9ucztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVwc1VwZ3JhZGU/OiBEZXBlbmRlbmNpZXNVcGdyYWRlTWVjaGFuaXNtO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lcmdpZnlPcHRpb25zPzogTWVyZ2lmeU9wdGlvbnM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXJnaWZ5QXV0b01lcmdlTGFiZWw/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByb2plblVwZ3JhZGVTZWNyZXQ/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJvamVuVXBncmFkZUF1dG9NZXJnZT86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJvamVuVXBncmFkZVNjaGVkdWxlPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJvamVuRHVyaW5nQnVpbGQ/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbnBtaWdub3JlRW5hYmxlZD86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbnBtaWdub3JlPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHB1bGxSZXF1ZXN0VGVtcGxhdGU/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHVsbFJlcXVlc3RUZW1wbGF0ZUNvbnRlbnRzPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGdpdGlnbm9yZT86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgamVzdD86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgamVzdE9wdGlvbnM/OiBKZXN0T3B0aW9ucztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBqc2lpUmVsZWFzZVZlcnNpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFydGlmYWN0c0RpcmVjdG9yeT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcm9qZW5yY0pzPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcm9qZW5yY0pzT3B0aW9ucz86IFByb2plbnJjT3B0aW9ucztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGluaXRpYWxWZXJzaW9uPzogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBBdXRvUmVsZWFzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBFVkVSWV9DT01NSVQsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIERBSUxZXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTm9kZVByb2plY3QgZXh0ZW5kcyBQcm9qZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgcGFja2FnZTogTm9kZVBhY2thZ2U7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IG5wbWlnbm9yZT86IElnbm9yZUZpbGU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGdldCBhbGxvd0xpYnJhcnlEZXBlbmRlbmNpZXMoKTogYm9vbGVhbiB7IHJldHVybiB0aGlzLnBhY2thZ2UuYWxsb3dMaWJyYXJ5RGVwZW5kZW5jaWVzOyB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgZW50cnlwb2ludCgpOiBzdHJpbmcgeyByZXR1cm4gdGhpcy5wYWNrYWdlLmVudHJ5cG9pbnQ7IH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjb21waWxlVGFzazogVGFzaztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHRlc3RUYXNrOiBUYXNrO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSB0ZXN0Q29tcGlsZVRhc2s6IFRhc2s7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGJ1aWxkVGFzazogVGFzaztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgYXV0b01lcmdlPzogQXV0b01lcmdlO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgX3ZlcnNpb246IFZlcnNpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgYnVpbGRXb3JrZmxvdz86IEdpdGh1YldvcmtmbG93O1xuICBwdWJsaWMgcmVhZG9ubHkgYnVpbGRXb3JrZmxvd0pvYklkPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSByZWxlYXNlV29ya2Zsb3c/OiBHaXRodWJXb3JrZmxvdztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBwdWJsaXNoZXI/OiBQdWJsaXNoZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgZ2V0IG1pbk5vZGVWZXJzaW9uKCk6IHN0cmluZyB8IHVuZGVmaW5lZCB7IHJldHVybiB0aGlzLnBhY2thZ2UubWluTm9kZVZlcnNpb247IH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgbWF4Tm9kZVZlcnNpb24oKTogc3RyaW5nIHwgdW5kZWZpbmVkIHsgcmV0dXJuIHRoaXMucGFja2FnZS5tYXhOb2RlVmVyc2lvbjsgfVxuXG4gIHByaXZhdGUgcmVhZG9ubHkgbm9kZVZlcnNpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGFudGl0YW1wZXI6IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHByb3RlY3RlZCByZWFkb25seSBucG1EaXN0VGFnOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwcm90ZWN0ZWQgcmVhZG9ubHkgbnBtUmVnaXN0cnk6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGdldCBwYWNrYWdlTWFuYWdlcigpOiBOb2RlUGFja2FnZU1hbmFnZXIgeyByZXR1cm4gdGhpcy5wYWNrYWdlLnBhY2thZ2VNYW5hZ2VyOyB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBydW5TY3JpcHRDb21tYW5kOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGplc3Q/OiBKZXN0O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgbnBtVGFza0V4ZWN1dGlvbigpOiBOcG1UYXNrRXhlY3V0aW9uIHsgcmV0dXJuIHRoaXMucGFja2FnZS5ucG1UYXNrRXhlY3V0aW9uOyB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGdldCBwcm9qZW5Db21tYW5kKCk6IHN0cmluZyB7IHJldHVybiB0aGlzLnBhY2thZ2UucHJvamVuQ29tbWFuZDsgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGdldCBtYW5pZmVzdCgpIHtcbiAgICByZXR1cm4gdGhpcy5wYWNrYWdlLm1hbmlmZXN0O1xuICB9XG5cbiAgY29uc3RydWN0b3Iob3B0aW9uczogTm9kZVByb2plY3RPcHRpb25zKSB7XG4gICAgc3VwZXIob3B0aW9ucyk7XG5cbiAgICB0aGlzLnBhY2thZ2UgPSBuZXcgTm9kZVBhY2thZ2UodGhpcywgb3B0aW9ucyk7XG5cbiAgICB0aGlzLnJ1blNjcmlwdENvbW1hbmQgPSAoKCkgPT4ge1xuICAgICAgc3dpdGNoICh0aGlzLnBhY2thZ2VNYW5hZ2VyKSB7XG4gICAgICAgIGNhc2UgTm9kZVBhY2thZ2VNYW5hZ2VyLk5QTTogcmV0dXJuICducG0gcnVuJztcbiAgICAgICAgY2FzZSBOb2RlUGFja2FnZU1hbmFnZXIuWUFSTjogcmV0dXJuICd5YXJuIHJ1bic7XG4gICAgICAgIGNhc2UgTm9kZVBhY2thZ2VNYW5hZ2VyLlBOUE06IHJldHVybiAncG5wbSBydW4nO1xuICAgICAgICBkZWZhdWx0OiB0aHJvdyBuZXcgRXJyb3IoYHVuZXhwZWN0ZWQgcGFja2FnZSBtYW5hZ2VyICR7dGhpcy5wYWNrYWdlTWFuYWdlcn1gKTtcbiAgICAgIH1cbiAgICB9KSgpO1xuXG4gICAgdGhpcy5ub2RlVmVyc2lvbiA9IG9wdGlvbnMud29ya2Zsb3dOb2RlVmVyc2lvbiA/PyB0aGlzLnBhY2thZ2UubWluTm9kZVZlcnNpb247XG5cbiAgICB0aGlzLl92ZXJzaW9uID0gbmV3IFZlcnNpb24odGhpcywge1xuICAgICAgaW5pdGlhbFZlcnNpb246IG9wdGlvbnMuaW5pdGlhbFZlcnNpb24sXG4gICAgfSk7XG5cbiAgICAvLyBhZGQgUEFUSCBmb3IgYWxsIHRhc2tzIHdoaWNoIGluY2x1ZGVzIHRoZSBwcm9qZWN0J3MgbnBtIC5iaW4gbGlzdFxuICAgIHRoaXMudGFza3MuYWRkRW52aXJvbm1lbnQoJ1BBVEgnLCAnJChucHggLWMgXCJub2RlIC1lIFxcXFxcXFwiY29uc29sZS5sb2cocHJvY2Vzcy5lbnYuUEFUSClcXFxcXFxcIlwiKScpO1xuXG4gICAgdGhpcy5jb21waWxlVGFzayA9IHRoaXMuYWRkVGFzaygnY29tcGlsZScsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiAnT25seSBjb21waWxlJyxcbiAgICAgIGNhdGVnb3J5OiBUYXNrQ2F0ZWdvcnkuQlVJTEQsXG4gICAgfSk7XG5cbiAgICB0aGlzLnRlc3RDb21waWxlVGFzayA9IHRoaXMuYWRkVGFzaygndGVzdDpjb21waWxlJywge1xuICAgICAgZGVzY3JpcHRpb246ICdjb21waWxlcyB0aGUgdGVzdCBjb2RlJyxcbiAgICAgIGNhdGVnb3J5OiBUYXNrQ2F0ZWdvcnkuVEVTVCxcbiAgICB9KTtcblxuICAgIHRoaXMudGVzdFRhc2sgPSB0aGlzLmFkZFRhc2soJ3Rlc3QnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ1J1biB0ZXN0cycsXG4gICAgICBjYXRlZ29yeTogVGFza0NhdGVnb3J5LlRFU1QsXG4gICAgfSk7XG5cbiAgICB0aGlzLnRlc3RUYXNrLnNwYXduKHRoaXMudGVzdENvbXBpbGVUYXNrKTtcblxuICAgIHRoaXMuYnVpbGRUYXNrID0gdGhpcy5hZGRUYXNrKCdidWlsZCcsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiAnRnVsbCByZWxlYXNlIGJ1aWxkICh0ZXN0K2NvbXBpbGUpJyxcbiAgICAgIGNhdGVnb3J5OiBUYXNrQ2F0ZWdvcnkuQlVJTEQsXG4gICAgfSk7XG5cbiAgICAvLyBmaXJzdCwgZXhlY3V0ZSBwcm9qZW4gYXMgdGhlIGZpcnN0IHRoaW5nIGR1cmluZyBidWlsZFxuICAgIGlmIChvcHRpb25zLnByb2plbkR1cmluZ0J1aWxkID8/IHRydWUpIHtcbiAgICAgIC8vIHNraXAgZm9yIHN1Yi1wcm9qZWN0cyAoaS5lLiBcInBhcmVudFwiIGlzIGRlZmluZWQpIHNpbmNlIHN5bnRoaW5nIHRoZVxuICAgICAgLy8gcm9vdCBwcm9qZWN0IHdpbGwgaW5jbHVkZSB0aGUgc3VicHJvamVjdHMuXG4gICAgICBpZiAoIXRoaXMucGFyZW50KSB7XG4gICAgICAgIHRoaXMuYnVpbGRUYXNrLmV4ZWModGhpcy5wcm9qZW5Db21tYW5kKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICB0aGlzLmFkZExpY2Vuc2Uob3B0aW9ucyk7XG5cbiAgICB0aGlzLm5wbURpc3RUYWcgPSB0aGlzLnBhY2thZ2UubnBtRGlzdFRhZztcbiAgICB0aGlzLm5wbVJlZ2lzdHJ5ID0gdGhpcy5wYWNrYWdlLm5wbVJlZ2lzdHJ5O1xuXG4gICAgaWYgKG9wdGlvbnMubnBtaWdub3JlRW5hYmxlZCA/PyB0cnVlKSB7XG4gICAgICB0aGlzLm5wbWlnbm9yZSA9IG5ldyBJZ25vcmVGaWxlKHRoaXMsICcubnBtaWdub3JlJyk7XG4gICAgfVxuXG4gICAgdGhpcy5hZGREZWZhdWx0R2l0SWdub3JlKCk7XG5cbiAgICBpZiAob3B0aW9ucy5naXRpZ25vcmU/Lmxlbmd0aCkge1xuICAgICAgZm9yIChjb25zdCBpIG9mIG9wdGlvbnMuZ2l0aWdub3JlKSB7XG4gICAgICAgIHRoaXMuZ2l0aWdub3JlLmV4Y2x1ZGUoaSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKG9wdGlvbnMubnBtaWdub3JlPy5sZW5ndGgpIHtcbiAgICAgIGlmICghdGhpcy5ucG1pZ25vcmUpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCcubnBtaWdub3JlIGlzIG5vdCBkZWZpbmVkIGZvciBhbiBBUFAgcHJvamVjdCB0eXBlLiBBZGQgXCJucG1JZ25vcmU6IHRydWVcIiB0byBvdmVycmlkZSB0aGlzJyk7XG4gICAgICB9XG5cbiAgICAgIGZvciAoY29uc3QgaSBvZiBvcHRpb25zLm5wbWlnbm9yZSkge1xuICAgICAgICB0aGlzLm5wbWlnbm9yZS5leGNsdWRlKGkpO1xuICAgICAgfVxuICAgIH1cblxuXG4gICAgdGhpcy5zZXRTY3JpcHQoUFJPSkVOX1NDUklQVCwgdGhpcy5wYWNrYWdlLnByb2plbkNvbW1hbmQpO1xuICAgIHRoaXMuc2V0U2NyaXB0KCdzdGFydCcsIGAke3RoaXMucGFja2FnZS5wcm9qZW5Db21tYW5kfSBzdGFydGApO1xuXG4gICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoYC8ke1BST0pFTl9SQ31gKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZShgLyR7UFJPSkVOX0RJUn1gKTtcbiAgICB0aGlzLmdpdGlnbm9yZS5pbmNsdWRlKGAvJHtQUk9KRU5fUkN9YCk7XG5cbiAgICBjb25zdCBwcm9qZW4gPSBvcHRpb25zLnByb2plbkRldkRlcGVuZGVuY3kgPz8gdHJ1ZTtcbiAgICBpZiAocHJvamVuKSB7XG4gICAgICBjb25zdCBwcm9qZW5WZXJzaW9uID0gb3B0aW9ucy5wcm9qZW5WZXJzaW9uID8/IGBeJHtQUk9KRU5fVkVSU0lPTn1gO1xuICAgICAgdGhpcy5hZGREZXZEZXBzKGBwcm9qZW5AJHtwcm9qZW5WZXJzaW9ufWApO1xuICAgIH1cblxuICAgIGlmICghb3B0aW9ucy5kZWZhdWx0UmVsZWFzZUJyYW5jaCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdcImRlZmF1bHRSZWxlYXNlQnJhbmNoXCIgaXMgdGVtcG9yYXJpbHkgYSByZXF1aXJlZCBvcHRpb24gd2hpbGUgd2UgbWlncmF0ZSBpdHMgZGVmYXVsdCB2YWx1ZSBmcm9tIFwibWFzdGVyXCIgdG8gXCJtYWluXCInKTtcbiAgICB9XG5cbiAgICBjb25zdCBidWlsZEVuYWJsZWQgPSBvcHRpb25zLmJ1aWxkV29ya2Zsb3cgPz8gKHRoaXMucGFyZW50ID8gZmFsc2UgOiB0cnVlKTtcbiAgICBjb25zdCBtdXRhYmxlQnVpbGRzID0gb3B0aW9ucy5tdXRhYmxlQnVpbGQgPz8gdHJ1ZTtcblxuICAgIC8vIGluZGljYXRlIGlmIHdlIGhhdmUgYW50aS10YW1wZXIgY29uZmlndXJlZCBpbiBvdXIgd29ya2Zsb3dzLiB1c2VkIGJ5IGUuZy4gSmVzdFxuICAgIC8vIHRvIGRlY2lkZSBpZiB3ZSBjYW4gYWx3YXlzIHJ1biB3aXRoIC0tdXBkYXRlU25hcHNob3RcbiAgICB0aGlzLmFudGl0YW1wZXIgPSBidWlsZEVuYWJsZWQgJiYgKG9wdGlvbnMuYW50aXRhbXBlciA/PyB0cnVlKTtcblxuICAgIC8vIGNvbmZpZ3VyZSBqZXN0IGlmIGVuYWJsZWRcbiAgICAvLyBtdXN0IGJlIGJlZm9yZSB0aGUgYnVpbGQvcmVsZWFzZSB3b3JrZmxvd3NcbiAgICBpZiAob3B0aW9ucy5qZXN0ID8/IHRydWUpIHtcbiAgICAgIHRoaXMuamVzdCA9IG5ldyBKZXN0KHRoaXMsIG9wdGlvbnMuamVzdE9wdGlvbnMpO1xuICAgIH1cblxuICAgIGlmIChvcHRpb25zLmJ1aWxkV29ya2Zsb3cgPz8gKHRoaXMucGFyZW50ID8gZmFsc2UgOiB0cnVlKSkge1xuICAgICAgY29uc3QgYnJhbmNoID0gJyR7eyBnaXRodWIuZXZlbnQucHVsbF9yZXF1ZXN0LmhlYWQucmVmIH19JztcbiAgICAgIGNvbnN0IHJlcG8gPSAnJHt7IGdpdGh1Yi5ldmVudC5wdWxsX3JlcXVlc3QuaGVhZC5yZXBvLmZ1bGxfbmFtZSB9fSc7XG4gICAgICBjb25zdCBidWlsZEpvYklkID0gJ2J1aWxkJztcblxuICAgICAgY29uc3QgdXBkYXRlUmVwbyA9IG5ldyBBcnJheTxhbnk+KCk7XG4gICAgICBjb25zdCBnaXREaWZmU3RlcElkID0gJ2dpdF9kaWZmJztcbiAgICAgIGNvbnN0IGhhc0NoYW5nZXNDb25kTmFtZSA9ICdoYXNfY2hhbmdlcyc7XG4gICAgICBjb25zdCBoYXNDaGFuZ2VzID0gYHN0ZXBzLiR7Z2l0RGlmZlN0ZXBJZH0ub3V0cHV0cy4ke2hhc0NoYW5nZXNDb25kTmFtZX1gO1xuICAgICAgY29uc3QgcmVwb0Z1bGxOYW1lID0gJ2dpdGh1Yi5ldmVudC5wdWxsX3JlcXVlc3QuaGVhZC5yZXBvLmZ1bGxfbmFtZSc7XG5cbiAgICAgIC8vIHVzZSBcImdpdCBkaWZmIC0tZXhpdCBjb2RlXCIgdG8gY2hlY2sgaWYgdGhlcmUgd2VyZSBjaGFuZ2VzIGluIHRoZSByZXBvXG4gICAgICAvLyBhbmQgY3JlYXRlIGEgc3RlcCBvdXRwdXQgdGhhdCB3aWxsIGJlIHVzZWQgaW4gc3Vic2VxdWVudCBzdGVwcy5cbiAgICAgIHVwZGF0ZVJlcG8ucHVzaCh7XG4gICAgICAgIG5hbWU6ICdDaGVjayBmb3IgY2hhbmdlcycsXG4gICAgICAgIGlkOiBnaXREaWZmU3RlcElkLFxuICAgICAgICBydW46IGBnaXQgZGlmZiAtLWV4aXQtY29kZSB8fCBlY2hvIFwiOjpzZXQtb3V0cHV0IG5hbWU9JHtoYXNDaGFuZ2VzQ29uZE5hbWV9Ojp0cnVlXCJgLFxuICAgICAgfSk7XG5cbiAgICAgIC8vIG9ubHkgaWYgd2UgaGFkIGNoYW5nZXMsIGNvbW1pdCB0aGVtIGFuZCBwdXNoIHRvIHRoZSByZXBvIG5vdGUgdGhhdCBmb3JcbiAgICAgIC8vIGZvcmtzLCB0aGlzIHdpbGwgZmFpbCAoYmVjYXVzZSB0aGUgd29ya2Zsb3cgZG9lc24ndCBoYXZlIHBlcm1pc3Npb25zLlxuICAgICAgLy8gdGhpcyBpbmRpY2F0ZXMgdG8gdXNlcnMgdGhhdCB0aGV5IG5lZWQgdG8gdXBkYXRlIHRoZWlyIGJyYW5jaCBtYW51YWxseS5cbiAgICAgIHVwZGF0ZVJlcG8ucHVzaCh7XG4gICAgICAgIGlmOiBoYXNDaGFuZ2VzLFxuICAgICAgICBuYW1lOiAnQ29tbWl0IGFuZCBwdXNoIGNoYW5nZXMgKGlmIGNoYW5nZWQpJyxcbiAgICAgICAgcnVuOiBgZ2l0IGFkZCAuICYmIGdpdCBjb21taXQgLW0gXCJjaG9yZTogc2VsZiBtdXRhdGlvblwiICYmIGdpdCBwdXNoIG9yaWdpbiBIRUFEOiR7YnJhbmNofWAsXG4gICAgICB9KTtcblxuICAgICAgLy8gaWYgd2UgcHVzaGVkIGNoYW5nZXMsIHdlIG5lZWQgdG8gbWFudWFsbHkgdXBkYXRlIHRoZSBzdGF0dXMgY2hlY2sgc29cbiAgICAgIC8vIHRoYXQgdGhlIFBSIHdpbGwgYmUgZ3JlZW4gKHdlIHdvbid0IGdldCBoZXJlIGZvciBmb3JrcyB3aXRoIHVwZGF0ZXNcbiAgICAgIC8vIGJlY2F1c2UgdGhlIHB1c2ggd291bGQgaGF2ZSBmYWlsZWQpLlxuICAgICAgdXBkYXRlUmVwby5wdXNoKHtcbiAgICAgICAgaWY6IGhhc0NoYW5nZXMsXG4gICAgICAgIG5hbWU6ICdVcGRhdGUgc3RhdHVzIGNoZWNrIChpZiBjaGFuZ2VkKScsXG4gICAgICAgIHJ1bjogW1xuICAgICAgICAgICdnaCBhcGknLFxuICAgICAgICAgICctWCBQT1NUJyxcbiAgICAgICAgICBgL3JlcG9zL1xcJHt7ICR7cmVwb0Z1bGxOYW1lfSB9fS9jaGVjay1ydW5zYCxcbiAgICAgICAgICBgLUYgbmFtZT1cIiR7YnVpbGRKb2JJZH1cImAsXG4gICAgICAgICAgJy1GIGhlYWRfc2hhPVwiJChnaXQgcmV2LXBhcnNlIEhFQUQpXCInLFxuICAgICAgICAgICctRiBzdGF0dXM9XCJjb21wbGV0ZWRcIicsXG4gICAgICAgICAgJy1GIGNvbmNsdXNpb249XCJzdWNjZXNzXCInLFxuICAgICAgICBdLmpvaW4oJyAnKSxcbiAgICAgICAgZW52OiB7XG4gICAgICAgICAgR0lUSFVCX1RPS0VOOiAnJHt7IHNlY3JldHMuR0lUSFVCX1RPS0VOIH19JyxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuXG4gICAgICBjb25zdCB3b3JrZmxvdyA9IHRoaXMuY3JlYXRlQnVpbGRXb3JrZmxvdygnQnVpbGQnLCB7XG4gICAgICAgIGpvYklkOiBidWlsZEpvYklkLFxuICAgICAgICB0cmlnZ2VyOiB7XG4gICAgICAgICAgcHVsbF9yZXF1ZXN0OiB7IH0sXG4gICAgICAgIH0sXG5cbiAgICAgICAgY2hlY2tvdXRXaXRoOiBtdXRhYmxlQnVpbGRzID8ge1xuICAgICAgICAgIHJlZjogYnJhbmNoLFxuICAgICAgICAgIHJlcG9zaXRvcnk6IHJlcG8sXG4gICAgICAgIH0gOiB1bmRlZmluZWQsXG5cbiAgICAgICAgcG9zdFN0ZXBzOiB1cGRhdGVSZXBvLFxuXG4gICAgICAgIGFudGl0YW1wZXJEaXNhYmxlZDogbXV0YWJsZUJ1aWxkcywgLy8gPC0tIGRpc2FibGUgYW50aS10YW1wZXIgaWYgYnVpbGQgd29ya2Zsb3cgaXMgbXV0YWJsZVxuICAgICAgICBpbWFnZTogb3B0aW9ucy53b3JrZmxvd0NvbnRhaW5lckltYWdlLFxuICAgICAgICBjb2RlQ292OiBvcHRpb25zLmNvZGVDb3YgPz8gZmFsc2UsXG4gICAgICAgIGNvZGVDb3ZUb2tlblNlY3JldDogb3B0aW9ucy5jb2RlQ292VG9rZW5TZWNyZXQsXG4gICAgICB9KTtcblxuICAgICAgdGhpcy5idWlsZFdvcmtmbG93ID0gd29ya2Zsb3c7XG4gICAgICB0aGlzLmJ1aWxkV29ya2Zsb3dKb2JJZCA9IGJ1aWxkSm9iSWQ7XG4gICAgfVxuXG4gICAgaWYgKG9wdGlvbnMucmVsZWFzZVdvcmtmbG93ID8/ICh0aGlzLnBhcmVudCA/IGZhbHNlIDogdHJ1ZSkpIHtcbiAgICAgIGNvbnN0IGRlZmF1bHRSZWxlYXNlQnJhbmNoID0gb3B0aW9ucy5kZWZhdWx0UmVsZWFzZUJyYW5jaCA/PyAnbWFpbic7XG4gICAgICBjb25zdCByZWxlYXNlQnJhbmNoZXMgPSBvcHRpb25zLnJlbGVhc2VCcmFuY2hlcyA/PyBbZGVmYXVsdFJlbGVhc2VCcmFuY2hdO1xuXG4gICAgICBjb25zdCB0cmlnZ2VyOiB7IFtldmVudDogc3RyaW5nXTogYW55IH0gPSB7IH07XG5cbiAgICAgIGlmIChvcHRpb25zLnJlbGVhc2VFdmVyeUNvbW1pdCA/PyB0cnVlKSB7XG4gICAgICAgIHRyaWdnZXIucHVzaCA9IHsgYnJhbmNoZXM6IHJlbGVhc2VCcmFuY2hlcyB9O1xuICAgICAgfVxuXG4gICAgICBpZiAob3B0aW9ucy5yZWxlYXNlU2NoZWR1bGUpIHtcbiAgICAgICAgdHJpZ2dlci5zY2hlZHVsZSA9IHsgY3Jvbjogb3B0aW9ucy5yZWxlYXNlU2NoZWR1bGUgfTtcbiAgICAgIH1cblxuICAgICAgY29uc3QgYXJ0aWZhY3REaXJlY3RvcnkgPSBvcHRpb25zLmFydGlmYWN0c0RpcmVjdG9yeSA/PyAnZGlzdCc7XG4gICAgICBjb25zdCBnZXRWZXJzaW9uID0gJ3YkKG5vZGUgLXAgXFxcInJlcXVpcmUoXFwnLi9wYWNrYWdlLmpzb25cXCcpLnZlcnNpb25cXFwiKSc7XG4gICAgICBjb25zdCBqb2JJZCA9ICdyZWxlYXNlJztcblxuICAgICAgY29uc3QgcmVsZWFzZVN0ZXBzOiBhbnlbXSA9IFtdO1xuXG4gICAgICAvLyB0byBhdm9pZCByYWNlIGNvbmRpdGlvbnMgYmV0d2VlbiB0d28gY29tbWl0cyB0cnlpbmcgdG8gcmVsZWFzZSB0aGUgc2FtZVxuICAgICAgLy8gdmVyc2lvbiwgd2UgY2hlY2sgaWYgdGhlIGhlYWQgc2hhIGlzIGlkZW50aWNhbCB0byB0aGUgcmVtb3RlIHNoYS4gaWZcbiAgICAgIC8vIG5vdCwgd2Ugd2lsbCBza2lwIHRoZSByZWxlYXNlIGFuZCBqdXN0IGZpbmlzaCB0aGUgYnVpbGQuXG4gICAgICBjb25zdCBnaXRSZW1vdGVTdGVwID0gJ2dpdF9yZW1vdGUnO1xuICAgICAgY29uc3QgbGF0ZXN0Q29tbWl0T3V0cHV0ID0gJ2xhdGVzdF9jb21taXQnO1xuICAgICAgY29uc3Qgbm9OZXdDb21taXRzID0gYFxcJHt7IHN0ZXBzLiR7Z2l0UmVtb3RlU3RlcH0ub3V0cHV0cy4ke2xhdGVzdENvbW1pdE91dHB1dH0gPT0gZ2l0aHViLnNoYSB9fWA7XG5cbiAgICAgIHJlbGVhc2VTdGVwcy5wdXNoKHtcbiAgICAgICAgbmFtZTogJ0NoZWNrIGZvciBuZXcgY29tbWl0cycsXG4gICAgICAgIGlkOiBnaXRSZW1vdGVTdGVwLFxuICAgICAgICBydW46IGBlY2hvIDo6c2V0LW91dHB1dCBuYW1lPSR7bGF0ZXN0Q29tbWl0T3V0cHV0fTo6XCIkKGdpdCBscy1yZW1vdGUgb3JpZ2luIC1oIFxcJHt7IGdpdGh1Yi5yZWYgfX0gfCBjdXQgLWYxKVwiYCxcbiAgICAgIH0pO1xuXG4gICAgICByZWxlYXNlU3RlcHMucHVzaCh7XG4gICAgICAgIG5hbWU6ICdDcmVhdGUgcmVsZWFzZScsXG4gICAgICAgIGlmOiBub05ld0NvbW1pdHMsXG4gICAgICAgIHJ1bjogW1xuICAgICAgICAgIGBnaCByZWxlYXNlIGNyZWF0ZSAke2dldFZlcnNpb259YCxcbiAgICAgICAgICBgLUYgJHt0aGlzLl92ZXJzaW9uLmNoYW5nZWxvZ0ZpbGV9YCxcbiAgICAgICAgICBgLXQgJHtnZXRWZXJzaW9ufWAsXG4gICAgICAgIF0uam9pbignICcpLFxuICAgICAgICBlbnY6IHtcbiAgICAgICAgICBHSVRIVUJfVE9LRU46ICcke3sgc2VjcmV0cy5HSVRIVUJfVE9LRU4gfX0nLFxuICAgICAgICB9LFxuICAgICAgfSk7XG5cbiAgICAgIHJlbGVhc2VTdGVwcy5wdXNoKHtcbiAgICAgICAgbmFtZTogJ1VuYnVtcCcsXG4gICAgICAgIHJ1bjogdGhpcy5ydW5UYXNrQ29tbWFuZCh0aGlzLl92ZXJzaW9uLnVuYnVtcFRhc2spLFxuICAgICAgfSk7XG5cbiAgICAgIHJlbGVhc2VTdGVwcy5wdXNoKHtcbiAgICAgICAgbmFtZTogJ1VwbG9hZCBhcnRpZmFjdCcsXG4gICAgICAgIGlmOiBub05ld0NvbW1pdHMsXG4gICAgICAgIHVzZXM6ICdhY3Rpb25zL3VwbG9hZC1hcnRpZmFjdEB2Mi4xLjEnLFxuICAgICAgICB3aXRoOiB7XG4gICAgICAgICAgbmFtZTogYXJ0aWZhY3REaXJlY3RvcnksXG4gICAgICAgICAgcGF0aDogYXJ0aWZhY3REaXJlY3RvcnksXG4gICAgICAgIH0sXG4gICAgICB9KTtcblxuICAgICAgY29uc3Qgd29ya2Zsb3cgPSB0aGlzLmNyZWF0ZUJ1aWxkV29ya2Zsb3coJ1JlbGVhc2UnLCB7XG4gICAgICAgIGpvYklkOiBqb2JJZCxcbiAgICAgICAgdHJpZ2dlcixcbiAgICAgICAgZW52OiB7XG4gICAgICAgICAgUkVMRUFTRTogJ3RydWUnLFxuICAgICAgICB9LFxuICAgICAgICBwcmVCdWlsZFN0ZXBzOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgbmFtZTogJ0J1bXAgdG8gbmV4dCB2ZXJzaW9uJyxcbiAgICAgICAgICAgIHJ1bjogdGhpcy5ydW5UYXNrQ29tbWFuZCh0aGlzLl92ZXJzaW9uLmJ1bXBUYXNrKSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIC4uLm9wdGlvbnMucmVsZWFzZVdvcmtmbG93U2V0dXBTdGVwcyA/PyBbXSxcbiAgICAgICAgXSxcbiAgICAgICAgcG9zdFN0ZXBzOiByZWxlYXNlU3RlcHMsXG4gICAgICAgIGltYWdlOiBvcHRpb25zLndvcmtmbG93Q29udGFpbmVySW1hZ2UsXG4gICAgICAgIGNvZGVDb3Y6IGZhbHNlLCAvLyBubyBjb2RlIGNvdmVyYWdlIG5lZWRlZCBmb3IgcmVsZWFzZVxuICAgICAgICBjaGVja291dFdpdGg6IHtcbiAgICAgICAgICAvLyB3ZSBtdXN0IHVzZSAnZmV0Y2gtZGVwdGg9MCcgaW4gb3JkZXIgdG8gZmV0Y2ggYWxsIHRhZ3NcbiAgICAgICAgICAvLyBvdGhlcndpc2UgdGFncyBhcmUgbm90IGNoZWNrZWQgb3V0XG4gICAgICAgICAgJ2ZldGNoLWRlcHRoJzogMCxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuXG4gICAgICB0aGlzLnJlbGVhc2VXb3JrZmxvdyA9IHdvcmtmbG93O1xuXG4gICAgICB0aGlzLnB1Ymxpc2hlciA9IG5ldyBQdWJsaXNoZXIodGhpcywge1xuICAgICAgICB3b3JrZmxvdzogdGhpcy5yZWxlYXNlV29ya2Zsb3csXG4gICAgICAgIGFydGlmYWN0TmFtZTogYXJ0aWZhY3REaXJlY3RvcnksXG4gICAgICAgIGJ1aWxkSm9iSWQ6IGpvYklkLFxuICAgICAgICBqc2lpUmVsZWFzZVZlcnNpb246IG9wdGlvbnMuanNpaVJlbGVhc2VWZXJzaW9uLFxuICAgICAgfSk7XG5cbiAgICAgIGlmIChvcHRpb25zLnJlbGVhc2VUb05wbSA/PyBmYWxzZSkge1xuICAgICAgICB0aGlzLnB1Ymxpc2hlci5wdWJsaXNoVG9OcG0oe1xuICAgICAgICAgIGRpc3RUYWc6IHRoaXMucGFja2FnZS5ucG1EaXN0VGFnLFxuICAgICAgICAgIHJlZ2lzdHJ5OiB0aGlzLnBhY2thZ2UubnBtUmVnaXN0cnksXG4gICAgICAgICAgbnBtVG9rZW5TZWNyZXQ6IHRoaXMucGFja2FnZS5ucG1Ub2tlblNlY3JldCxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIC8vIHZhbGlkYXRlIHRoYXQgbm8gcmVsZWFzZSBvcHRpb25zIGFyZSBzZWxlY3RlZCBpZiB0aGUgcmVsZWFzZSB3b3JrZmxvdyBpcyBkaXNhYmxlZC5cbiAgICAgIGlmIChvcHRpb25zLnJlbGVhc2VUb05wbSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1wicmVsZWFzZVRvTnBtXCIgaXMgbm90IHN1cHBvcnRlZCBmb3IgQVBQIHByb2plY3RzJyk7XG4gICAgICB9XG5cbiAgICAgIGlmIChvcHRpb25zLnJlbGVhc2VCcmFuY2hlcykge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1wicmVsZWFzZUJyYW5jaGVzXCIgaXMgbm90IHN1cHBvcnRlZCBmb3IgQVBQIHByb2plY3RzJyk7XG4gICAgICB9XG5cbiAgICAgIGlmIChvcHRpb25zLnJlbGVhc2VFdmVyeUNvbW1pdCkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1wicmVsZWFzZUV2ZXJ5Q29tbWl0XCIgaXMgbm90IHN1cHBvcnRlZCBmb3IgQVBQIHByb2plY3RzJyk7XG4gICAgICB9XG5cbiAgICAgIGlmIChvcHRpb25zLnJlbGVhc2VTY2hlZHVsZSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1wicmVsZWFzZVNjaGVkdWxlXCIgaXMgbm90IHN1cHBvcnRlZCBmb3IgQVBQIHByb2plY3RzJyk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuZ2l0aHViPy5tZXJnaWZ5KSB7XG4gICAgICB0aGlzLmF1dG9NZXJnZSA9IG5ldyBBdXRvTWVyZ2UodGhpcywge1xuICAgICAgICBidWlsZEpvYjogdGhpcy5idWlsZFdvcmtmbG93Sm9iSWQsXG4gICAgICAgIGF1dG9NZXJnZUxhYmVsOiBvcHRpb25zLm1lcmdpZnlBdXRvTWVyZ2VMYWJlbCxcbiAgICAgIH0pO1xuICAgICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoJy8ubWVyZ2lmeS55bWwnKTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5kZXBlbmRhYm90ICE9PSB1bmRlZmluZWQgJiYgb3B0aW9ucy5kZXBzVXBncmFkZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFwiJ2RlcGVuZGFib3QnIGNhbm5vdCBiZSBjb25maWd1cmVkIHRvZ2V0aGVyIHdpdGggJ2RlcHNVcGdyYWRlJ1wiKTtcbiAgICB9XG5cbiAgICBjb25zdCBkZWZhdWx0RGVwZW5kZW5jaWVzVXBncmFkZSA9IChvcHRpb25zLmRlcGVuZGFib3QgPz8gZmFsc2UpID8gRGVwZW5kZW5jaWVzVXBncmFkZU1lY2hhbmlzbS5kZXBlbmRhYm90KClcbiAgICAgIDogRGVwZW5kZW5jaWVzVXBncmFkZU1lY2hhbmlzbS5naXRodWJXb3JrZmxvdygpO1xuICAgIGNvbnN0IGRlcGVuZGVuY2llc1VwZ3JhZGUgPSBvcHRpb25zLmRlcHNVcGdyYWRlID8/IGRlZmF1bHREZXBlbmRlbmNpZXNVcGdyYWRlO1xuICAgIGRlcGVuZGVuY2llc1VwZ3JhZGUuYmluZCh0aGlzKTtcblxuICAgIGlmIChkZXBlbmRlbmNpZXNVcGdyYWRlLmlnbm9yZXNQcm9qZW4gJiYgdGhpcy5wYWNrYWdlLnBhY2thZ2VOYW1lICE9PSAncHJvamVuJykge1xuXG4gICAgICBjb25zdCBwcm9qZW5BdXRvTWVyZ2UgPSBvcHRpb25zLnByb2plblVwZ3JhZGVBdXRvTWVyZ2UgPz8gdHJ1ZTtcblxuICAgICAgbmV3IFVwZ3JhZGVEZXBlbmRlbmNpZXModGhpcywge1xuICAgICAgICBpbmNsdWRlOiBbJ3Byb2plbiddLFxuICAgICAgICB0YXNrTmFtZTogJ3VwZ3JhZGUtcHJvamVuJyxcbiAgICAgICAgaWdub3JlUHJvamVuOiBmYWxzZSxcbiAgICAgICAgd29ya2Zsb3c6ICEhb3B0aW9ucy5wcm9qZW5VcGdyYWRlU2VjcmV0LFxuICAgICAgICB3b3JrZmxvd09wdGlvbnM6IHtcbiAgICAgICAgICBzY2hlZHVsZTogVXBncmFkZURlcGVuZGVuY2llc1NjaGVkdWxlLmV4cHJlc3Npb25zKG9wdGlvbnMucHJvamVuVXBncmFkZVNjaGVkdWxlID8/IFsnMCA2ICogKiAqJ10pLFxuICAgICAgICAgIHNlY3JldDogb3B0aW9ucy5wcm9qZW5VcGdyYWRlU2VjcmV0LFxuICAgICAgICAgIGxhYmVsczogKHByb2plbkF1dG9NZXJnZSAmJiB0aGlzLmF1dG9NZXJnZT8uYXV0b01lcmdlTGFiZWwpXG4gICAgICAgICAgICA/IFt0aGlzLmF1dG9NZXJnZS5hdXRvTWVyZ2VMYWJlbF1cbiAgICAgICAgICAgIDogW10sXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5wdWxsUmVxdWVzdFRlbXBsYXRlID8/IHRydWUpIHtcbiAgICAgIHRoaXMuZ2l0aHViPy5hZGRQdWxsUmVxdWVzdFRlbXBsYXRlKC4uLm9wdGlvbnMucHVsbFJlcXVlc3RUZW1wbGF0ZUNvbnRlbnRzID8/IFtdKTtcbiAgICB9XG5cbiAgICBjb25zdCBwcm9qZW5yY0pzID0gb3B0aW9ucy5wcm9qZW5yY0pzID8/IHRydWU7XG4gICAgaWYgKHByb2plbnJjSnMpIHtcbiAgICAgIG5ldyBQcm9qZW5yYyh0aGlzLCBvcHRpb25zLnByb2plbnJjSnNPcHRpb25zKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgYWRkQmlucyhiaW5zOiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+KSB7XG4gICAgdGhpcy5wYWNrYWdlLmFkZEJpbihiaW5zKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHNldFNjcmlwdChuYW1lOiBzdHJpbmcsIGNvbW1hbmQ6IHN0cmluZykge1xuICAgIHRoaXMucGFja2FnZS5zZXRTY3JpcHQobmFtZSwgY29tbWFuZCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlbW92ZVNjcmlwdChuYW1lOiBzdHJpbmcpIHtcbiAgICB0aGlzLnBhY2thZ2UucmVtb3ZlU2NyaXB0KG5hbWUpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBoYXNTY3JpcHQobmFtZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMucGFja2FnZS5oYXNTY3JpcHQobmFtZSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFkZENvbXBpbGVDb21tYW5kKC4uLmNvbW1hbmRzOiBzdHJpbmdbXSkge1xuICAgIGZvciAoY29uc3QgYyBvZiBjb21tYW5kcykge1xuICAgICAgdGhpcy5jb21waWxlVGFzay5leGVjKGMpO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkVGVzdENvbW1hbmQoLi4uY29tbWFuZHM6IHN0cmluZ1tdKSB7XG4gICAgZm9yIChjb25zdCBjIG9mIGNvbW1hbmRzKSB7XG4gICAgICB0aGlzLnRlc3RUYXNrLmV4ZWMoYyk7XG4gICAgfVxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkQnVpbGRDb21tYW5kKC4uLmNvbW1hbmRzOiBzdHJpbmdbXSkge1xuICAgIGZvciAoY29uc3QgYyBvZiBjb21tYW5kcykge1xuICAgICAgdGhpcy5idWlsZFRhc2suZXhlYyhjKTtcbiAgICB9XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFkZEZpZWxkcyhmaWVsZHM6IHsgW25hbWU6IHN0cmluZ106IGFueSB9KSB7XG4gICAgZm9yIChjb25zdCBbbmFtZSwgdmFsdWVdIG9mIE9iamVjdC5lbnRyaWVzKGZpZWxkcykpIHtcbiAgICAgIHRoaXMucGFja2FnZS5hZGRGaWVsZChuYW1lLCB2YWx1ZSk7XG4gICAgfVxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkS2V5d29yZHMoLi4ua2V5d29yZHM6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5wYWNrYWdlLmFkZEtleXdvcmRzKC4uLmtleXdvcmRzKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW5zdGFsbFdvcmtmbG93U3RlcHMoKTogYW55W10ge1xuICAgIGNvbnN0IGluc3RhbGwgPSBuZXcgQXJyYXkoKTtcbiAgICBpZiAodGhpcy5ub2RlVmVyc2lvbikge1xuICAgICAgaW5zdGFsbC5wdXNoKHtcbiAgICAgICAgbmFtZTogJ1NldHVwIE5vZGUuanMnLFxuICAgICAgICB1c2VzOiAnYWN0aW9ucy9zZXR1cC1ub2RlQHYxJyxcbiAgICAgICAgd2l0aDogeyAnbm9kZS12ZXJzaW9uJzogdGhpcy5ub2RlVmVyc2lvbiB9LFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaW5zdGFsbC5wdXNoKHtcbiAgICAgIG5hbWU6ICdJbnN0YWxsIGRlcGVuZGVuY2llcycsXG4gICAgICBydW46IHRoaXMucGFja2FnZS5pbnN0YWxsQ29tbWFuZCxcbiAgICB9KTtcbiAgICByZXR1cm4gaW5zdGFsbDtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGREZXBzKC4uLmRlcHM6IHN0cmluZ1tdKSB7XG4gICAgcmV0dXJuIHRoaXMucGFja2FnZS5hZGREZXBzKC4uLmRlcHMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGREZXZEZXBzKC4uLmRlcHM6IHN0cmluZ1tdKSB7XG4gICAgcmV0dXJuIHRoaXMucGFja2FnZS5hZGREZXZEZXBzKC4uLmRlcHMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFkZFBlZXJEZXBzKC4uLmRlcHM6IHN0cmluZ1tdKSB7XG4gICAgcmV0dXJuIHRoaXMucGFja2FnZS5hZGRQZWVyRGVwcyguLi5kZXBzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFkZEJ1bmRsZWREZXBzKC4uLmRlcHM6IHN0cmluZ1tdKSB7XG4gICAgcmV0dXJuIHRoaXMucGFja2FnZS5hZGRCdW5kbGVkRGVwcyguLi5kZXBzKTtcbiAgfVxuXG4gIHByaXZhdGUgYWRkTGljZW5zZShvcHRpb25zOiBOb2RlUHJvamVjdE9wdGlvbnMpIHtcbiAgICBpZiAodGhpcy5wYWNrYWdlLmxpY2Vuc2UpIHtcbiAgICAgIG5ldyBMaWNlbnNlKHRoaXMsIHRoaXMucGFja2FnZS5saWNlbnNlLCB7XG4gICAgICAgIGNvcHlyaWdodE93bmVyOiBvcHRpb25zLmNvcHlyaWdodE93bmVyID8/IG9wdGlvbnMuYXV0aG9yTmFtZSxcbiAgICAgICAgY29weXJpZ2h0UGVyaW9kOiBvcHRpb25zLmNvcHlyaWdodFBlcmlvZCxcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgYWRkRGVmYXVsdEdpdElnbm9yZSgpIHtcbiAgICB0aGlzLmdpdGlnbm9yZS5leGNsdWRlKFxuICAgICAgJyMgTG9ncycsXG4gICAgICAnbG9ncycsXG4gICAgICAnKi5sb2cnLFxuICAgICAgJ25wbS1kZWJ1Zy5sb2cqJyxcbiAgICAgICd5YXJuLWRlYnVnLmxvZyonLFxuICAgICAgJ3lhcm4tZXJyb3IubG9nKicsXG4gICAgICAnbGVybmEtZGVidWcubG9nKicsXG5cbiAgICAgICcjIERpYWdub3N0aWMgcmVwb3J0cyAoaHR0cHM6Ly9ub2RlanMub3JnL2FwaS9yZXBvcnQuaHRtbCknLFxuICAgICAgJ3JlcG9ydC5bMC05XSouWzAtOV0qLlswLTldKi5bMC05XSouanNvbicsXG5cbiAgICAgICcjIFJ1bnRpbWUgZGF0YScsXG4gICAgICAncGlkcycsXG4gICAgICAnKi5waWQnLFxuICAgICAgJyouc2VlZCcsXG4gICAgICAnKi5waWQubG9jaycsXG5cbiAgICAgICcjIERpcmVjdG9yeSBmb3IgaW5zdHJ1bWVudGVkIGxpYnMgZ2VuZXJhdGVkIGJ5IGpzY292ZXJhZ2UvSlNDb3ZlcicsXG4gICAgICAnbGliLWNvdicsXG5cbiAgICAgICcjIENvdmVyYWdlIGRpcmVjdG9yeSB1c2VkIGJ5IHRvb2xzIGxpa2UgaXN0YW5idWwnLFxuICAgICAgJ2NvdmVyYWdlJyxcbiAgICAgICcqLmxjb3YnLFxuXG4gICAgICAnIyBueWMgdGVzdCBjb3ZlcmFnZScsXG4gICAgICAnLm55Y19vdXRwdXQnLFxuXG4gICAgICAnIyBDb21waWxlZCBiaW5hcnkgYWRkb25zIChodHRwczovL25vZGVqcy5vcmcvYXBpL2FkZG9ucy5odG1sKScsXG4gICAgICAnYnVpbGQvUmVsZWFzZScsXG5cbiAgICAgICcjIERlcGVuZGVuY3kgZGlyZWN0b3JpZXMnLFxuICAgICAgJ25vZGVfbW9kdWxlcy8nLFxuICAgICAgJ2pzcG1fcGFja2FnZXMvJyxcblxuICAgICAgJyMgVHlwZVNjcmlwdCBjYWNoZScsXG4gICAgICAnKi50c2J1aWxkaW5mbycsXG5cblxuICAgICAgJyMgT3B0aW9uYWwgZXNsaW50IGNhY2hlJyxcbiAgICAgICcuZXNsaW50Y2FjaGUnLFxuXG4gICAgICAnIyBPdXRwdXQgb2YgXFwnbnBtIHBhY2tcXCcnLFxuICAgICAgJyoudGd6JyxcblxuICAgICAgJyMgWWFybiBJbnRlZ3JpdHkgZmlsZScsXG4gICAgICAnLnlhcm4taW50ZWdyaXR5JyxcblxuICAgICAgJyMgcGFyY2VsLWJ1bmRsZXIgY2FjaGUgKGh0dHBzOi8vcGFyY2VsanMub3JnLyknLFxuICAgICAgJy5jYWNoZScsXG4gICAgKTtcbiAgfVxuXG4gIHByaXZhdGUgY3JlYXRlQnVpbGRXb3JrZmxvdyhuYW1lOiBzdHJpbmcsIG9wdGlvbnM6IE5vZGVCdWlsZFdvcmtmbG93T3B0aW9ucyk6IEdpdGh1YldvcmtmbG93IHtcbiAgICBjb25zdCBidWlsZEpvYklkID0gb3B0aW9ucy5qb2JJZDtcblxuICAgIGNvbnN0IGdpdGh1YiA9IHRoaXMuZ2l0aHViO1xuICAgIGlmICghZ2l0aHViKSB7IHRocm93IG5ldyBFcnJvcignbm8gZ2l0aHViIHN1cHBvcnQnKTsgfVxuXG4gICAgY29uc3Qgd29ya2Zsb3cgPSBnaXRodWIuYWRkV29ya2Zsb3cobmFtZSk7XG5cbiAgICBpZiAob3B0aW9ucy50cmlnZ2VyKSB7XG4gICAgICBpZiAob3B0aW9ucy50cmlnZ2VyLmlzc3VlX2NvbW1lbnQpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdcImlzc3VlX2NvbW1lbnRcIiBzaG91bGQgbm90IGJlIHVzZWQgYXMgYSB0cmlnZ2VyIGR1ZSB0byBhIHNlY3VyaXR5IGlzc3VlJyk7XG4gICAgICB9XG5cbiAgICAgIHdvcmtmbG93Lm9uKG9wdGlvbnMudHJpZ2dlcik7XG4gICAgfVxuXG4gICAgd29ya2Zsb3cub24oe1xuICAgICAgd29ya2Zsb3dfZGlzcGF0Y2g6IHt9LCAvLyBhbGxvdyBtYW51YWwgdHJpZ2dlcmluZ1xuICAgIH0pO1xuXG4gICAgY29uc3QgY29uZGl0aW9uID0gb3B0aW9ucy5jb25kaXRpb24gPyB7IGlmOiBvcHRpb25zLmNvbmRpdGlvbiB9IDoge307XG4gICAgY29uc3QgcHJlQnVpbGRTdGVwcyA9IG9wdGlvbnMucHJlQnVpbGRTdGVwcyA/PyBbXTtcbiAgICBjb25zdCBwcmVDaGVja291dFN0ZXBzID0gb3B0aW9ucy5wcmVDaGVja291dFN0ZXBzID8/IFtdO1xuICAgIGNvbnN0IGNoZWNrb3V0V2l0aCA9IG9wdGlvbnMuY2hlY2tvdXRXaXRoID8geyB3aXRoOiBvcHRpb25zLmNoZWNrb3V0V2l0aCB9IDoge307XG4gICAgY29uc3QgcG9zdFN0ZXBzID0gb3B0aW9ucy5wb3N0U3RlcHMgPz8gW107XG5cbiAgICBjb25zdCBhbnRpdGFtcGVyU3RlcHMgPSAob3B0aW9ucy5hbnRpdGFtcGVyRGlzYWJsZWQgfHwgIXRoaXMuYW50aXRhbXBlcikgPyBbXSA6IFt7XG4gICAgICBuYW1lOiAnQW50aS10YW1wZXIgY2hlY2snLFxuICAgICAgcnVuOiAnZ2l0IGRpZmYgLS1pZ25vcmUtc3BhY2UtYXQtZW9sIC0tZXhpdC1jb2RlJyxcbiAgICB9XTtcblxuICAgIGNvbnN0IGpvYjogYW55ID0ge1xuICAgICAgJ3J1bnMtb24nOiAndWJ1bnR1LWxhdGVzdCcsXG4gICAgICAnZW52Jzoge1xuICAgICAgICBDSTogJ3RydWUnLCAvLyB3aWxsIGNhdXNlIGBOb2RlUHJvamVjdGAgdG8gZXhlY3V0ZSBgeWFybiBpbnN0YWxsYCB3aXRoIGAtLWZyb3plbi1sb2NrZmlsZWBcbiAgICAgICAgLi4ub3B0aW9ucy5lbnYgPz8ge30sXG4gICAgICB9LFxuICAgICAgLi4uY29uZGl0aW9uLFxuICAgICAgJ3N0ZXBzJzogW1xuICAgICAgICAuLi5wcmVDaGVja291dFN0ZXBzLFxuXG4gICAgICAgIC8vIGNoZWNrIG91dCBzb3VyY2VzLlxuICAgICAgICB7XG4gICAgICAgICAgbmFtZTogJ0NoZWNrb3V0JyxcbiAgICAgICAgICB1c2VzOiAnYWN0aW9ucy9jaGVja291dEB2MicsXG4gICAgICAgICAgLi4uY2hlY2tvdXRXaXRoLFxuICAgICAgICB9LFxuXG4gICAgICAgIC8vIGluc3RhbGwgZGVwZW5kZW5jaWVzXG4gICAgICAgIC4uLnRoaXMuaW5zdGFsbFdvcmtmbG93U3RlcHMsXG5cbiAgICAgICAgLy8gcGVyZm9ybSBhbiBhbnRpLXRhbXBlciBjaGVjayBpbW1lZGlhdGVseSBhZnRlciB3ZSBydW4gcHJvamVuLlxuICAgICAgICAuLi5hbnRpdGFtcGVyU3RlcHMsXG5cbiAgICAgICAgLy8gc2V0cyBnaXQgaWRlbnRpdHkgc28gd2UgY2FuIHB1c2ggbGF0ZXJcbiAgICAgICAge1xuICAgICAgICAgIG5hbWU6ICdTZXQgZ2l0IGlkZW50aXR5JyxcbiAgICAgICAgICBydW46IFtcbiAgICAgICAgICAgICdnaXQgY29uZmlnIHVzZXIubmFtZSBcIkF1dG9tYXRpb25cIicsXG4gICAgICAgICAgICAnZ2l0IGNvbmZpZyB1c2VyLmVtYWlsIFwiZ2l0aHViLWFjdGlvbnNAZ2l0aHViLmNvbVwiJyxcbiAgICAgICAgICBdLmpvaW4oJ1xcbicpLFxuICAgICAgICB9LFxuXG4gICAgICAgIC8vIGlmIHRoZXJlIGFyZSBjaGFuZ2VzLCBjcmVhdGVzIGEgYnVtcCBjb21taXRcblxuICAgICAgICAuLi5wcmVCdWlsZFN0ZXBzLFxuXG4gICAgICAgIC8vIGJ1aWxkIChjb21waWxlICsgdGVzdClcbiAgICAgICAge1xuICAgICAgICAgIG5hbWU6ICdCdWlsZCcsXG4gICAgICAgICAgcnVuOiB0aGlzLnJ1blRhc2tDb21tYW5kKHRoaXMuYnVpbGRUYXNrKSxcbiAgICAgICAgfSxcblxuICAgICAgICAvLyBydW4gY29kZWNvdiBpZiBlbmFibGVkIG9yIGEgc2VjcmV0IHRva2VuIG5hbWUgaXMgcGFzc2VkIGluXG4gICAgICAgIC8vIEFORCBqZXN0IG11c3QgYmUgY29uZmlndXJlZFxuICAgICAgICAuLi4ob3B0aW9ucy5jb2RlQ292IHx8IG9wdGlvbnMuY29kZUNvdlRva2VuU2VjcmV0KSAmJiB0aGlzLmplc3Q/LmNvbmZpZyA/IFt7XG4gICAgICAgICAgbmFtZTogJ1VwbG9hZCBjb3ZlcmFnZSB0byBDb2RlY292JyxcbiAgICAgICAgICB1c2VzOiAnY29kZWNvdi9jb2RlY292LWFjdGlvbkB2MScsXG4gICAgICAgICAgd2l0aDogb3B0aW9ucy5jb2RlQ292VG9rZW5TZWNyZXQgPyB7XG4gICAgICAgICAgICB0b2tlbjogYFxcJHt7IHNlY3JldHMuJHtvcHRpb25zLmNvZGVDb3ZUb2tlblNlY3JldH0gfX1gLFxuICAgICAgICAgICAgZGlyZWN0b3J5OiB0aGlzLmplc3QuY29uZmlnLmNvdmVyYWdlRGlyZWN0b3J5LFxuICAgICAgICAgIH0gOiB7XG4gICAgICAgICAgICBkaXJlY3Rvcnk6IHRoaXMuamVzdC5jb25maWcuY292ZXJhZ2VEaXJlY3RvcnksXG4gICAgICAgICAgfSxcbiAgICAgICAgfV0gOiBbXSxcblxuICAgICAgICAuLi5wb3N0U3RlcHMsXG5cbiAgICAgICAgLy8gYW50aS10YW1wZXIgY2hlY2sgKGZhaWxzIGlmIHRoZXJlIHdlcmUgY2hhbmdlcyB0byBjb21taXR0ZWQgZmlsZXMpXG4gICAgICAgIC8vIHRoaXMgd2lsbCBpZGVudGlmeSBhbnkgbm9uLWNvbW1pdHRlZCBmaWxlcyBnZW5lcmF0ZWQgZHVyaW5nIGJ1aWxkIChlLmcuIHRlc3Qgc25hcHNob3RzKVxuICAgICAgICAuLi5hbnRpdGFtcGVyU3RlcHMsXG4gICAgICBdLFxuICAgIH07XG5cbiAgICBpZiAob3B0aW9ucy5pbWFnZSkge1xuICAgICAgam9iLmNvbnRhaW5lciA9IHsgaW1hZ2U6IG9wdGlvbnMuaW1hZ2UgfTtcbiAgICB9XG5cbiAgICB3b3JrZmxvdy5hZGRKb2JzKHsgW2J1aWxkSm9iSWRdOiBqb2IgfSk7XG5cbiAgICByZXR1cm4gd29ya2Zsb3c7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJ1blRhc2tDb21tYW5kKHRhc2s6IFRhc2spIHtcbiAgICBzd2l0Y2ggKHRoaXMucGFja2FnZS5ucG1UYXNrRXhlY3V0aW9uKSB7XG4gICAgICBjYXNlIE5wbVRhc2tFeGVjdXRpb24uUFJPSkVOOiByZXR1cm4gYCR7dGhpcy5wYWNrYWdlLnByb2plbkNvbW1hbmR9ICR7dGFzay5uYW1lfWA7XG4gICAgICBjYXNlIE5wbVRhc2tFeGVjdXRpb24uU0hFTEw6IHJldHVybiBgJHt0aGlzLnJ1blNjcmlwdENvbW1hbmR9ICR7dGFzay5uYW1lfWA7XG4gICAgICBkZWZhdWx0OlxuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYGludmFsaWQgbnBtVGFza0V4ZWN1dGlvbiBtb2RlOiAke3RoaXMucGFja2FnZS5ucG1UYXNrRXhlY3V0aW9ufWApO1xuICAgIH1cbiAgfVxufVxuXG5pbnRlcmZhY2UgTm9kZUJ1aWxkV29ya2Zsb3dPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBwcmltYXJ5IGpvYiBpZC5cbiAgICovXG4gIHJlYWRvbmx5IGpvYklkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEBkZWZhdWx0IC0gZGVmYXVsdCBpbWFnZVxuICAgKi9cbiAgcmVhZG9ubHkgaW1hZ2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFkZHMgYW4gXCJpZlwiIGNvbmRpdGlvbiB0byB0aGUgd29ya2Zsb3cuXG4gICAqL1xuICByZWFkb25seSBjb25kaXRpb24/OiBhbnk7XG5cbiAgLyoqXG4gICAqIFdoYXQgc2hvdWxkIHRyaWdnZXIgdGhlIHdvcmtmbG93P1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIGJ5IGRlZmF1bHQgd29ya2Zsb3dzIGNhbiBvbmx5IGJlIHRyaWdnZXJlZCBieSBtYW51YWxseS5cbiAgICovXG4gIHJlYWRvbmx5IHRyaWdnZXI/OiB7IFtldmVudDogc3RyaW5nXTogYW55IH07XG5cbiAgLyoqXG4gICAqIEJ1bXAgYSBuZXcgdmVyc2lvbiBmb3IgdGhpcyBidWlsZC5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIC8vIHJlYWRvbmx5IGJ1bXA/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBSdW4gY29kZWNvdmVyYWdlIHN0ZXBcbiAgICogU2VuZCB0byBodHRwczovL2NvZGVjb3YuaW8vXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBjb2RlQ292PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIHNlY3JldCBuYW1lIGZvciB0aGUgaHR0cHM6Ly9jb2RlY292LmlvLyB0b2tlblxuICAgKi9cbiAgcmVhZG9ubHkgY29kZUNvdlRva2VuU2VjcmV0Pzogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IHByZUJ1aWxkU3RlcHM/OiBhbnlbXTtcbiAgcmVhZG9ubHkgcHJlQ2hlY2tvdXRTdGVwcz86IGFueVtdO1xuICByZWFkb25seSBwb3N0U3RlcHM/OiBhbnlbXTtcbiAgcmVhZG9ubHkgY2hlY2tvdXRXaXRoPzogeyBba2V5OiBzdHJpbmddOiBhbnkgfTtcblxuICAvKipcbiAgICogRGlzYWJsZXMgYW50aS10YW1wZXIgY2hlY2tzIGluIHRoZSB3b3JrZmxvdy5cbiAgICovXG4gIHJlYWRvbmx5IGFudGl0YW1wZXJEaXNhYmxlZD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFdvcmtmbG93IGVudmlyb25tZW50IHZhcmlhYmxlcy5cbiAgICogQGRlZmF1bHQge31cbiAgICovXG4gIHJlYWRvbmx5IGVudj86IHsgW25hbWU6IHN0cmluZ106IHN0cmluZyB9O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE5vZGVXb3JrZmxvd1N0ZXBzIHtcbiAgcmVhZG9ubHkgYW50aXRhbXBlcjogYW55W107XG4gIHJlYWRvbmx5IGluc3RhbGw6IGFueVtdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBEZXBlbmRlbmNpZXNVcGdyYWRlTWVjaGFuaXNtIHtcblxuICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE5PTkUgPSBuZXcgRGVwZW5kZW5jaWVzVXBncmFkZU1lY2hhbmlzbSgoXzogTm9kZVByb2plY3QpID0+ICh7fSksIHRydWUpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZGVwZW5kYWJvdChvcHRpb25zOiBEZXBlbmRhYm90T3B0aW9ucyA9IHt9KSB7XG4gICAgcmV0dXJuIG5ldyBEZXBlbmRlbmNpZXNVcGdyYWRlTWVjaGFuaXNtKChwcm9qZWN0OiBOb2RlUHJvamVjdCkgPT4ge1xuICAgICAgcHJvamVjdC5naXRodWI/LmFkZERlcGVuZGFib3Qob3B0aW9ucyk7XG4gICAgfSwgb3B0aW9ucy5pZ25vcmVQcm9qZW4pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGdpdGh1YldvcmtmbG93KG9wdGlvbnM6IFVwZ3JhZGVEZXBlbmRlbmNpZXNPcHRpb25zID0ge30pIHtcbiAgICByZXR1cm4gbmV3IERlcGVuZGVuY2llc1VwZ3JhZGVNZWNoYW5pc20oKHByb2plY3Q6IE5vZGVQcm9qZWN0KSA9PiB7XG4gICAgICBuZXcgVXBncmFkZURlcGVuZGVuY2llcyhwcm9qZWN0LCBvcHRpb25zKTtcbiAgICB9LCBvcHRpb25zLmlnbm9yZVByb2plbik7XG4gIH1cblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgcmVhZG9ubHkgYmluZGVyOiAocHJvamVjdDogTm9kZVByb2plY3QpID0+IHZvaWQsXG4gICAgcHJpdmF0ZSByZWFkb25seSBfaWdub3Jlc1Byb2plbj86IGJvb2xlYW4pIHt9XG5cbiAgcHVibGljIGdldCBpZ25vcmVzUHJvamVuKCk6IGJvb2xlYW4ge1xuICAgIC8vIHdlIGlnbm9yZSBwcm9qZW4gYnkgZGVmYXVsdCBiZWNhdXNlIGl0IHJlcXVpcmVzICd3b3JrZmxvdycgcGVybWlzc2lvbnMgdG8gcnVuLlxuICAgIC8vIG5vciBkZXBlbmVkYWJvdCBub3IgdGhlIGRlZmF1bHQgZ2l0aHViIHRva2VuIGhhcyB0aG9zZSBwZXJtaXNzaW9ucy5cbiAgICByZXR1cm4gdGhpcy5faWdub3Jlc1Byb2plbiA/PyB0cnVlO1xuICB9XG5cbiAgcHVibGljIGJpbmQocHJvamVjdDogTm9kZVByb2plY3QpIHtcbiAgICB0aGlzLmJpbmRlcihwcm9qZWN0KTtcbiAgfVxufSJdfQ==