# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['munchie', 'munchie.filenom']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'toml>=0.10.2,<0.11.0']

setup_kwargs = {
    'name': 'munchie',
    'version': '0.1.1',
    'description': 'Compilation of commonly used functionality in personal projects',
    'long_description': '# Munchie\n\nMunchie is a simple file object manager to describe, manipulate and store directories and files.  \n\n---\n\n## Compatibility\n* Munchie works with Linux, OSX, and Windows.  \n* Requires Python 3.8 or later.  \n\n---\n\n## Installing\nInstall with `pip3` or your favorite PyPi package manager.  \n```\npip install munchie\n```\n\n---\n\n## Using FileMuncher\n\nImport munchie and instantiate a file_muncher object:  \n```\nfrom munchie import FileMuncher\n\nfile_muncher = FileMuncher()\n```\n\n### Default attributes\n\nBy default FileMuncher loads the current working directory as well as the user home directory into respective attributes.  \nThe attributes can be accessed by calling them from the constructed FileMuncher object.  \n```\nfile_muncher.base_dir  # current working directory\nfile_muncher.home_dir  # user home directory\n```\n\n### Create a new directory\n\nCreate a new directory at the given path: \n```\n# create \'new_directory\' in the user home folder\nfile_muncher.create_new_directory(f\'{file_muncher.home_dir}/new_directory\')\n```\n\n### Create a new file\n\nCreate a new file at the given path:  \n```\n# create \'new_file.test\' in the user home folder\nfile_muncher.create_new_file(f\'{file_muncher.home_dir}/new_file.test\')\n```\n\n### Get directory contents\n\nList the sub-directories and files of a given path:\n```\n# list the immediate contents of a path\nfile_muncher.get_directory_contents(file_muncher.home_dir)\n\n# recursively list the contents of a path\nfile_muncher.get_directory_contents(file_muncher.home_dir, recursive=True)\n```\nSub-directories will be listed under a "directories" key and sub-files will be listed under a "files" key\n\n### Get filesystem details\n\nTo get filesystem details about a directory or file:\n```\n# get filesystem details about a path\nfile_muncher.get_path_stats(f\'{file_muncher.home_dir}/new_file.test\')\n```\n\n<table>\n<thead>\n  <tr>\n    <th>Attribute</th>\n    <th>Description</th>\n  </tr>\n</thead>\n<tbody>\n  <tr>\n    <td>type</td>\n    <td>file or directory</td>\n  </tr>\n  <tr>\n    <td>st_mode</td>\n    <td>read | write | execute permissions</td>\n  </tr>\n  <tr>\n    <td>st_uid</td>\n    <td>user owner of the path. returns raw uid on Windows</td>\n  </tr>\n  <tr>\n    <td>st_gid</td>\n    <td>group owner of the path. returns raw gid on Windows</td>\n  </tr>\n  <tr>\n    <td>st_size</td>\n    <td>size in bytes</td>\n  </tr>\n  <tr>\n    <td>st_atime</td>\n    <td>time of most recent access in seconds</td>\n  </tr>\n  <tr>\n    <td>st_mtime</td>\n    <td>time of most recent content modification in seconds</td>\n  </tr>\n  <tr>\n    <td>st_ctime</td>\n    <td>time of most recent metadata change on Unix and creation time on Windows in seconds</td>\n  </tr>\n</tbody>\n</table>\n\n### Read file\n\nFileMuncher is able to read in various file types and return the contents in a format that can be manipulated.  \nSupported extensions include:\n\n<table>\n<thead>\n  <tr>\n    <th>Type</th>\n    <th>Extensions</th>\n    <th>Return Type</th>\n  </tr>\n</thead>\n<tbody>\n  <tr>\n    <td>csv</td>\n    <td>.csv</td>\n    <td>list of dicts</td>\n  </tr>\n  <tr>\n    <td>config</td>\n    <td>.cfg, .conf, .ini</td>\n    <td>dict</td>\n  </tr>\n  <tr>\n    <td>json</td>\n    <td>.json</td>\n    <td>dict</td>\n  </tr>\n  <tr>\n    <td>text</td>\n    <td>.nfo, .text, .txt</td>\n    <td>list</td>\n  </tr>\n  <tr>\n    <td>yaml</td>\n    <td>.yaml, .yml</td>\n    <td>dict</td>\n  </tr>\n</tbody>\n</table>\n\nRead in the contents of a supported file type. FileMuncher will determine the file extension and use the appropriate function to return the contents.  \n```\n# read in \'new_file.json\' and return the contents as dict\ncontents = file_muncher.read_file(f\'{file_muncher.home_dir}/new_file.json\')\n```\n\n### Remove a directory\n\nDelete a directory and all of the contents of the directory from the filesystem. This is not a permanent delete. Contents will be moved to Trash or Recycle Bin respective of the local operating system.\n```\n# prompt to remove directory \'new_dir\'\nfile_muncher.remove_directory(f\'{file_muncher.home_dir}/new_dir\')\n```\nBy default this command will require confirmation input from the user to verify prior to deletion. The confirmation requirement can be toggled off by setting the `force` flag.  \n```\n# remove directory \'new_dir\' without confirmation check\nfile_muncher.remove_directory(f\'{file_muncher.home_dir}/new_dir\', force=True)\n```\n\n### Remove a file\n\nDelete a file. This is not a permanent delete. The file will be moved to Trash or Recycle Bin respective of the local operating system.\n```\n# prompt to remove file \'new_file.test\'\nfile_muncher.remove_file(f\'{file_muncher.home_dir}/new_file.test\')\n```\nBy default this command will require confirmation input from the user to verify prior to deletion. The confirmation requirement can be toggled off by setting the force flag.  \n```\n# remove file \'new_file.test\' without confirmation check\nfile_muncher.remove_file(f\'{file_muncher.home_dir}/new_file.test\', force=True)\n```\n\n### Rotate files\n\nCleanup old files within a given path. This functionality is great for log rotation.\n```\n# prompt to rotate files in directory \'old_logs\'\nfile_muncher.rotate_files(f\'{file_muncher.home_dir}/old_logs\')\n```\n\nSpecify how many days old files to rotate should be by setting the `days_old` parameter. Default is 14 days old.\n```\n# prompt to remove files in directory \'old_logs\' older than 30 days\nfile_muncher.rotate_files(f\'{file_muncher.home_dir}/old_logs\', days_old=30)\n```\n\nBy default this action will prompt for confirmation and display a list of all paths that will be removed. This can be toggled off with a `force` flag.  \n```\n# remove files in directory \'old_logs\' older than 30 days without confirmation check\nfile_muncher.rotate_files(f\'{file_muncher.home_dir}/old_logs\', days_old=30, force=True)\n```\n\n\n### Update Path\n\nNew directory and file paths can be added to the FileMuncher object. Existing paths can also be updated.  \nWhether creating a new path or updating an existing the only requirements are the `attribute_name` and the `attribute_path`.\nA new path created by update_path will be added to a dictionary under the custom_path attribute.\n```\n# create a new attribute called \'new_file\' that points to \'new_file.test\' located in the user home directory\nfile_muncher.update_path(attribute_name=\'new_file\', attribute_path=f\'{file_muncher.home_dir}/new_file.test\')\n\n# reference a new path created by update_path\nfile_muncher.custom_path[\'new_file\']\n\n# update an existing path to point somewhere new\nfile_muncher.update_path(attribute_name=\'base_dir\', attribute_path=\'/Users/username/Documents/testing\')\n```\nWhen creating or updating a path you have the option to create a blank directory or empty file at the same time by specifying the `is_dir` or `is_file` flags. Only one flag may be chosen as a path cannot be both a directory and a file.\n```\n# create a new directory attribute and create the directory on the filesystem\nfile_muncher.update_path(attribute_name=\'new_dir\', attribute_path=f\'{file_muncher.home_dir}/new_dir\', is_dir=True)\n\n# create a new file attribute and create the file on the filesystem\nfile_muncher.update_path(attribute_name=\'new_file\', attribute_path=f\'{file_muncher.home_dir}/new_file.test\', is_file=True)\n```\n\n### Write file\n\nUpdate or create a new file with contents. Supports the following file types:\n* .csv\n* .cfg, .conf, .ini\n* .json\n* .nfo, .text, .txt\n* .yaml, .yml\n\nWrite contents to a supported file type:  \n```\n# prepare dict contents\ncontents = {\n    "file": "muncher"\n}\n# write the contents to a json file\nfile_muncher.write_file(contents, f\'{file_muncher.home_dir}/new_file.json\')\n```\n\n---\n',
    'author': 'Anthony Gaetano',
    'author_email': 'adgaetano@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<3.11',
}


setup(**setup_kwargs)
