info = {
    "name": "zh-Hans",
    "date_order": "YMD",
    "january": [
        "1月",
        "一月"
    ],
    "february": [
        "2月",
        "二月"
    ],
    "march": [
        "3月",
        "三月"
    ],
    "april": [
        "4月",
        "四月"
    ],
    "may": [
        "5月",
        "五月"
    ],
    "june": [
        "6月",
        "六月"
    ],
    "july": [
        "7月",
        "七月"
    ],
    "august": [
        "8月",
        "八月"
    ],
    "september": [
        "9月",
        "九月"
    ],
    "october": [
        "10月",
        "十月"
    ],
    "november": [
        "11月",
        "十一月"
    ],
    "december": [
        "12月",
        "十二月"
    ],
    "monday": [
        "周一",
        "星期一"
    ],
    "tuesday": [
        "周二",
        "星期二"
    ],
    "wednesday": [
        "周三",
        "星期三"
    ],
    "thursday": [
        "周四",
        "星期四"
    ],
    "friday": [
        "周五",
        "星期五"
    ],
    "saturday": [
        "周六",
        "星期六"
    ],
    "sunday": [
        "周日",
        "星期日",
        '周天'
    ],
    "am": [
        "上午"
    ],
    "pm": [
        "下午"
    ],
    "year": [
        "年"
    ],
    "month": [
        "月"
    ],
    "week": [
        "周"
    ],
    "day": [
        # "日",
    ],
    "hour": [
        "小时"
    ],
    "minute": [
        "分",
        "分钟"
    ],
    "second": [
        "秒"
    ],
    "relative-type": {
        "0 day ago": [
            "今天",
        ],
        "0 hour ago": [
            "这一时间 / 此时"
        ],
        "0 minute ago": [
            "此刻"
        ],
        "0 month ago": [
            # "本月"
        ],
        "0 second ago": [
            "现在"
        ],
        "0 week ago": [
            "本周"
        ],
        "0 year ago": [
            # "今年"
        ],
        "yesterday": [
            "昨天",
            "昨儿"
        ],
        "the_day_before_yesterday": [
            "前天"
        ],
        "a_few_days_ago": [
            "大前天"
        ],
        "1 month ago": [
            "过去一个月",
            "过去那个月",
        ],
        "6 month ago": [
            "这半年",
            "近半年",
            "半年内",
            "半年之内",
            "半年来",
            "最近半年",
            "过去半年",
            "过去半年来",
            "过去半年以来",
            "过去半年之内"
        ],
        "1 week ago": [
            "上周",
            "上一周",
            "过去一周",
            "过去一周"
        ],
        "1 year ago": [
            "去年今天",
            "去年这一天"
        ],
        "in 1 day": [
            "明天"
        ],
        "in 1 month": [
            "下个月"
        ],
        "in 1 week": [
            "下周"
        ],
        "in 1 year": [
            "明年"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+)天前",
            "(\\d+)天",
            "(\\d+)天来",
            "(\\d+)天内",
            "(\\d+)天以内",
            "(\\d+)天以来",
            "最近(\\d+)天",
            "近(\\d+)天",
            "近(\\d+)天内",
            "近(\\d+)天以来",
            "最近(\\d+)天内",
            "最近(\\d+)天以来",
        ],
        "\\1 hour ago": [
            "(\\d+)小时前"
        ],
        "\\1 minute ago": [
            "(\\d+)分钟前"
        ],
        "\\1 month ago": [
            "(\\d+)个月前",
            "(\\d+)个月",
            "(\\d+)个月内",
            "(\\d+)个月来",
            "(\\d+)个月以来",
            "(\\d+)个月以内",
            "最近(\\d+)月",
            "最近(\\d+)月间",
            "最近(\\d+)月之间",
            "最近(\\d+)个月",
            "最近(\\d+)月内",
            "最近(\\d+)月之内",
            "最近(\\d+)个月内",
            "最近(\\d+)个月之内",
            "最近(\\d+)个月之间",
            "最近(\\d+)月以来",
            "最近(\\d+)个月以来",
            "近(\\d+)月",
            "近(\\d+)个月",
            "近(\\d+)月内",
            "近(\\d+)月之内",
            "近(\\d+)个月内",
            "近(\\d+)个月之内",
            "近(\\d+)个月之间",
            "近(\\d+)月以来",
            "近(\\d+)个月以来",
        ],
        "\\1 second ago": [
            "(\\d+)秒前",
            "(\\d+)秒钟前"
        ],
        "\\1 week ago": [
            "(\\d+)周前",
            "(\\d+)周内",
            "(\\d+)周来",
            "(\\d+)周以来",
            "(\\d+)周以内",
            "(\\d+)个周",
            "(\\d+)个周内",
            "(\\d+)个周以来",
            "(\\d+)个周以内",
            "最近(\\d+)周",
            "最近(\\d+)个周",
            "最近(\\d+)周内",
            "最近(\\d+)个周内",
            "最近(\\d+)周以来",
            "最近(\\d+)个周以来",
            "近(\\d+)周",
            "近(\\d+)个周",
            "近(\\d+)周内",
            "近(\\d+)个周内",
            "近(\\d+)周以来",
            "近(\\d+)个周以来",
        ],
        "\\1 year ago": {
            "(\\d+)年前",
            "(\\d+)年内",
            "(\\d+)年来",
            "(\\d+)年间",
            "(\\d+)年之间",
            "(\\d+)年之内",
            "(\\d+)年以来",
            "(\\d+)年以内",
            "(\\d+)个年",
            "(\\d+)个年内",
            "(\\d+)个年以来",
            "(\\d+)个年以内",
            "最近(\\d+)年",
            "最近(\\d+)个年",
            "最近(\\d+)年内",
            "最近(\\d+)年间",
            "最近(\\d+)个年内",
            "最近(\\d+)年以来",
            "最近(\\d+)个年以来",
            "近(\\d+)年",
            "近(\\d+)个年",
            "近(\\d+)年内",
            "近(\\d+)年间",
            "近(\\d+)个年内",
            "近(\\d+)年以来",
            "近(\\d+)个年以来",
        },
        "in \\1 day": [
            "(\\d+)天后"
        ],
        "in \\1 hour": [
            "(\\d+)小时后"
        ],
        "in \\1 minute": [
            "(\\d+)分钟后"
        ],
        "in \\1 month": [
            "(\\d+)个月后"
        ],
        "in \\1 second": [
            "(\\d+)秒后",
            "(\\d+)秒钟后"
        ],
        "in \\1 week": [
            "(\\d+)周后"
        ],
        "in \\1 year": [
            "(\\d+)年后"
        ]
    },
    "locale_specific": {
        "zh-Hans-HK": {
            "name": "zh-Hans-HK",
            "date_order": "DMY"
        },
        "zh-Hans-MO": {
            "name": "zh-Hans-MO",
            "date_order": "DMY"
        },
        "zh-Hans-SG": {
            "name": "zh-Hans-SG",
            "date_order": "DMY"
        }
    },
    "no_word_spacing": "True",
    "sentence_splitter_group": 4,
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
