/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.exception.NotFoundException;
import com.cmayes.common.model.Atom;
import com.cmayes.common.util.ChemUtils;
import java.util.ArrayList;
import java.util.List;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACDihedralAngleCalculation
implements Calculation {
    private static final int C1_LOC = 1;
    private static final int C2_LOC = 2;
    private static final int C3_LOC = 3;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof CpCalculationSnapshot) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((CpCalculationSnapshot)rawInput);
            if (cpSnap.getGlucoseRing() == null) {
                this.logger.warn("No glucose ring for AC arm calc {}, skipping.", (Object)cpSnap.getSourceName());
                return cpSnap;
            }
            try {
                this.fillACDihedralAngles(cpSnap);
            }
            catch (NotFoundException e) {
                this.logger.warn("Missing atoms for AC arm calc {}, skipping.", (Object)cpSnap.getSourceName(), (Object)e);
            }
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    private void fillACDihedralAngles(CpCalculationSnapshot cpSnap) {
        List<Atom> glucoseRing = cpSnap.getGlucoseRing();
        ArrayList<Atom> otherAtoms = new ArrayList<Atom>(cpSnap.getAtoms());
        otherAtoms.removeAll(glucoseRing);
        Atom acArmNitro = ChemUtils.findSingleBondAtom(glucoseRing.get(2), otherAtoms, AtomicElement.NITROGEN);
        Atom acArmC7 = ChemUtils.findSingleBondAtom(acArmNitro, otherAtoms, AtomicElement.CARBON);
        cpSnap.setAcArmAngle1(ChemUtils.calcDihedralAngle(glucoseRing.get(1), glucoseRing.get(2), acArmNitro, acArmC7));
        cpSnap.setAcArmAngle2(ChemUtils.calcDihedralAngle(glucoseRing.get(3), glucoseRing.get(2), acArmNitro, acArmC7));
    }
}

