/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.util;

import com.cmayes.common.exception.NotFoundException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormatUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatUtils.class);

    private FormatUtils() {
    }

    public static int findIdx(String[] headerRow, String colName) {
        for (int i = 0; i < headerRow.length; ++i) {
            if (!headerRow[i].equalsIgnoreCase(colName)) continue;
            return i;
        }
        throw new NotFoundException("No header entry for " + colName, new Object[0]);
    }

    public static Double toDouble(String strVal, String valLabel) {
        String errMsg = String.format("Couldn't parse double %s for field %s", strVal, valLabel);
        try {
            return Double.valueOf(strVal);
        }
        catch (NumberFormatException e) {
            LOGGER.error(errMsg, e);
            throw new IllegalArgumentException(errMsg, e);
        }
    }

    public static Double[] toDoubleArray(Collection<Double> doubleColl) {
        if (doubleColl == null) {
            return new Double[0];
        }
        return doubleColl.toArray(new Double[doubleColl.size()]);
    }
}

