/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.file;

import com.cmayes.common.exception.ExceptionUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ExtensionFilter
implements FilenameFilter {
    private final Collection<String> extList;
    private final Pattern extPat;

    public ExtensionFilter(Collection<String> exts) {
        this.extList = Collections.unmodifiableCollection(ExceptionUtils.asNotNull(exts, "Extensions are null", new Object[0]));
        Collection<String> escExts = Collections2.transform(this.extList, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return Pattern.quote(input);
            }
        });
        this.extPat = Pattern.compile(String.format(".*(%s)$", StringUtils.join(escExts, "|")));
    }

    public ExtensionFilter(String ... exts) {
        this(Arrays.asList(exts));
    }

    @Override
    public boolean accept(File dir, String name) {
        File tgtFile = new File(dir, name);
        if (tgtFile.isDirectory()) {
            return true;
        }
        return this.extPat.matcher(name).matches();
    }

    public Collection<String> getExtList() {
        return this.extList;
    }
}

