Version:
-------

EGADS Lineage 1.2.5


Developments:
-------------

As the EUFAR project ended the 31st of January 2018, developments involving EGADS are now done in a new branch and the current version of EGADS is called EGADS Lineage. It is developed and maintained by Olivier Henry (https://github.com/olivierpascalhenry) and is not developed under the scope of EUFAR. Merging of the Master and Lineage branch can happen in the next EUFAR project.


Project Overview:
-----------------

EGADS (EUFAR General Airborne Data-processing Software) is a Python-based toolbox for processing airborne atmospheric data. EGADS provides a framework for researchers to apply expert-contributed algorithms to data files, and acts as a platform for data intercomparison. Algorithms in EGADS will be contributed by members of the EUFAR Expert Working Group if they are found to be mature and well-established in the scientific community.

EGADS is under development by EUFAR (European Facility for Airborne Research), an Integrating Activity funded by the European Commission. Specifically, the networking activity Standards & Protocols within EUFAR is responsible for development of toolbox, in addition to developing standards for use within the EUFAR community. A compilation of these standards and other Standards & Protocols products is available on the different Standards & Protocols webpages: 
* Standards & Protocols presentation: http://www.eufar.net/cms/standards-and-protocols/
* Standards & Protocols good practices: http://www.eufar.net/cms/good-practices/
* Standards & Protocols glossary: http://www.eufar.net/cms/glossary/
* Standards & Protocols tools: http://www.eufar.net/software-tools/list-matrix ; search for ASMM, EMC, EGADS-CORE and EGADS-GUI
  

More Information:
-----------------

An overview of how the toolbox is installed and used can be found at the EGADS Lineage Documentation (Read the docs: https://egads.readthedocs.io/en/lineage/ ; PDF file: Documentation directory). Information on the specific algorithms can be found in the Algorithm Documentation (PDF file: Documentation directory).


Features:
---------

* Persistent metadata with data objects
* Automatic unit comprehension and conversion using Quantities library
* Framework is easily extendable for integration of user algorithms
* Straightforward scripting for data processing
* Fully documented algorithms
* I/O routines for common file formats:
  * NetCDF
  * Hdf
  * NASA Ames
  * CSV
  * ASCII


Installation:
-------------

Read INSTALL.txt to learn how to install EGADS Lineage.


Documentation:
--------------

The documentation of EGADS Lineage is available as a PDF in the Documentation folder and on Read The Docs (https://egads.readthedocs.io/en/lineage/)
