from boa.interop.Neo.Header import GetIndex, GetHash, GetPrevHash, GetTimestamp, GetVersion, GetNextConsensus, GetMerkleRoot, GetConsensusData


class Block:

    @property
    def TransactionCount(self):
        """Get the number of transactions in the current block

        :return:
        """
        return GetTransactionCount(self)

    @property
    def Transactions(self):
        """Get all transactions in the current block

        :return:
        """
        return GetTransactions(self)

    @property
    def Index(self):
        """Get the current block height

        Returns:

        """
        return GetIndex(self)

    @property
    def Hash(self):
        """Get the hash of the block

        :return:
        """
        return GetHash(self)

    @property
    def Timestamp(self):
        """Get the timestamp of the block

        :return:
        """
        return GetTimestamp(self)

    @property
    def Version(self):
        """Get Block version number

        :return:
        """
        return GetVersion(self)

    @property
    def PrevHash(self):
        """Get the hash of the previous block

        :return:
        """
        return GetPrevHash(self)

    @property
    def MerkleRoot(self):
        """Get the Merkle Tree root for all transactions in that block

        :return:
        """
        return GetMerkleRoot(self)

    @property
    def ConsensusData(self):
        """Get consensus data for this block (pseudo-random number generated by consensus node)

        :return:
        """
        return GetConsensusData(self)

    @property
    def NextConsensus(self):
        """Get the hash value for the next bookkeeper contract

        :return:
        """
        return GetNextConsensus(self)


def GetTransactionCount(block):
    """Get the number of transactions in a block

    :return: the number of transactions in a block
    """
    pass


def GetTransactions(block):
    """Get all transactions in a block

    :return: a list of transactions contained in a block
    """
    pass


def GetTransaction(block, index):
    """Get the transaction specified in a block

    :param block: the block to get the transaction from
    :param index: the index of the transaction within the block

    """

    pass
