import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name="luq89-pyspark-app-luq89",
    version="0.0.7",
    author="Lukasz Ziobro",
    author_email="luki670@wp.pl",
    description="A small example package",
    long_description=long_description,
    long_description_content_type="text/markdown",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    package_dir={"": "src"},
    packages=setuptools.find_packages(where="src"),
    install_requires=[
	'bleach==3.3.0',
	'build==0.3.1.post1',
	'certifi==2020.12.5',
	'cffi==1.14.5',
	'chardet==4.0.0',
	'colorama==0.4.4',
	'cryptography==3.4.7',
	'docutils==0.17.1',
	'idna==2.10',
	'importlib-metadata==4.0.1',
	'jeepney==0.6.0',
	'keyring==23.0.1',
	'packaging==20.9',
	'pep517==0.10.0',
	'pkginfo==1.7.0',
	'py4j==0.10.9',
	'pycparser==2.20',
	'Pygments==2.9.0',
	'pyparsing==2.4.7',
	'pyspark==3.1.1',
	'readme-renderer==29.0',
	'requests==2.25.1',
	'requests-toolbelt==0.9.1',
	'rfc3986==1.4.0',
	'SecretStorage==3.3.1',
	'six==1.16.0',
	'toml==0.10.2',
	'tqdm==4.60.0',
	'twine==3.4.1',
	'typing-extensions==3.10.0.0',
	'urllib3==1.26.4',
	'webencodings==0.5.1',
	'zipp==3.4.1',
    ],
    include_package_data=True,
    python_requires=">=3.6",
)

