"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
/**
 * A white list receipt filter.
 */
class WhiteListReceiptFilter extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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