# defektor_api
defektor controll aplication interface

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import defektor_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import defektor_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import defektor_api
from pprint import pprint
from defektor_api.api import default_api
from defektor_api.model.campaign import Campaign
from defektor_api.model.plan import Plan
from defektor_api.model.slave import Slave
from defektor_api.model.system_config import SystemConfig
# Defining the host is optional and defaults to https://virtserver.swaggerhub.com/jaimelive/defektorOpenAPISpec/1.0.0
# See configuration.py for a list of all supported configuration parameters.
configuration = defektor_api.Configuration(
    host = "https://virtserver.swaggerhub.com/jaimelive/defektorOpenAPISpec/1.0.0"
)



# Enter a context with an instance of the API client
with defektor_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    campaign_id = "d290f1ee-6c54-4b01-90e6-d701748f0851" # str | Campaign identifier

    try:
        # campaign info
        api_response = api_instance.campaign_get(campaign_id)
        pprint(api_response)
    except defektor_api.ApiException as e:
        print("Exception when calling DefaultApi->campaign_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://virtserver.swaggerhub.com/jaimelive/defektorOpenAPISpec/1.0.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**campaign_get**](docs/DefaultApi.md#campaign_get) | **GET** /campaign/{campaignId} | campaign info
*DefaultApi* | [**campaign_list**](docs/DefaultApi.md#campaign_list) | **GET** /campaign | list campaigns
*DefaultApi* | [**data_collector_list**](docs/DefaultApi.md#data_collector_list) | **GET** /plugin/datacollector | list data collectors
*DefaultApi* | [**ijk_list**](docs/DefaultApi.md#ijk_list) | **GET** /plugin/ijk | list ijk (injektors)
*DefaultApi* | [**plan_add**](docs/DefaultApi.md#plan_add) | **POST** /plan | add plan
*DefaultApi* | [**plan_delete**](docs/DefaultApi.md#plan_delete) | **DELETE** /plan/{planId} | delete plan
*DefaultApi* | [**plan_delete_all**](docs/DefaultApi.md#plan_delete_all) | **DELETE** /plan | delete all plans
*DefaultApi* | [**plan_get**](docs/DefaultApi.md#plan_get) | **GET** /plan/{planId} | plan info
*DefaultApi* | [**plan_list**](docs/DefaultApi.md#plan_list) | **GET** /plan | list plans
*DefaultApi* | [**plan_validate**](docs/DefaultApi.md#plan_validate) | **POST** /plan/validate | validate plan
*DefaultApi* | [**slave_add**](docs/DefaultApi.md#slave_add) | **POST** /slave | add slave machine
*DefaultApi* | [**slave_delete**](docs/DefaultApi.md#slave_delete) | **DELETE** /slave/{slaveId} | delete slave machine
*DefaultApi* | [**slave_delete_all**](docs/DefaultApi.md#slave_delete_all) | **DELETE** /slave | delete all slaves
*DefaultApi* | [**slave_get**](docs/DefaultApi.md#slave_get) | **GET** /slave/{slaveId} | slave machine info
*DefaultApi* | [**slave_list**](docs/DefaultApi.md#slave_list) | **GET** /slave | list slave machines
*DefaultApi* | [**sys_connector_list**](docs/DefaultApi.md#sys_connector_list) | **GET** /plugin/sysconnector | list system connectors
*DefaultApi* | [**system_config_list**](docs/DefaultApi.md#system_config_list) | **GET** /system/config | list system configs
*DefaultApi* | [**system_type_configure**](docs/DefaultApi.md#system_type_configure) | **POST** /system/config | Submit system and its configurations


## Documentation For Models

 - [Campaign](docs/Campaign.md)
 - [DataCollector](docs/DataCollector.md)
 - [DataOutputURI](docs/DataOutputURI.md)
 - [DockerImage](docs/DockerImage.md)
 - [Ijk](docs/Ijk.md)
 - [Injektion](docs/Injektion.md)
 - [KeyValue](docs/KeyValue.md)
 - [Plan](docs/Plan.md)
 - [Run](docs/Run.md)
 - [SSHCredentials](docs/SSHCredentials.md)
 - [Slave](docs/Slave.md)
 - [SystemConfig](docs/SystemConfig.md)
 - [SystemType](docs/SystemType.md)
 - [WorkLoad](docs/WorkLoad.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

sob@dei.uc.pt


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in defektor_api.apis and defektor_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from defektor_api.api.default_api import DefaultApi`
- `from defektor_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import defektor_api
from defektor_api.apis import *
from defektor_api.models import *
```

