#!/usr/bin/env python3
import os.path as path


def version() -> str:
    return '1.6.3'


def tool_path() -> str:
    return path.dirname(__file__) + '/shscripts/'


def deployable_path() -> str:
    return path.dirname(__file__) + '/config/'


colors = [["\033[0;31m","\033[0;32m","\033[0;33m","\033[0;34m","\033[0;36m",
"\033[0;37m","\033[0m"],["\033[1;31m","\033[1;32m","\033[1;33m","\033[1;34m",
"\033[1;36m","\033[1;37m","\033[0m"]]

def dprintline(col: int, tool: str, textcol: int, bold: int, pusher: int, msg: str):
    print("%s[%s]%s %s%s%s" % (
        colors[1][col], tool, colors[bold][textcol], ">>> " if pusher else "", msg, colors[0][6]))
