## Description

Brief description of changes

## Type of Change

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Performance improvement
- [ ] Code refactoring

## Testing

- [ ] Unit tests pass locally
- [ ] Integration tests pass (if applicable)
- [ ] Test coverage remains above 80%
- [ ] Manual testing completed

## Checklist

- [ ] My code follows the project's style guidelines (ruff/pre-commit)
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published

## Security Checklist

- [ ] No hardcoded secrets or credentials
- [ ] No new security warnings from bandit
- [ ] Dependencies are from trusted sources
- [ ] No sensitive data logged

## Breaking Changes

List any breaking changes and migration instructions:

N/A

## Additional Notes

Add any additional notes or context about the PR here.
