import argparse

from modules.JsonSerializerCreator import JsonSerializerCreator
from modules.TOMLSerializerCreator import TomlSerializerCreator
from modules.YAMLSerializerCreator import YamlSerializerCreator

parser = argparse.ArgumentParser(description='Process converting between formats.')
parser.add_argument('source', type=str,
                    help='source file path')
parser.add_argument('source_format', type=str,
                    help='source format')
parser.add_argument('destination', type=str,
                    help='destination file path')
parser.add_argument('format', type=str,
                    help='new format')
parser.add_argument('conf_file', type=str,
                    help='configuration file')

formats = {'JSON': JsonSerializerCreator(), 'YAML': YamlSerializerCreator(), 'TOML': TomlSerializerCreator()}


def setup():
    args = parser.parse_args()
    source = None
    source_format = None
    destination = None
    format = None
    if args.conf_file is not None and args.conf_file is "config.py":
        config =__import__(config_file_name)
        flag = False

        if hasattr(config, "source"):
            source = config.source
        else:
            flag = True

        if hasattr(config, "source_format"):
            source_format = config.source_format
        else:
            flag = True

        if hasattr(config, "destination"):
            destination = config.destination
        else:
            flag = True

        if hasattr(config, "format"):
            format = config.format
        else:
            flag = True

        if not flag:
            convert(source, source_format, destination, format)
    else:
        convert(args.source, args.source_format, args.destination, args.format)


def convert(source, source_format, dest, dest_format):
    if dest_format.upper() not in formats.keys():
        raise ValueError('Invalid format')

    try:
        with open(source, 'r') as src:
            if source_format.upper() not in formats.keys():
                raise ValueError(f'File should contain a format: {formats.keys()}')
            if source_format.upper() != dest_format.upper():
                source_serializer = formats[source_format.upper()].create_serializer()
                serializer = formats[dest_format.upper()].create_serializer()
                with open(dest, 'w') as dst:
                    data = source_serializer.loads(src.read())
                    dst.write(serializer.dumps(data))
            else:
                raise ValueError(f'Source and destination format shouldn\'t be same')
    except IOError:
        print(f"Can't open file: {source}")


if __name__ == "__main__":
    setup()
