'''
Dyacon TPH-1C Sensor
This is the newer version with high resolution registers

'''

import datetime
import minimalmodbus as mm
from databear.errors import MeasureError, SensorConfigError
from databear.sensors import sensor

class dyaconTPH(sensor.Sensor):
    hardware_settings = {
        'serial':'RS485',
        'duplex':'half',
        'resistors':1,
        'bias':1
    }
    measurements = ['air_temperature','relative_humidity','barometric_pressure']
    units = {
        'air_temperature':'C',
        'relative_humidity':'%',
        'barometric_pressure':'mb'
    }
    def __init__(self,name,sn,address,interval):
        '''
        Override base class
        '''
        super().__init__(name,sn,address,interval)

        #Define characteristics of this sensor
        self.min_interval = 1  #Minimum interval that sensor can be polled
        self.registers = {
            'air_temperature':210,
            'relative_humidity':212,
            'barometric_pressure':214
        }

    def connect(self,port):
        if not self.connected:
            self.port = port
            self.comm = mm.Instrument(self.port,self.address)
            self.comm.serial.timeout = 0.3
            self.connected = True

    def measure(self):
        '''
        Read in data using modbus
        '''
        fails = {} #keep track of measurement failures
        for measure in self.measurements:
            dt = datetime.datetime.now()
            
            try:
                val = self.comm.read_float(measure['register'])
                self.data[measure['name']].append((dt,val))

            except mm.NoResponseError as norsp:
                fails[measure['name']] = 'No response from sensor'
                
        #Raise a measurement error if a fail is detected
        if len(fails)>0:
            failnames = list(fails.keys())
            raise MeasureError(self.name,failnames,fails)
    
    