/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.objects;

import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.util.Random;
import textworldexpress.objects.Door;

public class DoorMaker {
    private final Map<String, String[]> lut = (Map)Map$.MODULE$.apply(Nil$.MODULE$);

    public Map<String, String[]> lut() {
        return this.lut;
    }

    private String mkKey(String location1, String location2) {
        String key = new StringBuilder(1).append(location1).append("+").append(location2).toString();
        return key;
    }

    private void addToLUT(String location1, String location2, String[] value) {
        String key = this.mkKey(location1, location2);
        this.lut().update(key, value);
    }

    private void init() {
        this.addToLUT("pantry", "kitchen", (String[])((Object[])new String[]{"frosted-glass door", "plain door"}));
        this.addToLUT("kitchen", "backyard", (String[])((Object[])new String[]{"sliding patio door", "patio door", "screen door"}));
        this.addToLUT("corridor", "backyard", (String[])((Object[])new String[]{"sliding patio door", "patio door", "screen door"}));
        this.addToLUT("living room", "backyard", (String[])((Object[])new String[]{"sliding patio door", "patio door", "screen door"}));
        this.addToLUT("living room", "driveway", (String[])((Object[])new String[]{"front door", "fiberglass door"}));
        this.addToLUT("corridor", "driveway", (String[])((Object[])new String[]{"front door", "fiberglass door"}));
        this.addToLUT("supermarket", "street", (String[])((Object[])new String[]{"sliding door", "commercial glass door"}));
        String[] genericDoors = (String[])((Object[])new String[]{"wood door"});
        this.addToLUT("bedroom", "living room", genericDoors);
        this.addToLUT("bedroom", "bathroom", genericDoors);
        this.addToLUT("bedroom", "corridor", genericDoors);
        this.addToLUT("bathroom", "living room", genericDoors);
        this.addToLUT("bathroom", "bathroom", genericDoors);
        this.addToLUT("bathroom", "corridor", genericDoors);
        this.addToLUT("bathroom", "kitchen", genericDoors);
        this.addToLUT("laundry room", "kitchen", genericDoors);
        this.addToLUT("laundry room", "bathroom", genericDoors);
        this.addToLUT("laundry room", "corridor", genericDoors);
    }

    public Option<Door> mkDoor(Random r, String location1, String location2, boolean isOpen) {
        String key = this.mkKey(location1, location2);
        if (!this.lut().contains(key)) {
            return None$.MODULE$;
        }
        String[] possibleDoors = (String[])this.lut().apply(key);
        int randIdx = r.nextInt(possibleDoors.length);
        String description = possibleDoors[randIdx];
        Door door = new Door(description, isOpen);
        return new Some<Door>(door);
    }

    public DoorMaker() {
        this.init();
    }
}

