/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.generator;

import java.io.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import textworldexpress.games.MapReaderGameGenerator;
import textworldexpress.generator.GameGenerator;
import textworldexpress.struct.TextGame;

public class GameGeneratorMapReader
extends GameGenerator {
    private final int numLocations;
    private final int maxDistanceApart;
    private final int numDistractorItems;
    private final boolean includeDoors;
    private final boolean limitInventorySize;
    private final MapReaderGameGenerator generator;

    public MapReaderGameGenerator generator() {
        return this.generator;
    }

    private String checkValidConfiguration() {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        Serializable serializable = this.numLocations < 1 ? os.append(new StringBuilder(67).append("Number of locations must be greater than one (specified value = ").append(this.numLocations).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable2 = this.numLocations > 11 ? os.append(new StringBuilder(75).append("Number of locations must be less than or equal to 11 (specified value = ").append(this.numLocations).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable3 = this.maxDistanceApart < 1 ? os.append(new StringBuilder(63).append("Maximum distance apart must be at least 1 (specified value = ").append(this.maxDistanceApart).append(").").toString()) : BoxedUnit.UNIT;
        Serializable serializable4 = this.maxDistanceApart > 4 ? os.append(new StringBuilder(76).append("Maximum distance apart must be less than or equal to 4 (specified value = ").append(this.maxDistanceApart).append(").").toString()) : BoxedUnit.UNIT;
        Serializable serializable5 = this.numDistractorItems < 0 ? os.append(new StringBuilder(89).append("Number of distractor objects must be greater than or equal to zero (specified value = ").append(this.numDistractorItems).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable6 = this.numDistractorItems > 10 ? os.append(new StringBuilder(84).append("Number of distractor objects must be less than or equal to 10 (specified value = ").append(this.numDistractorItems).append("). ").toString()) : BoxedUnit.UNIT;
        return os.toString();
    }

    @Override
    public boolean isInvalid() {
        return this.errorStr().length() > 0;
    }

    @Override
    public TextGame mkGame(long seed, String fold) {
        return this.generator().mkGame(seed, this.numLocations, this.maxDistanceApart, this.numDistractorItems, this.includeDoors, this.limitInventorySize, fold);
    }

    @Override
    public Tuple2<TextGame, String[]> mkGameWithGoldPath(long seed, String fold) {
        return this.generator().mkGameWithGoldPath(seed, this.numLocations, this.maxDistanceApart, this.numDistractorItems, this.includeDoors, this.limitInventorySize, fold);
    }

    public GameGeneratorMapReader(int numLocations, int maxDistanceApart, int numDistractorItems, boolean includeDoors, boolean limitInventorySize) {
        this.numLocations = numLocations;
        this.maxDistanceApart = maxDistanceApart;
        this.numDistractorItems = numDistractorItems;
        this.includeDoors = includeDoors;
        this.limitInventorySize = limitInventorySize;
        this.generator = new MapReaderGameGenerator();
        this.errorStr_$eq(this.checkValidConfiguration());
    }
}

