/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.generator;

import java.io.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import textworldexpress.games.CoinGameGenerator;
import textworldexpress.generator.GameGenerator;
import textworldexpress.struct.TextGame;

public class GameGeneratorCoin
extends GameGenerator {
    private final int numLocations;
    private final int numDistractorItems;
    private final boolean includeDoors;
    private final boolean limitInventorySize;
    private final CoinGameGenerator generator;

    public CoinGameGenerator generator() {
        return this.generator;
    }

    private String checkValidConfiguration() {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        Serializable serializable = this.numLocations < 1 ? os.append(new StringBuilder(67).append("Number of locations must be greater than one (specified value = ").append(this.numLocations).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable2 = this.numLocations > 11 ? os.append(new StringBuilder(75).append("Number of locations must be less than or equal to 11 (specified value = ").append(this.numLocations).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable3 = this.numDistractorItems < 0 ? os.append(new StringBuilder(89).append("Number of distractor objects must be greater than or equal to zero (specified value = ").append(this.numDistractorItems).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable4 = this.numDistractorItems > 10 ? os.append(new StringBuilder(84).append("Number of distractor objects must be less than or equal to 10 (specified value = ").append(this.numDistractorItems).append("). ").toString()) : BoxedUnit.UNIT;
        return os.toString();
    }

    @Override
    public boolean isInvalid() {
        return this.errorStr().length() > 0;
    }

    @Override
    public TextGame mkGame(long seed, String fold) {
        return this.generator().mkGame(seed, this.numLocations, this.numDistractorItems, this.includeDoors, this.limitInventorySize, fold);
    }

    @Override
    public Tuple2<TextGame, String[]> mkGameWithGoldPath(long seed, String fold) {
        return this.generator().mkGameWithGoldPath(seed, this.numLocations, this.numDistractorItems, this.includeDoors, this.limitInventorySize, fold);
    }

    public GameGeneratorCoin(int numLocations, int numDistractorItems, boolean includeDoors, boolean limitInventorySize) {
        this.numLocations = numLocations;
        this.numDistractorItems = numDistractorItems;
        this.includeDoors = includeDoors;
        this.limitInventorySize = limitInventorySize;
        this.generator = new CoinGameGenerator();
        this.errorStr_$eq(this.checkValidConfiguration());
    }
}

