/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple7;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.LoadTWCDataJSON;
import textworldexpress.data.LoadTWCDataJSON$;
import textworldexpress.data.LoadTWKitchenDataJSON;
import textworldexpress.data.LoadTWKitchenDataJSON$;
import textworldexpress.games.MapReaderGame;
import textworldexpress.games.MapReaderGame$;
import textworldexpress.goldagent.MapReaderGoldAgent;
import textworldexpress.objects.Alley;
import textworldexpress.objects.Backyard;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Box;
import textworldexpress.objects.Coin;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.Door;
import textworldexpress.objects.DoorMaker;
import textworldexpress.objects.Driveway;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Foyer;
import textworldexpress.objects.Garage;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.Mapbook;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;
import textworldexpress.objects.Sideyard;
import textworldexpress.objects.Street;
import textworldexpress.objects.Supermarket;

public class MapReaderGameGenerator {
    private final LoadTWCDataJSON TWCObjectDatabase = new LoadTWCDataJSON(LoadTWCDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final LoadTWKitchenDataJSON TWKitchenObjectDatabase = new LoadTWKitchenDataJSON(LoadTWKitchenDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final DoorMaker doorMaker = new DoorMaker();
    private final int SEGMENT_MODE_INDIVIDUAL;
    private final int SEGMENT_MODE_GROUPED;

    public LoadTWCDataJSON TWCObjectDatabase() {
        return this.TWCObjectDatabase;
    }

    public DoorMaker doorMaker() {
        return this.doorMaker;
    }

    public Tuple7<ArrayBuffer<Room>, ArrayBuffer<FastObject>, Mapbook, Box, Room, Room, Object> mkEnvironment(Random r, int numLocations, int maxDistanceApart, int numDistractorItems, boolean includeDoors, String fold) {
        ArrayBuffer<Room> locations = new ArrayBuffer<Room>();
        Kitchen kitchen = new Kitchen(r, false);
        locations.append(kitchen);
        Object object = numLocations >= 2 ? locations.append(new Pantry(r)) : BoxedUnit.UNIT;
        Object object2 = numLocations >= 3 ? locations.append(new Corridor(r)) : BoxedUnit.UNIT;
        Object object3 = numLocations >= 4 ? locations.append(new Bedroom(r)) : BoxedUnit.UNIT;
        Object object4 = numLocations >= 5 ? locations.append(new Backyard(r)) : BoxedUnit.UNIT;
        Object object5 = numLocations >= 6 ? locations.append(new LivingRoom(r)) : BoxedUnit.UNIT;
        Object object6 = numLocations >= 7 ? locations.append(new Bathroom(r)) : BoxedUnit.UNIT;
        Object object7 = numLocations >= 8 ? locations.append(new LaundryRoom(r)) : BoxedUnit.UNIT;
        Object object8 = numLocations >= 9 ? locations.append(new Driveway(r)) : BoxedUnit.UNIT;
        Object object9 = numLocations >= 10 ? locations.append(new Street(r)) : BoxedUnit.UNIT;
        Object object10 = numLocations >= 11 ? locations.append(new Supermarket(r)) : BoxedUnit.UNIT;
        Object object11 = numLocations >= 12 ? locations.append(new Sideyard(r)) : BoxedUnit.UNIT;
        Object object12 = numLocations >= 13 ? locations.append(new Alley(r)) : BoxedUnit.UNIT;
        Object object13 = numLocations >= 14 ? locations.append(new Foyer(r)) : BoxedUnit.UNIT;
        Object object14 = numLocations >= 15 ? locations.append(new Garage(r)) : BoxedUnit.UNIT;
        Option map = None$.MODULE$;
        for (int attempts = 0; map.isEmpty() && attempts < 50; ++attempts) {
            map = this.mkConnections(r, locations);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("ERROR: Could not generate connection map");
        }
        this.connectRoomsFromMap(r, (Room[][])((Option)map).get(), includeDoors);
        int distanceApart = r.nextInt(maxDistanceApart) + 1;
        Option<Tuple2<Room, Room>> startEndLocations = this.findStartEndLocations(r, locations, distanceApart);
        if (startEndLocations.isEmpty()) {
            throw new RuntimeException(new java.lang.StringBuilder(59).append("ERROR: No locations could be found that distance apart (").append(maxDistanceApart).append("). ").toString());
        }
        Room startLocation = startEndLocations.get()._1();
        Room endLocation = startEndLocations.get()._2();
        Coin coin = new Coin();
        endLocation.addObject(coin);
        ArrayBuffer<Coin> taskObjects = new ArrayBuffer<Coin>();
        taskObjects.append(coin);
        Box box = new Box();
        startLocation.addObject(box);
        ArrayBuffer<FastObject> addedDistractorNames = this.addTWCItems(r, locations, numDistractorItems, fold);
        Mapbook mapbook = this.mkMap(r, locations, this.SEGMENT_MODE_GROUPED());
        return new Tuple7<ArrayBuffer<Room>, ArrayBuffer<FastObject>, Mapbook, Box, Room, Room, Object>(locations, taskObjects, mapbook, box, startLocation, endLocation, BoxesRunTime.boxToInteger(distanceApart));
    }

    public Option<Tuple2<Room, Room>> findStartEndLocations(Random r, ArrayBuffer<Room> locations, int distance) {
        int MAX_ATTEMPTS = 25;
        for (int attempts = 0; attempts < MAX_ATTEMPTS; ++attempts) {
            int randomLocationIdx = r.nextInt(locations.length());
            Room startLocation = locations.apply(randomLocationIdx);
            ArrayBuffer<Room> locationsAtDistance = this.getRoomsAtDistance(locations, startLocation, distance);
            if (locationsAtDistance.length() <= 0) continue;
            ArrayBuffer shuffled = (ArrayBuffer)r.shuffle(locationsAtDistance, BuildFrom$.MODULE$.buildFromIterableOps());
            Room endLocation = (Room)shuffled.apply(0);
            return new Some<Tuple2<Room, Room>>(new Tuple2<Room, Room>(startLocation, endLocation));
        }
        return None$.MODULE$;
    }

    private ArrayBuffer<Room> getRoomsAtDistance(ArrayBuffer<Room> locations, Room startLocation, int distance) {
        int[] distances = new int[locations.length()];
        ObjectRef locationsToCheck = ObjectRef.create(new ArrayBuffer());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), locations.length()).foreach((Function1<Object, Object> & Serializable)i -> MapReaderGameGenerator.$anonfun$getRoomsAtDistance$1(locations, startLocation, distances, locationsToCheck, BoxesRunTime.unboxToInt(i)));
        while (((ArrayBuffer)locationsToCheck.elem).length() > 0) {
            ArrayBuffer nextLocations = new ArrayBuffer();
            ((ArrayBuffer)locationsToCheck.elem).foreach((Function1<Room, Object> & Serializable)location -> {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                int curDist = distances[locations.indexOf(location)];
                if (location.locationNorth() != null) {
                    int idx = locations.indexOf(location.locationNorth());
                    if (distances[idx] < 0) {
                        distances$1[idx] = curDist + 1;
                        object4 = nextLocations.append(location.locationNorth());
                    } else {
                        object4 = BoxedUnit.UNIT;
                    }
                } else {
                    object4 = BoxedUnit.UNIT;
                }
                if (location.locationSouth() != null) {
                    int idx = locations.indexOf(location.locationSouth());
                    if (distances[idx] < 0) {
                        distances$1[idx] = curDist + 1;
                        object3 = nextLocations.append(location.locationSouth());
                    } else {
                        object3 = BoxedUnit.UNIT;
                    }
                } else {
                    object3 = BoxedUnit.UNIT;
                }
                if (location.locationEast() != null) {
                    int idx = locations.indexOf(location.locationEast());
                    if (distances[idx] < 0) {
                        distances$1[idx] = curDist + 1;
                        object2 = nextLocations.append(location.locationEast());
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                } else {
                    object2 = BoxedUnit.UNIT;
                }
                if (location.locationWest() != null) {
                    int idx = locations.indexOf(location.locationWest());
                    if (distances[idx] < 0) {
                        distances$1[idx] = curDist + 1;
                        object = nextLocations.append(location.locationWest());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            locationsToCheck.elem = nextLocations;
        }
        ArrayBuffer<Room> out = new ArrayBuffer<Room>();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), locations.length()).foreach((Function1<Object, Object> & Serializable)i -> MapReaderGameGenerator.$anonfun$getRoomsAtDistance$3(distances, distance, out, locations, BoxesRunTime.unboxToInt(i)));
        return out;
    }

    public int SEGMENT_MODE_INDIVIDUAL() {
        return this.SEGMENT_MODE_INDIVIDUAL;
    }

    public int SEGMENT_MODE_GROUPED() {
        return this.SEGMENT_MODE_GROUPED;
    }

    public Mapbook mkMap(Random r, ArrayBuffer<Room> locations, int segmentMode) {
        ArrayBuffer segments = new ArrayBuffer();
        locations.foreach((Function1<Room, Object> & Serializable)location -> {
            Object object;
            if (segmentMode == this.SEGMENT_MODE_INDIVIDUAL()) {
                Object object2 = location.locationNorth() != null ? segments.append(new java.lang.StringBuilder(22).append("The ").append(location.name()).append(" connects to the ").append(location.locationNorth().name()).append(".").toString()) : BoxedUnit.UNIT;
                Object object3 = location.locationSouth() != null ? segments.append(new java.lang.StringBuilder(22).append("The ").append(location.name()).append(" connects to the ").append(location.locationSouth().name()).append(".").toString()) : BoxedUnit.UNIT;
                Object object4 = location.locationEast() != null ? segments.append(new java.lang.StringBuilder(22).append("The ").append(location.name()).append(" connects to the ").append(location.locationEast().name()).append(".").toString()) : BoxedUnit.UNIT;
                object = location.locationWest() != null ? segments.append(new java.lang.StringBuilder(22).append("The ").append(location.name()).append(" connects to the ").append(location.locationWest().name()).append(".").toString()) : BoxedUnit.UNIT;
            } else if (segmentMode == this.SEGMENT_MODE_GROUPED()) {
                ArrayBuffer<String> connections = new ArrayBuffer<String>();
                Object object5 = location.locationNorth() != null ? connections.append(location.locationNorth().name()) : BoxedUnit.UNIT;
                Object object6 = location.locationSouth() != null ? connections.append(location.locationSouth().name()) : BoxedUnit.UNIT;
                Object object7 = location.locationEast() != null ? connections.append(location.locationEast().name()) : BoxedUnit.UNIT;
                Object object8 = location.locationWest() != null ? connections.append(location.locationWest().name()) : BoxedUnit.UNIT;
                if (connections.length() > 0) {
                    if (connections.length() == 1) {
                        object = segments.append(new java.lang.StringBuilder(22).append("The ").append(location.name()).append(" connects to the ").append(connections.apply(0)).append(".").toString());
                    } else {
                        ArrayBuffer shuffledConnections = (ArrayBuffer)r.shuffle(connections, BuildFrom$.MODULE$.buildFromIterableOps());
                        ArrayBuffer connectionsFirst = (ArrayBuffer)shuffledConnections.slice(0, shuffledConnections.length() - 1);
                        String connectionsLast = (String)shuffledConnections.last();
                        object = segments.append(new java.lang.StringBuilder(27).append("The ").append(location.name()).append(" connects to the ").append(connectionsFirst.mkString(", ")).append(" and ").append(connectionsLast).append(".").toString());
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new RuntimeException(new java.lang.StringBuilder(40).append("ERROR: mkMap(): Unknown segment mode (").append(segmentMode).append(").").toString());
            }
            return object;
        });
        StringBuilder os = new StringBuilder();
        os.append("The map reads:\n");
        ArrayBuffer segmentsShuffled = (ArrayBuffer)r.shuffle(segments, BuildFrom$.MODULE$.buildFromIterableOps());
        segmentsShuffled.foreach((Function1<String, StringBuilder> & Serializable)segmentStr -> os.append(new java.lang.StringBuilder(3).append("  ").append((String)segmentStr).append("\n").toString()));
        Mapbook mapbook = new Mapbook();
        mapbook.readText_$eq(os.toString());
        return mapbook;
    }

    public ArrayBuffer<FastObject> addTWCItems(Random r, ArrayBuffer<Room> locations, int numToAdd, String fold) {
        ArrayBuffer<FastObject> objectsAdded = new ArrayBuffer<FastObject>();
        ArrayBuffer<String> objectNamesAdded = new ArrayBuffer<String>();
        for (int attempts = 0; objectsAdded.length() < numToAdd && attempts < 100; ++attempts) {
            BoxedUnit boxedUnit;
            int randLocIdx = r.nextInt(locations.length());
            Room location = locations.apply(randLocIdx);
            FastObject[] objects = (FastObject[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])location.contents().toArray(ClassTag$.MODULE$.apply(FastObject.class))), (Function1<FastObject, String> & Serializable)x$2 -> x$2.name(), Ordering$String$.MODULE$);
            if (objects.length > 0) {
                int randObjIdx = r.nextInt(objects.length);
                FastObject container = objects[randObjIdx];
                Option<FastObject> item = this.TWCObjectDatabase().mkRandomObjectByLocation(r, container.name(), fold);
                if (item.isDefined()) {
                    if (!objectNamesAdded.contains(item.get().name())) {
                        Object object;
                        FastObject containerRoom = container.currentContainer();
                        FastObject fastObject = containerRoom;
                        if (fastObject instanceof Room) {
                            Room room = (Room)fastObject;
                            room.addObject(item.get());
                            objectNamesAdded.append(item.get().name());
                            object = objectsAdded.append(item.get());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        boxedUnit = object;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return objectsAdded;
    }

    public void connectRoomsFromMap(Random r, Room[][] map, boolean includeDoors) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map.length).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map[i].length).foreach$mVc$sp(j -> {
            block8: {
                Room queryLoc;
                Room queryLoc2;
                Room queryLoc3;
                Room queryLoc4;
                Room cell = map[i][j];
                if (cell == null) break block8;
                if (i < map.length - 1 && (queryLoc4 = map[i + 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc4.name())) {
                    Option<Door> door;
                    cell.locationNorth_$eq(queryLoc4);
                    queryLoc4.locationSouth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc4.name(), false)).isDefined()) {
                        cell.doorNorth_$eq(door.get());
                        queryLoc4.doorSouth_$eq(door.get());
                    }
                }
                if (i >= 1 && (queryLoc3 = map[i - 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc3.name())) {
                    Option<Door> door;
                    cell.locationSouth_$eq(queryLoc3);
                    queryLoc3.locationNorth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc3.name(), false)).isDefined()) {
                        cell.doorSouth_$eq(door.get());
                        queryLoc3.doorNorth_$eq(door.get());
                    }
                }
                if (j >= 1 && (queryLoc2 = map[i][j - 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc2.name())) {
                    Option<Door> door;
                    cell.locationEast_$eq(queryLoc2);
                    queryLoc2.locationWest_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc2.name(), false)).isDefined()) {
                        cell.doorEast_$eq(door.get());
                        queryLoc2.doorWest_$eq(door.get());
                    }
                }
                if (j < map[i].length - 1 && (queryLoc = map[i][j + 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc.name())) {
                    Option<Door> door;
                    cell.locationWest_$eq(queryLoc);
                    queryLoc.locationEast_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc.name(), false)).isDefined()) {
                        cell.doorWest_$eq(door.get());
                        queryLoc.doorEast_$eq(door.get());
                    }
                }
            }
        }));
    }

    public Tuple2<Object, Object> findEmptyDirection(Random r, Room[][] map, int locX, int locY) {
        Object object = new Object();
        try {
            ArrayBuffer orderToCheck = (ArrayBuffer)r.shuffle((IterableOnce)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), BuildFrom$.MODULE$.buildFromIterableOps());
            orderToCheck.foreach(directionRef -> {
                if (directionRef == 0) {
                    if (locX - 1 >= 0 && map[locX - 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX - 1, locY));
                    }
                } else if (directionRef == 1) {
                    if (locX + 1 < map.length && map[locX + 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX + 1, locY));
                    }
                } else if (directionRef == 2) {
                    if (locY - 1 >= 0 && map[locX][locY - 1] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY - 1));
                    }
                } else if (directionRef == 3 && locY + 1 < map.length && map[locX][locY + 1] == null) {
                    throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY + 1));
                }
            });
            return new Tuple2$mcII$sp(-1, -1);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public Option<Room[][]> mkConnections(Random r, ArrayBuffer<Room> locations) {
        int GRID_SIZE = 7;
        Room[][] map = (Room[][])Array$.MODULE$.ofDim(GRID_SIZE, GRID_SIZE, ClassTag$.MODULE$.apply(Room.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(j -> {
            map$4[i$3][j] = null;
        }));
        ArrayBuffer locationsLeft = new ArrayBuffer();
        locationsLeft.insertAll(0, (IterableOnce)r.shuffle(locations, BuildFrom$.MODULE$.buildFromIterableOps()));
        IntRef lastX = IntRef.create(3);
        IntRef lastY = IntRef.create(3);
        map[lastX.elem][lastY.elem] = (Room)locationsLeft.last();
        locationsLeft.remove(locationsLeft.size() - 1);
        ObjectRef<Room> lastLocation = ObjectRef.create(map[lastX.elem][lastY.elem]);
        IntRef attempts = IntRef.create(0);
        ArrayBuffer<Tuple2$mcII$sp> populatedLocations = new ArrayBuffer<Tuple2$mcII$sp>();
        populatedLocations.append(new Tuple2$mcII$sp(lastX.elem, lastY.elem));
        Breaks$.MODULE$.breakable(() -> {
            while (locationsLeft.length() > 0) {
                Object object;
                int refIdx = r.nextInt(populatedLocations.length());
                lastX$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._1$mcI$sp();
                lastY$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._2$mcI$sp();
                lastLocation$1.elem = map[lastX$1.elem][lastY$1.elem];
                int locationIdx = r.nextInt(locationsLeft.length());
                Room location = (Room)locationsLeft.apply(locationIdx);
                if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(location.prefersConnectingTo()), ((Room)lastLocation$1.elem).name())) {
                    Tuple2<Object, Object> tuple2 = this.findEmptyDirection(r, map, lastX$1.elem, lastY$1.elem);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int newX = tuple2._1$mcI$sp();
                    int newY = tuple2._2$mcI$sp();
                    Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(newX, newY);
                    Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
                    int newX2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
                    int newY2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
                    if (newX2 != -1) {
                        map$4[newX2][newY2] = location;
                        locationsLeft.remove(locationIdx);
                        object = populatedLocations.append(new Tuple2$mcII$sp(newX2, newY2));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                ++attempts$1.elem;
                if (attempts$1.elem <= 100) continue;
                throw Breaks$.MODULE$.break();
            }
        });
        if (locationsLeft.length() > 0) {
            return None$.MODULE$;
        }
        return new Some<Room[][]>(map);
    }

    public MapReaderGame mkGame(long seed, int numLocations, int maxDistanceApart, int numDistractorItems, boolean includeDoors, boolean limitInventorySize, String fold) {
        Integer n;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        props.update("numLocations", BoxesRunTime.boxToInteger(numLocations));
        props.update("maxDistanceApart", BoxesRunTime.boxToInteger(maxDistanceApart));
        props.update("numDistractorItems", BoxesRunTime.boxToInteger(numDistractorItems));
        props.update("includeDoors", includeDoors ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        props.update("limitInventorySize", limitInventorySize ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n);
        Random r = new Random(seed);
        Tuple7<ArrayBuffer<Room>, ArrayBuffer<FastObject>, Mapbook, Box, Room, Room, Object> tuple7 = this.mkEnvironment(r, numLocations, maxDistanceApart, numDistractorItems, includeDoors, fold);
        if (tuple7 == null) {
            throw new MatchError(tuple7);
        }
        ArrayBuffer<Room> locations = tuple7._1();
        ArrayBuffer<FastObject> taskObjects = tuple7._2();
        Mapbook mapbook = tuple7._3();
        Box box = tuple7._4();
        Room startLocation = tuple7._5();
        Room endLocation = tuple7._6();
        int actualDistanceApart = BoxesRunTime.unboxToInt(tuple7._7());
        Tuple7<ArrayBuffer<Room>, ArrayBuffer<FastObject>, Mapbook, Box, Room, Room, Integer> tuple72 = new Tuple7<ArrayBuffer<Room>, ArrayBuffer<FastObject>, Mapbook, Box, Room, Room, Integer>(locations, taskObjects, mapbook, box, startLocation, endLocation, BoxesRunTime.boxToInteger(actualDistanceApart));
        Tuple7<ArrayBuffer<Room>, ArrayBuffer<FastObject>, Mapbook, Box, Room, Room, Integer> tuple73 = tuple72;
        ArrayBuffer<Room> locations2 = tuple73._1();
        ArrayBuffer<FastObject> taskObjects2 = tuple73._2();
        Mapbook mapbook2 = tuple73._3();
        Box box2 = tuple73._4();
        Room startLocation2 = tuple73._5();
        Room endLocation2 = tuple73._6();
        int actualDistanceApart2 = BoxesRunTime.unboxToInt(tuple73._7());
        props.update("actualDistanceApart", BoxesRunTime.boxToInteger(actualDistanceApart2));
        Room[] x$1 = (Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class));
        ArrayBuffer<FastObject> x$2 = taskObjects2;
        Mapbook x$3 = mapbook2;
        Box x$4 = box2;
        Room x$5 = startLocation2;
        Room x$6 = endLocation2;
        int x$7 = actualDistanceApart2;
        boolean x$8 = limitInventorySize;
        scala.collection.immutable.Map<String, Object> x$9 = props.toMap($less$colon$less$.MODULE$.refl());
        long x$10 = MapReaderGame$.MODULE$.$lessinit$greater$default$9();
        MapReaderGame game = new MapReaderGame(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$10, x$9);
        return game;
    }

    public String mkGame$default$7() {
        return "train";
    }

    public Tuple2<MapReaderGame, String[]> mkGameWithGoldPath(long seed, int numLocations, int maxDistanceApart, int numDistractorItems, boolean includeDoors, boolean limitInventorySize, String fold) {
        int MAX_ATTEMPTS = 1;
        Random rg = new Random();
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$2.elem < MAX_ATTEMPTS) {
                MapReaderGame game = this.mkGame(seed, numLocations, maxDistanceApart, numDistractorItems, includeDoors, limitInventorySize, fold);
                MapReaderGoldAgent goldAgent = new MapReaderGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$2.elem;
            }
            Predef$.MODULE$.println(new java.lang.StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        MapReaderGame game = this.mkGame(seed, numLocations, maxDistanceApart, numDistractorItems, includeDoors, limitInventorySize, this.mkGame$default$7());
        return new Tuple2<MapReaderGame, String[]>(game, (String[])goldPath.elem);
    }

    public static final /* synthetic */ Object $anonfun$getRoomsAtDistance$1(ArrayBuffer locations$1, Room startLocation$1, int[] distances$1, ObjectRef locationsToCheck$1, int i) {
        Object object;
        String string = ((FastObject)locations$1.apply(i)).name();
        String string2 = startLocation$1.name();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            distances$1[i] = 0;
            object = ((ArrayBuffer)locationsToCheck$1.elem).append(startLocation$1);
        } else {
            distances$1[i] = -1;
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static final /* synthetic */ Object $anonfun$getRoomsAtDistance$3(int[] distances$1, int distance$1, ArrayBuffer out$1, ArrayBuffer locations$1, int i) {
        return distances$1[i] == distance$1 ? out$1.append(locations$1.apply(i)) : BoxedUnit.UNIT;
    }

    public MapReaderGameGenerator() {
        this.SEGMENT_MODE_INDIVIDUAL = 0;
        this.SEGMENT_MODE_GROUPED = 1;
    }
}

