/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.SetNode;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class HashSetBuilder<A>
implements ReusableBuilder<A, HashSet<A>> {
    private HashSet<A> aliased;
    private BitmapIndexedSetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode = this.newEmptyRootNode();

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<HashSet<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable<A> $plus$eq(A elem) {
        return Growable.$plus$eq$(this, elem);
    }

    private BitmapIndexedSetNode<A> newEmptyRootNode() {
        return new BitmapIndexedSetNode(0, 0, Array$.MODULE$.emptyObjectArray(), Array$.MODULE$.emptyIntArray(), 0, 0);
    }

    private HashSet<A> aliased() {
        return this.aliased;
    }

    private void aliased_$eq(HashSet<A> x$1) {
        this.aliased = x$1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public BitmapIndexedSetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode;
    }

    private void rootNode_$eq(BitmapIndexedSetNode<A> x$1) {
        this.scala$collection$immutable$HashSetBuilder$$rootNode = x$1;
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <A1> void insertValue(BitmapIndexedSetNode<A> bm, int bitpos, A key, int originalHash, int keyHash) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    private <A1> void setValue(BitmapIndexedSetNode<A> bm, int bitpos, A elem) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        bm.content()[idx] = elem;
    }

    public void update(SetNode<A> setNode, A element, int originalHash, int elementHash, int shift) {
        if (setNode instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode;
            int n = elementHash >>> shift & 0x1F;
            int n2 = 1 << n;
            if ((bitmapIndexedSetNode.dataMap() & n2) != 0) {
                Object object;
                int index = Node$.MODULE$.indexFrom(bitmapIndexedSetNode.dataMap(), n, n2);
                Object object2 = object = bitmapIndexedSetNode.content()[index];
                object = null;
                Object element0 = object2;
                int n3 = bitmapIndexedSetNode.originalHashes()[index];
                if (n3 == originalHash && BoxesRunTime.equals(element0, element)) {
                    this.setValue(bitmapIndexedSetNode, n2, element0);
                    return;
                }
                int element0Hash = Hashing$.MODULE$.improve(n3);
                SetNode<Object> subNodeNew = bitmapIndexedSetNode.mergeTwoKeyValPairs(element0, n3, element0Hash, element, originalHash, elementHash, shift + 5);
                bitmapIndexedSetNode.migrateFromInlineToNodeInPlace(n2, element0Hash, subNodeNew);
                return;
            }
            if ((bitmapIndexedSetNode.nodeMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedSetNode.nodeMap(), n, n2);
                Node subNode = bitmapIndexedSetNode.getNode(index);
                int beforeSize = ((SetNode)subNode).size();
                int beforeHashCode = subNode.cachedJavaKeySetHashCode();
                this.update((SetNode<A>)subNode, element, originalHash, elementHash, shift + 5);
                bitmapIndexedSetNode.size_$eq(bitmapIndexedSetNode.size() + (((SetNode)subNode).size() - beforeSize));
                bitmapIndexedSetNode.cachedJavaKeySetHashCode_$eq(bitmapIndexedSetNode.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHashCode));
                return;
            }
            this.insertValue(bitmapIndexedSetNode, n2, element, originalHash, elementHash);
            return;
        }
        if (setNode instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)setNode;
            int index = hashCollisionSetNode.content().indexOf(element);
            if (index < 0) {
                hashCollisionSetNode.content_$eq(hashCollisionSetNode.content().appended(element));
                return;
            }
            hashCollisionSetNode.content_$eq(hashCollisionSetNode.content().updated(index, element));
            return;
        }
        throw new MatchError(setNode);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        this.rootNode_$eq((BitmapIndexedSetNode<A>)this.scala$collection$immutable$HashSetBuilder$$rootNode().copy());
    }

    @Override
    public HashSet<A> result() {
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode().size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashSet<A>(this.scala$collection$immutable$HashSetBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    @Override
    public HashSetBuilder<A> addOne(A elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem);
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashSetBuilder$$rootNode(), elem, h, im, 0);
        return this;
    }

    @Override
    public HashSetBuilder<A> addAll(IterableOnce<A> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashSet) {
            HashSet hashSet = (HashSet)xs;
            new ChampBaseIterator<SetNode<A>>(this, hashSet){
                {
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashSetBuilder$$rootNode(), ((SetNode)this.currentValueNode()).getPayload(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }
            };
        } else {
            Iterator<A> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne((Object)it.next());
            }
        }
        return this;
    }
}

