/*
 * Decompiled with CFR 0.152.
 */
package py4j.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;
import py4j.NetworkUtil;
import py4j.Protocol;
import py4j.Py4JException;
import py4j.ReturnObject;
import py4j.commands.AbstractCommand;
import py4j.model.HelpPageGenerator;
import py4j.model.Py4JClass;
import py4j.reflection.ReflectionUtil;

public class HelpPageCommand
extends AbstractCommand {
    private final Logger logger = Logger.getLogger(HelpPageCommand.class.getName());

    public HelpPageCommand() {
        this.commandName = "h";
    }

    @Override
    public void execute(String commandName, BufferedReader reader, BufferedWriter writer) throws Py4JException, IOException {
        String returnCommand = null;
        String subCommand = NetworkUtil.safeReadLine(reader, false);
        returnCommand = subCommand.equals("o") ? this.getHelpObject(reader) : (subCommand.equals("c") ? this.getHelpClass(reader) : Protocol.getOutputErrorCommand("Unknown Help SubCommand Name: " + subCommand));
        this.logger.finest("Returning command: " + returnCommand);
        writer.write(returnCommand);
        writer.flush();
    }

    private String getHelpClass(BufferedReader reader) throws IOException {
        String returnCommand;
        String className = reader.readLine();
        String pattern = (String)Protocol.getObject(reader.readLine(), this.gateway);
        String shortName = NetworkUtil.safeReadLine(reader, false);
        reader.readLine();
        try {
            Py4JClass clazz = Py4JClass.buildClass(ReflectionUtil.classForName(className), true);
            boolean isShortName = Protocol.getBoolean(shortName);
            String helpPage = HelpPageGenerator.getHelpPage(clazz, pattern, isShortName);
            ReturnObject rObject = this.gateway.getReturnObject(helpPage);
            returnCommand = Protocol.getOutputCommand(rObject);
        }
        catch (Exception e) {
            returnCommand = Protocol.getOutputErrorCommand(e);
        }
        return returnCommand;
    }

    private String getHelpObject(BufferedReader reader) throws IOException {
        String returnCommand;
        String objectId = reader.readLine();
        String pattern = (String)Protocol.getObject(reader.readLine(), this.gateway);
        String shortName = NetworkUtil.safeReadLine(reader, false);
        reader.readLine();
        try {
            Object obj = this.gateway.getObject(objectId);
            Py4JClass clazz = Py4JClass.buildClass(obj.getClass(), true);
            boolean isShortName = Protocol.getBoolean(shortName);
            String helpPage = HelpPageGenerator.getHelpPage(clazz, pattern, isShortName);
            ReturnObject rObject = this.gateway.getReturnObject(helpPage);
            returnCommand = Protocol.getOutputCommand(rObject);
        }
        catch (Exception e) {
            returnCommand = Protocol.getOutputErrorCommand(e);
        }
        return returnCommand;
    }
}

