/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import py4j.NetworkUtil;
import py4j.Protocol;
import py4j.Py4JClientConnection;
import py4j.Py4JNetworkException;

public class CallbackConnection
implements Py4JClientConnection {
    private boolean used;
    private final int port;
    private final InetAddress address;
    private final SocketFactory socketFactory;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private final Logger logger = Logger.getLogger(CallbackConnection.class.getName());
    private final int blockingReadTimeout;
    private final int nonBlockingReadTimeout;

    public CallbackConnection(int port, InetAddress address, SocketFactory socketFactory, int readTimeout) {
        this.port = port;
        this.address = address;
        this.socketFactory = socketFactory;
        this.blockingReadTimeout = readTimeout;
        this.nonBlockingReadTimeout = readTimeout > 0 ? readTimeout : 1000;
    }

    @Override
    public String sendCommand(String command, boolean blocking) {
        this.logger.log(Level.INFO, "Sending CB command: " + command);
        String returnCommand = null;
        try {
            this.used = true;
            this.writer.write(command);
            this.writer.flush();
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Error while sending a command: null response: " + command, e, Py4JNetworkException.ErrorTime.ERROR_ON_SEND);
        }
        try {
            returnCommand = blocking ? this.readBlockingResponse(this.reader) : this.readNonBlockingResponse(this.socket, this.reader);
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Error while sending a command: " + command, e, Py4JNetworkException.ErrorTime.ERROR_ON_RECEIVE);
        }
        if (returnCommand == null) {
            throw new Py4JNetworkException("Error while sending a command: null response: " + command, Py4JNetworkException.ErrorTime.ERROR_ON_RECEIVE);
        }
        if (Protocol.isReturnMessage(returnCommand)) {
            returnCommand = returnCommand.substring(1);
        }
        this.logger.log(Level.INFO, "Returning CB command: " + returnCommand);
        return returnCommand;
    }

    protected String readBlockingResponse(BufferedReader reader) throws IOException {
        return reader.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readNonBlockingResponse(Socket socket, BufferedReader reader) throws IOException {
        String returnCommand = null;
        socket.setSoTimeout(this.nonBlockingReadTimeout);
        try {
            returnCommand = reader.readLine();
        }
        finally {
            socket.setSoTimeout(this.blockingReadTimeout);
        }
        socket.setSoTimeout(this.blockingReadTimeout);
        return returnCommand;
    }

    @Override
    public void setUsed(boolean used) {
        this.used = used;
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void shutdown(boolean reset) {
        if (reset) {
            NetworkUtil.quietlySetLinger(this.socket);
        }
        NetworkUtil.quietlyClose(this.socket);
        NetworkUtil.quietlyClose(this.reader);
        NetworkUtil.quietlyClose(this.writer);
    }

    @Override
    public void start() throws IOException {
        this.logger.info("Starting Communication Channel on " + this.address + " at " + this.port);
        this.socket = this.socketFactory.createSocket(this.address, this.port);
        this.socket.setSoTimeout(this.blockingReadTimeout);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), Charset.forName("UTF-8")));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), Charset.forName("UTF-8")));
    }

    @Override
    public boolean wasUsed() {
        return this.used;
    }
}

