#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @Time    : 2020/4/28 3:09 下午
# @File    : concrect_processor.py
# @author  : byscut
import logging
from chain_processors.frameworks.processor import Processor

logger = logging.getLogger(__name__)


class TestProcessor(Processor):
    def __init__(self, name, **kwargs):
        super(TestProcessor, self).__init__(name, **kwargs)
        for item in kwargs:
            logger.info("{} : {}".format(item, kwargs[item]))

    def process(self, inputs, context=None):
        outputs = []
        for item in inputs:
            output = item + context.get_context('udf_string', 'service')
            outputs.append(output)

        return outputs, self.name
