###############################################################################
#
#  Welcome to Baml! To use this generated code, please run the following:
#
#  $ pip install baml
#
###############################################################################

# This file was generated by BAML: please do not edit it. Instead, edit the
# BAML files and re-generate this code.
#
# ruff: noqa: E501,F401
# flake8: noqa: E501,F401
# pylint: disable=unused-import,line-too-long
# fmt: off

file_map = {
    
    "clients.baml": "// Learn more about clients at https://docs.boundaryml.com/docs/snippets/clients/overview",
    "codegen.baml": "class Attribute {\n  name string\n  value string\n}\n\nclass Element {\n  tagName string\n  textContent string?\n  attributes Attribute[]\n}\n\nclass Step {\n  step_index int\n  selector string\n  instructions string\n}\n\nenum SelectorStyle {\n  ID_BASED @description(\"Use the element's id, data-id, or name attribute\")\n  CLASS_BASED @description(\"Use the element's class attribute\")\n  PATH_BASED @description(\"Use the path between the element and its ancestors\")\n  INNER_TEXT_BASED @description(\"Use the element or its children's inner text\")\n  LABEL_BASED @description(\"Use nearby static text or label elements\")\n  SIBLING_BASED @description(\"Use the element's next or previous sibling's tag, text, or attribute\")\n  HREF_BASED @description(\"Use the element's href attribute\")\n  STYLE_BASED @description(\"Use the element's style attribute\")\n  OTHER_ATTRIBUTE_BASED @description(\"Use the element's other attributes\")\n}\n\ntemplate_string FinicAPIReference() #\"\n  class Finic:\n    \"\"\"\n    Finic class for browser automation and interaction.\n    \n    Attributes:\n        api_key (Optional[str]): API key for authentication.\n        env (Optional[FinicEnvironment]): Environment setting (LOCAL or PROD).\n        context_storage_path (Optional[str]): Path to store browser context, default is \"storage_state.json\".\n    \"\"\"\n\n    def __init__(self, api_key: Optional[str] = None, environment: Optional[FinicEnvironment] = None):\n        \"\"\"\n        Initialize a new Finic instance.\n\n        Args:\n            api_key (Optional[str]): API key for authentication. If not provided, tries to get from environment variable.\n            environment (Optional[FinicEnvironment]): Environment setting. If not provided, uses FINIC_ENV environment variable or defaults to LOCAL.\n        \"\"\"\n        # Implementation details...\n\n    def save_context(self, context: BrowserContext, path: Optional[str] = None) -> None:\n        \"\"\"\n        Save the current browser context to a file.\n\n        Args:\n            context (BrowserContext): The browser context to save.\n            path (Optional[str]): The path to save the context. If not provided, uses the default path.\n        \"\"\"\n        # Implementation omitted...\n\n    def screenshot(self, page: Union[Page, AsyncPage], selector: str, path: str) -> None:\n        \"\"\"\n        Take a screenshot of a specific element on the page.\n\n        Args:\n            page (Union[Page, AsyncPage]): The page object to screenshot.\n            selector (str): The selector for the element to screenshot.\n            path (str): The file path to save the screenshot.\n        \"\"\"\n        # Implementation omitted...\n\n    @classmethod\n    def procedure(cls, func: Callable) -> Callable:\n        \"\"\"\n        Decorator for procedure functions. Ensures the first argument is a Page object and the return value is a Page object.\n\n        Args:\n            func (Callable): The function to wrap.\n\n        Returns:\n            Callable: Wrapped function.\n        \"\"\"\n        # Implementation omitted...\n\n\"#\n\nfunction DetermineSelectorStyle(instructions: string, target: Element, next_sibling: Element?, previous_sibling: Element?, ancestors: string) -> SelectorStyle[] {\n  client \"anthropic/claude-3-5-sonnet-20240620\"\n  prompt #\"\n    Determine the best way to create an XPath selector for the provided HTML element, based on the instructions provided by the user\n    as well as its ancestors{% if next_sibling or previous_sibling %} and siblings{% endif %}. Consider whether the element's attributes are unique, whether it has a discernible label, \n    and whether the text of the element or its children can be used to uniquely identify it. Return in order of preference, from\n    most preferred to least preferred.\n\n    User Instructions: {{ instructions }}\n\n    Target Element:\n    {{ target }}\n\n    {% if next_sibling %}\n    Next Sibling:\n    {{ next_sibling }}\n    {% endif %}\n\n    {% if previous_sibling %}\n    Previous Sibling:\n    {{ previous_sibling }}\n    {% endif %}\n\n    Ancestors:\n    {{ ancestors }}\n\n    {{ ctx.output_format }}\n  \"#\n}\n\n// Generate a selector for a given HTML element.\nfunction GenerateXPathSelector(instructions: string, target: Element, ancestors: string, next_sibling: Element?, previous_sibling: Element?, selector_styles: SelectorStyle[]) -> string[] {\n  client \"anthropic/claude-3-5-sonnet-20240620\"\n  prompt #\"\n    Generate three XPath selectors based on the provided HTML tag and the user's instructions. Return them in order of confidence.\n\n    User Instructions: {{ instructions }}\n\n    Adhere to the following guidelines when determining the best XPath:\n    {% for selector_style in selector_styles %}\n    {% if selector_style == \"OTHER_ATTRIBUTE_BASED\" %}\n    - Consider the tag's attributes\n    {% elif selector_style == \"ID_BASED\" %}\n    - Consider the tag's id attribute\n    {% elif selector_style == \"CLASS_BASED\" %}\n    - Consider the tag's class attribute\n    {% elif selector_style == \"PATH_BASED\" %}\n    - Consider the path between the tag and its ancestors\n    {% elif selector_style == \"INNER_TEXT_BASED\" %}\n    - Consider the tag's inner text. Use normalize-space(string(.) || string(*)) to get the text content.\n    {% elif selector_style == \"LABEL_BASED\" %}\n    - Consider nearby static text or label elements\n    {% endif %}\n    {% if selector_style == \"HREF_BASED\" %}\n    - Consider the tag's href attribute\n    {% endif %}\n    {% if selector_style == \"STYLE_BASED\" %}\n    - Consider the tag's style attribute\n    {% endif %}\n    {% endfor %}\n\n    Target Tag:\n    {{ target }}\n\n    {% if next_sibling %}\n    Next Sibling:\n    {{ next_sibling }}\n    {% endif %}\n\n    {% if previous_sibling %}\n    Previous Sibling:\n    {{ previous_sibling }}\n    {% endif %}\n\n    {% if ancestors %}\n    Ancestors:\n    {{ ancestors }}\n    {% endif %}\n\n    {{ ctx.output_format }}\n  \"#\n}\n\nfunction GeneratePlaywrightCode(procedure_name: string, procedure_steps: Step[]) -> string {\n  client \"anthropic/claude-3-5-sonnet-20240620\"\n  prompt #\"\n    Given a list of steps for a procedure for automation actions in a web browser, \n    complete the python function below.\n\n    Procedure Steps: \n    {{ procedure_steps }}\n\n    Make sure to provide your response as a markdown code block and start your response as follows:\n    ```python\n    from playwright.sync_api import Page\n    from finic import Finic\n\n    @Finic.procedure\n    def {{ procedure_name }}(page: Page):\n\n    {{ ctx.output_format }}\n  \"#\n}",
    "copilot.baml": "class PlanningStep {\n  step_number int\n  description string\n}\n\ntemplate_string AskForElements(elements: string[]) #\"\n  Please click on the elements\n\n\n\"#\n\nfunction CreatePlan(screenshot: image, task_instructions: string, old_plan: PlanningStep[]) -> PlanningStep[] {\n  client \"anthropic/claude-3-5-sonnet-20240620\"\n  prompt #\"\n    Come up with a detailed, step by step plan for how to perform a browser-based automation task, based on a screenshot\n    of a web page and the instructions provided by the user. The plan should describe each element that needs to be interacted\n    with and the actions to be taken on each element.\n    \n    The technology stack is Python with Playwright.\n\n    Examples of steps: \n    - Expand the \"Flights\" drawer\n    - Click the \"Search\" input and enter \"Finic\"\n    - Select the \"Offline\" radio button\n    \n    Current page:\n    {{ screenshot }}\n\n    Instructions: {{ task_instructions }}\n\n    {{ ctx.output_format }}\n  \"#\n}\n\nfunction ChangePlan(screenshot: image, changes: string, old_plan: PlanningStep[]) -> PlanningStep[] {\n  client \"anthropic/claude-3-5-sonnet-20240620\"\n  prompt #\"\n    Given the current plan and proposed changes, come up with a revised plan for how to perform a browser-based automation task.\n\n    Current page:\n    {{ screenshot }}\n\n    Current plan:\n    {% for step in old_plan %}\n    {{ step.step_number }}. {{ step.description }}\n    {% endfor %}\n\n    Proposed changes: {{ changes }}\n\n    {{ ctx.output_format }}\n  \"#\n}\n\nfunction ElementsPerStep(plan: string, current_step: PlanningStep) -> string[] {\n  client \"anthropic/claude-3-5-sonnet-20240620\"\n  prompt #\"\n    Given the current plan and the step we're on, return a list of elements visible on the page for which we'll need selectors in order to perform the step.\n    You do not know the HTML structure of the page yet, so elements should be returned as a list of string descriptions for the user so they can identify them.\n\n    Examples of of outputs:\n    - \"Flights\" drawer\n    - \"Search\" input\n    - \"Offline\" radio button\n    - Text component containing flight details\n\n    Current plan:\n    {{ plan }}\n\n    Current step:\n    {{ current_step }}\n\n    {{ ctx.output_format }}\n  \"#\n}",
    "generators.baml": "// This helps use auto generate libraries you can use in the language of\n// your choice. You can have multiple generators if you use multiple languages.\n// Just ensure that the output_dir is different for each generator.\ngenerator target {\n    // Valid values: \"python/pydantic\", \"typescript\", \"ruby/sorbet\", \"rest/openapi\"\n    output_type \"python/pydantic\"\n\n    // Where the generated code will be saved (relative to baml_src/)\n    output_dir \"../\"\n\n    // The version of the BAML package you have installed (e.g. same version as your baml-py or @boundaryml/baml).\n    // The BAML VSCode extension version should also match this version.\n    version \"0.58.0\"\n\n    // Valid values: \"sync\", \"async\"\n    // This controls what `b.FunctionName()` will be (sync or async).\n    default_client_mode sync\n}\n",
}

def get_baml_files():
    return file_map