# mapwidget

[![image](https://img.shields.io/pypi/v/mapwidget.svg)](https://pypi.python.org/pypi/mapwidget)
[![image](https://img.shields.io/conda/vn/conda-forge/mapwidget.svg)](https://anaconda.org/conda-forge/mapwidget)

**Custom map widgets for creating interactive maps**

The **mapwidget** package provides a set of custom map widgets for creating interactive maps in a Jupyter environment using different JavaScript mapping libraries, such as [Cesium](https://cesium.com/), [Leaflet](https://leafletjs.com/), [Mapbox](https://www.mapbox.com/), [MapLibre](https://maplibre.org/), and [OpenLayers](https://openlayers.org/). The widgets are built on top of the [anywidget](https://github.com/manzt/anywidget) Python package.

-   Free software: MIT license
-   Documentation: https://mapwidget.gishub.org

## Examples

-   [Cesium](https://mapwidget.gishub.org/examples/cesium)
-   [Leaflet](https://mapwidget.gishub.org/examples/leaflet)
-   [Mapbox](https://mapwidget.gishub.org/examples/mapbox)
-   [MapLibre](https://mapwidget.gishub.org/examples/maplibre)
-   [OpenLayers](https://mapwidget.gishub.org/examples/openlayers)-

## Demos

### Cesium

![](https://i.imgur.com/6quoDtN.gif)

### Mapbox

![](https://i.imgur.com/4uIEnAJ.gif)

### MapLibre

![](https://i.imgur.com/o2ZHeTL.gif)

## Credits

This package was created with [Cookiecutter](https://github.com/cookiecutter/cookiecutter) and the [giswqs/pypackage](https://github.com/giswqs/pypackage) project template.
