# coding: utf-8

"""
    Network Storage API

    Create, list, edit, and delete storage networks with the Network Storage API. Use storage networks to expand storage capacity on a private network. <br> <span class='pnap-api-knowledge-base-link'> Knowledge base articles to help you can be found <a href='https://phoenixnap.com/kb/bare-metal-cloud-storage' target='_blank'>here</a> </span> <br> <b>All URLs are relative to (https://api.phoenixnap.com/network-storage/v1/)</b> 

    The version of the OpenAPI document: 1.0
    Contact: support@phoenixnap.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from pnap_network_storage_api.models.permissions import Permissions
from pnap_network_storage_api.models.status import Status
from pnap_network_storage_api.models.tag_assignment import TagAssignment
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Volume(BaseModel):
    """
    Volume for a storage network.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Volume ID.")
    name: Optional[StrictStr] = Field(default=None, description="Volume friendly name.")
    description: Optional[StrictStr] = Field(default=None, description="Volume description.")
    path: Optional[StrictStr] = Field(default=None, description="Volume's full path. It is in form of `/{volumeId}/pathSuffix`'.")
    path_suffix: Optional[StrictStr] = Field(default=None, description="Last part of volume's path.", alias="pathSuffix")
    capacity_in_gb: Optional[StrictInt] = Field(default=None, description="Maximum capacity in GB.", alias="capacityInGb")
    used_capacity_in_gb: Optional[StrictInt] = Field(default=None, description="Used capacity in GB, updated periodically.", alias="usedCapacityInGb")
    protocol: Optional[StrictStr] = Field(default=None, description="File system protocol. Currently this field should be set to `NFS`.")
    status: Optional[Status] = None
    created_on: Optional[datetime] = Field(default=None, alias="createdOn")
    delete_requested_on: Optional[datetime] = Field(default=None, description="Date and time of the initial request for volume deletion.", alias="deleteRequestedOn")
    permissions: Optional[Permissions] = None
    tags: Optional[List[TagAssignment]] = Field(default=None, description="The tags assigned if any.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "description", "path", "pathSuffix", "capacityInGb", "usedCapacityInGb", "protocol", "status", "createdOn", "deleteRequestedOn", "permissions", "tags"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Volume from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
                "additional_properties",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Volume from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "path": obj.get("path"),
            "pathSuffix": obj.get("pathSuffix"),
            "capacityInGb": obj.get("capacityInGb"),
            "usedCapacityInGb": obj.get("usedCapacityInGb"),
            "protocol": obj.get("protocol"),
            "status": obj.get("status"),
            "createdOn": obj.get("createdOn"),
            "deleteRequestedOn": obj.get("deleteRequestedOn"),
            "permissions": Permissions.from_dict(obj.get("permissions")) if obj.get("permissions") is not None else None,
            "tags": [TagAssignment.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


