# pnap-network-storage-api
Create, list, edit, and delete storage networks with the Network Storage API. Use storage networks to expand storage capacity on a private network.
<br>
<span class='pnap-api-knowledge-base-link'>
Knowledge base articles to help you can be found
<a href='https://phoenixnap.com/kb/bare-metal-cloud-storage' target='_blank'>here</a>
</span>
<br>
<b>All URLs are relative to (https://api.phoenixnap.com/network-storage/v1/)</b>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 2.0.2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://phoenixnap.com/](https://phoenixnap.com/)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

You can install this package directly from the [Python Package Index](https://pypi.org/) using:

```sh
$ pip install pnap_network_storage_api
```

Then import the package:
```python
import pnap_network_storage_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pnap_network_storage_api
```

```python

import time
import pnap_network_storage_api
from pnap_network_storage_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.phoenixnap.com/network-storage/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = pnap_network_storage_api.Configuration(
    host = "https://api.phoenixnap.com/network-storage/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
with pnap_network_storage_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pnap_network_storage_api.StorageNetworksApi(api_client)
    location = 'PHX' # str | If present will filter the result by the given location. (optional)

    try:
        # List all storage networks.
        api_response = api_instance.storage_networks_get(location=location)
        print("The response of StorageNetworksApi->storage_networks_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling StorageNetworksApi->storage_networks_get: %s\n" % e)

```

To generate a token using the [python-keycloak](https://pypi.org/project/python-keycloak/) library:
```python
from keycloak import KeycloakOpenID

clientId = "YOUR_CLIENT_ID"
clientSecret = "YOUR_CLIENT_SECRET"
serverUrl = "https://auth.phoenixnap.com/auth/"
realmName = "BMC"
grantType = "client_credentials"

keycloakOpenId =  KeycloakOpenID(server_url=serverUrl,
                        realm_name=realmName,
                        client_id=clientId,
                        client_secret_key=clientSecret)

ACCESS_TOKEN = keycloakOpenId.token(grant_type=grantType)['access_token']


## Documentation for API Endpoints

All URIs are relative to *https://api.phoenixnap.com/network-storage/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*StorageNetworksApi* | [**storage_networks_get**](docs/StorageNetworksApi.md#storage_networks_get) | **GET** /storage-networks | List all storage networks.
*StorageNetworksApi* | [**storage_networks_id_delete**](docs/StorageNetworksApi.md#storage_networks_id_delete) | **DELETE** /storage-networks/{storageId} | Delete a storage network and its volume.
*StorageNetworksApi* | [**storage_networks_id_get**](docs/StorageNetworksApi.md#storage_networks_id_get) | **GET** /storage-networks/{storageId} | Get storage network details.
*StorageNetworksApi* | [**storage_networks_id_patch**](docs/StorageNetworksApi.md#storage_networks_id_patch) | **PATCH** /storage-networks/{storageId} | Update storage network details.
*StorageNetworksApi* | [**storage_networks_post**](docs/StorageNetworksApi.md#storage_networks_post) | **POST** /storage-networks | Create a storage network and volume.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_get**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_get) | **GET** /storage-networks/{storageId}/volumes | Display one or more volumes belonging to a storage network.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_post**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_post) | **POST** /storage-networks/{storageId}/volumes | Create a volume belonging to a storage network.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_volume_id_delete**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_volume_id_delete) | **DELETE** /storage-networks/{storageId}/volumes/{volumeId} | Delete a Storage Network&#39;s Volume
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_volume_id_get**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_volume_id_get) | **GET** /storage-networks/{storageId}/volumes/{volumeId} | Get a storage network&#39;s volume details.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_volume_id_patch**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_volume_id_patch) | **PATCH** /storage-networks/{storageId}/volumes/{volumeId} | Update a storage network&#39;s volume details.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_volume_id_tags_put**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_volume_id_tags_put) | **PUT** /storage-networks/{storageId}/volumes/{volumeId}/tags | Overwrites tags assigned for the volume.


## Documentation For Models

 - [Error](docs/Error.md)
 - [NfsPermissions](docs/NfsPermissions.md)
 - [NfsPermissionsCreate](docs/NfsPermissionsCreate.md)
 - [NfsPermissionsUpdate](docs/NfsPermissionsUpdate.md)
 - [Permissions](docs/Permissions.md)
 - [PermissionsCreate](docs/PermissionsCreate.md)
 - [PermissionsUpdate](docs/PermissionsUpdate.md)
 - [Status](docs/Status.md)
 - [StorageNetwork](docs/StorageNetwork.md)
 - [StorageNetworkCreate](docs/StorageNetworkCreate.md)
 - [StorageNetworkUpdate](docs/StorageNetworkUpdate.md)
 - [StorageNetworkVolumeCreate](docs/StorageNetworkVolumeCreate.md)
 - [TagAssignment](docs/TagAssignment.md)
 - [TagAssignmentRequest](docs/TagAssignmentRequest.md)
 - [Volume](docs/Volume.md)
 - [VolumeCreate](docs/VolumeCreate.md)
 - [VolumeUpdate](docs/VolumeUpdate.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2"></a>
### OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **networkstorage**: Grants full access to Network Storage API.
 - **networkstorage.read**: Grants read only access to Network Storage API.


## Author

support@phoenixnap.com

