# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class StreetAddress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        StreetAddress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'country': 'str',
            'a1': 'str',
            'a3': 'str',
            'rd': 'str',
            'hno': 'str',
            'loc': 'str',
            'nam': 'str',
            'pc': 'str'
        }

        self.attribute_map = {
            'country': 'country',
            'a1': 'A1',
            'a3': 'A3',
            'rd': 'RD',
            'hno': 'HNO',
            'loc': 'LOC',
            'nam': 'NAM',
            'pc': 'PC'
        }

        self._country = None
        self._a1 = None
        self._a3 = None
        self._rd = None
        self._hno = None
        self._loc = None
        self._nam = None
        self._pc = None

    @property
    def country(self):
        """
        Gets the country of this StreetAddress.
        2 Letter Country code, like US or GB

        :return: The country of this StreetAddress.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this StreetAddress.
        2 Letter Country code, like US or GB

        :param country: The country of this StreetAddress.
        :type: str
        """
        
        self._country = country

    @property
    def a1(self):
        """
        Gets the a1 of this StreetAddress.
        State or Province

        :return: The a1 of this StreetAddress.
        :rtype: str
        """
        return self._a1

    @a1.setter
    def a1(self, a1):
        """
        Sets the a1 of this StreetAddress.
        State or Province

        :param a1: The a1 of this StreetAddress.
        :type: str
        """
        
        self._a1 = a1

    @property
    def a3(self):
        """
        Gets the a3 of this StreetAddress.
        City or township

        :return: The a3 of this StreetAddress.
        :rtype: str
        """
        return self._a3

    @a3.setter
    def a3(self, a3):
        """
        Sets the a3 of this StreetAddress.
        City or township

        :param a3: The a3 of this StreetAddress.
        :type: str
        """
        
        self._a3 = a3

    @property
    def rd(self):
        """
        Gets the rd of this StreetAddress.
        Number and street

        :return: The rd of this StreetAddress.
        :rtype: str
        """
        return self._rd

    @rd.setter
    def rd(self, rd):
        """
        Sets the rd of this StreetAddress.
        Number and street

        :param rd: The rd of this StreetAddress.
        :type: str
        """
        
        self._rd = rd

    @property
    def hno(self):
        """
        Gets the hno of this StreetAddress.
        House Number

        :return: The hno of this StreetAddress.
        :rtype: str
        """
        return self._hno

    @hno.setter
    def hno(self, hno):
        """
        Sets the hno of this StreetAddress.
        House Number

        :param hno: The hno of this StreetAddress.
        :type: str
        """
        
        self._hno = hno

    @property
    def loc(self):
        """
        Gets the loc of this StreetAddress.
        extra location info like suite 300

        :return: The loc of this StreetAddress.
        :rtype: str
        """
        return self._loc

    @loc.setter
    def loc(self, loc):
        """
        Sets the loc of this StreetAddress.
        extra location info like suite 300

        :param loc: The loc of this StreetAddress.
        :type: str
        """
        
        self._loc = loc

    @property
    def nam(self):
        """
        Gets the nam of this StreetAddress.
        Name of the customer

        :return: The nam of this StreetAddress.
        :rtype: str
        """
        return self._nam

    @nam.setter
    def nam(self, nam):
        """
        Sets the nam of this StreetAddress.
        Name of the customer

        :param nam: The nam of this StreetAddress.
        :type: str
        """
        
        self._nam = nam

    @property
    def pc(self):
        """
        Gets the pc of this StreetAddress.
        Postal code

        :return: The pc of this StreetAddress.
        :rtype: str
        """
        return self._pc

    @pc.setter
    def pc(self, pc):
        """
        Sets the pc of this StreetAddress.
        Postal code

        :param pc: The pc of this StreetAddress.
        :type: str
        """
        
        self._pc = pc

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

