# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SchemaQuantityLimits(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SchemaQuantityLimits - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'min_field_name_characters': 'int',
            'max_field_name_characters': 'int',
            'min_field_description_characters': 'int',
            'max_field_description_characters': 'int',
            'min_schema_name_characters': 'int',
            'max_schema_name_characters': 'int',
            'min_schema_description_characters': 'int',
            'max_schema_description_characters': 'int',
            'max_number_of_schemas_per_org': 'int',
            'max_number_of_fields_per_schema': 'int',
            'max_number_of_fields_per_org': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'min_field_name_characters': 'minFieldNameCharacters',
            'max_field_name_characters': 'maxFieldNameCharacters',
            'min_field_description_characters': 'minFieldDescriptionCharacters',
            'max_field_description_characters': 'maxFieldDescriptionCharacters',
            'min_schema_name_characters': 'minSchemaNameCharacters',
            'max_schema_name_characters': 'maxSchemaNameCharacters',
            'min_schema_description_characters': 'minSchemaDescriptionCharacters',
            'max_schema_description_characters': 'maxSchemaDescriptionCharacters',
            'max_number_of_schemas_per_org': 'maxNumberOfSchemasPerOrg',
            'max_number_of_fields_per_schema': 'maxNumberOfFieldsPerSchema',
            'max_number_of_fields_per_org': 'maxNumberOfFieldsPerOrg',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._min_field_name_characters = None
        self._max_field_name_characters = None
        self._min_field_description_characters = None
        self._max_field_description_characters = None
        self._min_schema_name_characters = None
        self._max_schema_name_characters = None
        self._min_schema_description_characters = None
        self._max_schema_description_characters = None
        self._max_number_of_schemas_per_org = None
        self._max_number_of_fields_per_schema = None
        self._max_number_of_fields_per_org = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this SchemaQuantityLimits.
        The globally unique identifier for the object.

        :return: The id of this SchemaQuantityLimits.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SchemaQuantityLimits.
        The globally unique identifier for the object.

        :param id: The id of this SchemaQuantityLimits.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this SchemaQuantityLimits.


        :return: The name of this SchemaQuantityLimits.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SchemaQuantityLimits.


        :param name: The name of this SchemaQuantityLimits.
        :type: str
        """
        
        self._name = name

    @property
    def min_field_name_characters(self):
        """
        Gets the min_field_name_characters of this SchemaQuantityLimits.
        The minimum number of schema field name characters allowed.

        :return: The min_field_name_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._min_field_name_characters

    @min_field_name_characters.setter
    def min_field_name_characters(self, min_field_name_characters):
        """
        Sets the min_field_name_characters of this SchemaQuantityLimits.
        The minimum number of schema field name characters allowed.

        :param min_field_name_characters: The min_field_name_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._min_field_name_characters = min_field_name_characters

    @property
    def max_field_name_characters(self):
        """
        Gets the max_field_name_characters of this SchemaQuantityLimits.
        The maximum number of schema field name characters allowed.

        :return: The max_field_name_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._max_field_name_characters

    @max_field_name_characters.setter
    def max_field_name_characters(self, max_field_name_characters):
        """
        Sets the max_field_name_characters of this SchemaQuantityLimits.
        The maximum number of schema field name characters allowed.

        :param max_field_name_characters: The max_field_name_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._max_field_name_characters = max_field_name_characters

    @property
    def min_field_description_characters(self):
        """
        Gets the min_field_description_characters of this SchemaQuantityLimits.
        The minimum number of schema field description characters allowed.

        :return: The min_field_description_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._min_field_description_characters

    @min_field_description_characters.setter
    def min_field_description_characters(self, min_field_description_characters):
        """
        Sets the min_field_description_characters of this SchemaQuantityLimits.
        The minimum number of schema field description characters allowed.

        :param min_field_description_characters: The min_field_description_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._min_field_description_characters = min_field_description_characters

    @property
    def max_field_description_characters(self):
        """
        Gets the max_field_description_characters of this SchemaQuantityLimits.
        The maximum number of schema field description characters allowed.

        :return: The max_field_description_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._max_field_description_characters

    @max_field_description_characters.setter
    def max_field_description_characters(self, max_field_description_characters):
        """
        Sets the max_field_description_characters of this SchemaQuantityLimits.
        The maximum number of schema field description characters allowed.

        :param max_field_description_characters: The max_field_description_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._max_field_description_characters = max_field_description_characters

    @property
    def min_schema_name_characters(self):
        """
        Gets the min_schema_name_characters of this SchemaQuantityLimits.
        The minimum number of schema name characters allowed.

        :return: The min_schema_name_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._min_schema_name_characters

    @min_schema_name_characters.setter
    def min_schema_name_characters(self, min_schema_name_characters):
        """
        Sets the min_schema_name_characters of this SchemaQuantityLimits.
        The minimum number of schema name characters allowed.

        :param min_schema_name_characters: The min_schema_name_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._min_schema_name_characters = min_schema_name_characters

    @property
    def max_schema_name_characters(self):
        """
        Gets the max_schema_name_characters of this SchemaQuantityLimits.
        The maximum number of schema name characters allowed.

        :return: The max_schema_name_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._max_schema_name_characters

    @max_schema_name_characters.setter
    def max_schema_name_characters(self, max_schema_name_characters):
        """
        Sets the max_schema_name_characters of this SchemaQuantityLimits.
        The maximum number of schema name characters allowed.

        :param max_schema_name_characters: The max_schema_name_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._max_schema_name_characters = max_schema_name_characters

    @property
    def min_schema_description_characters(self):
        """
        Gets the min_schema_description_characters of this SchemaQuantityLimits.
        The minimum number of schema description characters allowed.

        :return: The min_schema_description_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._min_schema_description_characters

    @min_schema_description_characters.setter
    def min_schema_description_characters(self, min_schema_description_characters):
        """
        Sets the min_schema_description_characters of this SchemaQuantityLimits.
        The minimum number of schema description characters allowed.

        :param min_schema_description_characters: The min_schema_description_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._min_schema_description_characters = min_schema_description_characters

    @property
    def max_schema_description_characters(self):
        """
        Gets the max_schema_description_characters of this SchemaQuantityLimits.
        The maximum number of schema description characters allowed.

        :return: The max_schema_description_characters of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._max_schema_description_characters

    @max_schema_description_characters.setter
    def max_schema_description_characters(self, max_schema_description_characters):
        """
        Sets the max_schema_description_characters of this SchemaQuantityLimits.
        The maximum number of schema description characters allowed.

        :param max_schema_description_characters: The max_schema_description_characters of this SchemaQuantityLimits.
        :type: int
        """
        
        self._max_schema_description_characters = max_schema_description_characters

    @property
    def max_number_of_schemas_per_org(self):
        """
        Gets the max_number_of_schemas_per_org of this SchemaQuantityLimits.
        The maximum number of schema allowed per org.

        :return: The max_number_of_schemas_per_org of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._max_number_of_schemas_per_org

    @max_number_of_schemas_per_org.setter
    def max_number_of_schemas_per_org(self, max_number_of_schemas_per_org):
        """
        Sets the max_number_of_schemas_per_org of this SchemaQuantityLimits.
        The maximum number of schema allowed per org.

        :param max_number_of_schemas_per_org: The max_number_of_schemas_per_org of this SchemaQuantityLimits.
        :type: int
        """
        
        self._max_number_of_schemas_per_org = max_number_of_schemas_per_org

    @property
    def max_number_of_fields_per_schema(self):
        """
        Gets the max_number_of_fields_per_schema of this SchemaQuantityLimits.
        The maximum number of schema fields allowed per schema.

        :return: The max_number_of_fields_per_schema of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._max_number_of_fields_per_schema

    @max_number_of_fields_per_schema.setter
    def max_number_of_fields_per_schema(self, max_number_of_fields_per_schema):
        """
        Sets the max_number_of_fields_per_schema of this SchemaQuantityLimits.
        The maximum number of schema fields allowed per schema.

        :param max_number_of_fields_per_schema: The max_number_of_fields_per_schema of this SchemaQuantityLimits.
        :type: int
        """
        
        self._max_number_of_fields_per_schema = max_number_of_fields_per_schema

    @property
    def max_number_of_fields_per_org(self):
        """
        Gets the max_number_of_fields_per_org of this SchemaQuantityLimits.
        The maximum number of schema fields allowed per organization across all of their schemas.

        :return: The max_number_of_fields_per_org of this SchemaQuantityLimits.
        :rtype: int
        """
        return self._max_number_of_fields_per_org

    @max_number_of_fields_per_org.setter
    def max_number_of_fields_per_org(self, max_number_of_fields_per_org):
        """
        Sets the max_number_of_fields_per_org of this SchemaQuantityLimits.
        The maximum number of schema fields allowed per organization across all of their schemas.

        :param max_number_of_fields_per_org: The max_number_of_fields_per_org of this SchemaQuantityLimits.
        :type: int
        """
        
        self._max_number_of_fields_per_org = max_number_of_fields_per_org

    @property
    def self_uri(self):
        """
        Gets the self_uri of this SchemaQuantityLimits.
        The URI for this object

        :return: The self_uri of this SchemaQuantityLimits.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this SchemaQuantityLimits.
        The URI for this object

        :param self_uri: The self_uri of this SchemaQuantityLimits.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

