# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KpiResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KpiResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'kpi_total_on': 'int',
            'kpi_total_off': 'int',
            'interaction_count_on': 'int',
            'interaction_count_off': 'int',
            'media_type': 'str'
        }

        self.attribute_map = {
            'kpi_total_on': 'kpiTotalOn',
            'kpi_total_off': 'kpiTotalOff',
            'interaction_count_on': 'interactionCountOn',
            'interaction_count_off': 'interactionCountOff',
            'media_type': 'mediaType'
        }

        self._kpi_total_on = None
        self._kpi_total_off = None
        self._interaction_count_on = None
        self._interaction_count_off = None
        self._media_type = None

    @property
    def kpi_total_on(self):
        """
        Gets the kpi_total_on of this KpiResult.
        Absolute metric (in which the KPI is based) total for the interactions handled by predictive routing (GPR was on)

        :return: The kpi_total_on of this KpiResult.
        :rtype: int
        """
        return self._kpi_total_on

    @kpi_total_on.setter
    def kpi_total_on(self, kpi_total_on):
        """
        Sets the kpi_total_on of this KpiResult.
        Absolute metric (in which the KPI is based) total for the interactions handled by predictive routing (GPR was on)

        :param kpi_total_on: The kpi_total_on of this KpiResult.
        :type: int
        """
        
        self._kpi_total_on = kpi_total_on

    @property
    def kpi_total_off(self):
        """
        Gets the kpi_total_off of this KpiResult.
        Absolute metric (in which the KPI is based) total for the interactions not routed by predictive routing (GPR was off)

        :return: The kpi_total_off of this KpiResult.
        :rtype: int
        """
        return self._kpi_total_off

    @kpi_total_off.setter
    def kpi_total_off(self, kpi_total_off):
        """
        Sets the kpi_total_off of this KpiResult.
        Absolute metric (in which the KPI is based) total for the interactions not routed by predictive routing (GPR was off)

        :param kpi_total_off: The kpi_total_off of this KpiResult.
        :type: int
        """
        
        self._kpi_total_off = kpi_total_off

    @property
    def interaction_count_on(self):
        """
        Gets the interaction_count_on of this KpiResult.
        Total interactions handled by predictive routing (GPR was on)

        :return: The interaction_count_on of this KpiResult.
        :rtype: int
        """
        return self._interaction_count_on

    @interaction_count_on.setter
    def interaction_count_on(self, interaction_count_on):
        """
        Sets the interaction_count_on of this KpiResult.
        Total interactions handled by predictive routing (GPR was on)

        :param interaction_count_on: The interaction_count_on of this KpiResult.
        :type: int
        """
        
        self._interaction_count_on = interaction_count_on

    @property
    def interaction_count_off(self):
        """
        Gets the interaction_count_off of this KpiResult.
        Total interactions not routed by predictive routing (GPR was off)

        :return: The interaction_count_off of this KpiResult.
        :rtype: int
        """
        return self._interaction_count_off

    @interaction_count_off.setter
    def interaction_count_off(self, interaction_count_off):
        """
        Sets the interaction_count_off of this KpiResult.
        Total interactions not routed by predictive routing (GPR was off)

        :param interaction_count_off: The interaction_count_off of this KpiResult.
        :type: int
        """
        
        self._interaction_count_off = interaction_count_off

    @property
    def media_type(self):
        """
        Gets the media_type of this KpiResult.
        Media type used for the KPI

        :return: The media_type of this KpiResult.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type):
        """
        Sets the media_type of this KpiResult.
        Media type used for the KPI

        :param media_type: The media_type of this KpiResult.
        :type: str
        """
        allowed_values = ["voice", "email", "message"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

