# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DialerRulesetConfigChangeContactColumnToDataActionFieldMapping(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DialerRulesetConfigChangeContactColumnToDataActionFieldMapping - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'contact_column_name': 'str',
            'data_action_field': 'str'
        }

        self.attribute_map = {
            'contact_column_name': 'contactColumnName',
            'data_action_field': 'dataActionField'
        }

        self._contact_column_name = None
        self._data_action_field = None

    @property
    def contact_column_name(self):
        """
        Gets the contact_column_name of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        The name of a contact column whose data will be passed to the data action

        :return: The contact_column_name of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        :rtype: str
        """
        return self._contact_column_name

    @contact_column_name.setter
    def contact_column_name(self, contact_column_name):
        """
        Sets the contact_column_name of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        The name of a contact column whose data will be passed to the data action

        :param contact_column_name: The contact_column_name of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        :type: str
        """
        
        self._contact_column_name = contact_column_name

    @property
    def data_action_field(self):
        """
        Gets the data_action_field of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        The name of an output field from the data action that the contact column data will be passed to

        :return: The data_action_field of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        :rtype: str
        """
        return self._data_action_field

    @data_action_field.setter
    def data_action_field(self, data_action_field):
        """
        Sets the data_action_field of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        The name of an output field from the data action that the contact column data will be passed to

        :param data_action_field: The data_action_field of this DialerRulesetConfigChangeContactColumnToDataActionFieldMapping.
        :type: str
        """
        
        self._data_action_field = data_action_field

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

