# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/utils.ipynb (unless otherwise specified).

__all__ = ['view', 'bytes_encode', 'bytes_decode', 'timer_start', 'timer_stop', 'to_bytesio', 'cprint']

# Cell
from ppretty import ppretty
from colorama import Fore as C,Style
from fastai2.vision.all import *
import base64,time

# Cell
def view(obj, depth=1, indent='  ', width=100, seq_length=1000,show_protected=False,
             show_private=True, show_static=True, show_properties=True, show_address=False, str_length=1000):
    "Print everything that belongs to an object"
    print(ppretty(obj, depth=depth,indent=indent,width=width,seq_length=seq_length,
                  show_protected=show_protected,show_private=show_private,show_static=show_static,
                  show_properties=show_properties,show_address=show_address, str_length=str_length))

# Cell
def bytes_encode(bites):
    "Encode bytes to base64 string"
    return base64.b64encode(bites).decode('utf-8')

def bytes_decode(encoded):
    "Decode base64 string to bytes"
    return base64.b64decode(encoded)

# Cell
def timer_start(label='timer'):
    "Start for timer. Place above start of code you want to time"
    print(f'[START] {label.upper()}')
    return time.perf_counter()

def timer_stop(start,label='timer'):
    "End for timer. Place below end of code you want to time. Prints execution time of surrounded code"
    #print(f'[END {label.upper()}', f'{float(time.perf_counter()-start):.2f} secs'+']')
    print(f'[END] {label.upper()}', f'{float(time.perf_counter()-start):.2f} secs')

# Cell
def to_bytesio(bites):
    "Convert bytes to io.BytesIO"
    return io.BytesIO(bites)

# Cell
def cprint(s1,s2=None,c1=C.CYAN,c2=C.CYAN,c0=C.CYAN):
  "Print in color of c1"
  if s2 and c2:
    print(c0+f'{"-"*14}'+Style.RESET_ALL,
          c1+f'{"-"*14} {s1.upper()}'+Style.RESET_ALL,
          c2+f'{s2}'+Style.RESET_ALL)
  else:
    print(C.CYAN+f'{"-"*14}'+Style.RESET_ALL,
          c1+f'{"-"*14} {s1}'+Style.RESET_ALL)