import argparse

from pls.enums.icon_type import IconType


def add_args(parser: argparse.ArgumentParser):
    """
    Add arguments for presentation to the given parser.

    :param parser: the parser to which to add the arguments
    """

    presentation = parser.add_argument_group(
        title="presentation",
        description="arguments for controlling the presentation of nodes",
    )
    presentation.add_argument(
        *["-i", "--icon"],
        metavar="TYPE",
        type=IconType,
        choices=list(IconType),
        help="the type of icons to show with the files",
    )
    presentation.add_argument(
        "--no-align",
        dest="align",
        action="store_false",
        default=None,  # ``store_false`` sets default value to ``True``
        help="align file names, including leading dots",
    )
    presentation.add_argument(
        *["-c", "--collapse"],
        action="count",
        help="collapse autogenerated files behind their sources",
    )
