/*
 * Decompiled with CFR 0.152.
 */
package protostream.javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import protostream.javassist.bytecode.AttributeInfo;
import protostream.javassist.bytecode.ByteArray;
import protostream.javassist.bytecode.ConstPool;

public class BootstrapMethodsAttribute
extends AttributeInfo {
    public static final String tag = "BootstrapMethods";

    BootstrapMethodsAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public BootstrapMethodsAttribute(ConstPool cp, BootstrapMethod[] methods) {
        super(cp, tag);
        int size = 2;
        for (int i = 0; i < methods.length; ++i) {
            size += 4 + methods[i].arguments.length * 2;
        }
        byte[] data = new byte[size];
        ByteArray.write16bit(methods.length, data, 0);
        int pos = 2;
        for (int i = 0; i < methods.length; ++i) {
            ByteArray.write16bit(methods[i].methodRef, data, pos);
            ByteArray.write16bit(methods[i].arguments.length, data, pos + 2);
            int[] args2 = methods[i].arguments;
            pos += 4;
            for (int k = 0; k < args2.length; ++k) {
                ByteArray.write16bit(args2[k], data, pos);
                pos += 2;
            }
        }
        this.set(data);
    }

    public BootstrapMethod[] getMethods() {
        byte[] data = this.get();
        int num = ByteArray.readU16bit(data, 0);
        BootstrapMethod[] methods = new BootstrapMethod[num];
        int pos = 2;
        for (int i = 0; i < num; ++i) {
            int ref = ByteArray.readU16bit(data, pos);
            int len = ByteArray.readU16bit(data, pos + 2);
            int[] args2 = new int[len];
            pos += 4;
            for (int k = 0; k < len; ++k) {
                args2[k] = ByteArray.readU16bit(data, pos);
                pos += 2;
            }
            methods[i] = new BootstrapMethod(ref, args2);
        }
        return methods;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        BootstrapMethod[] methods = this.getMethods();
        ConstPool thisCp = this.getConstPool();
        for (int i = 0; i < methods.length; ++i) {
            BootstrapMethod m3 = methods[i];
            m3.methodRef = thisCp.copy(m3.methodRef, newCp, classnames);
            for (int k = 0; k < m3.arguments.length; ++k) {
                m3.arguments[k] = thisCp.copy(m3.arguments[k], newCp, classnames);
            }
        }
        return new BootstrapMethodsAttribute(newCp, methods);
    }

    public static class BootstrapMethod {
        public int methodRef;
        public int[] arguments;

        public BootstrapMethod(int method, int[] args2) {
            this.methodRef = method;
            this.arguments = args2;
        }
    }
}

