/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.AverageMinMax;

public class Profiler
implements DiagnosticsHandler.ProbeHandler {
    protected final AverageMinMax avg = new AverageMinMax();
    protected final String name;
    protected final TimeUnit unit;

    public Profiler(String name, TimeUnit unit) {
        this.name = name;
        this.unit = unit;
    }

    public Profiler add(long time) {
        this.avg.add(time);
        return this;
    }

    public long min() {
        return this.avg.min();
    }

    public long max() {
        return this.avg.max();
    }

    public double average() {
        return this.avg.average();
    }

    public long count() {
        return this.avg.count();
    }

    public Profiler clear() {
        this.avg.clear();
        return this;
    }

    public String toString() {
        return String.format("min/avg/max %s = %d / %.2f / %d", Profiler.toString(this.unit), this.avg.min(), this.avg.average(), this.avg.max());
    }

    @Override
    public Map<String, String> handleProbe(String ... keys2) {
        HashMap<String, String> map = null;
        for (String key : keys2) {
            if (Objects.equals(key, this.name + ".reset")) {
                this.avg.clear();
                continue;
            }
            if (!Objects.equals(key, this.name)) continue;
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(this.name, String.format("cnt: min/avg/max = %d: %d / %.2f / %d %s", this.avg.count(), this.avg.min(), this.avg.average(), this.avg.max(), Profiler.toString(this.unit)));
        }
        return map;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{this.name, this.name + ".reset"};
    }

    protected static String toString(TimeUnit unit) {
        switch (unit) {
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "us";
            }
            case NANOSECONDS: {
                return "ns";
            }
        }
        return unit.toString();
    }
}

