/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.fork;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.fork.ForkProtocolStack;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class ForkChannel
extends JChannel
implements ChannelListener {
    protected final JChannel main_channel;
    protected final String fork_channel_id;
    protected static final Field[] copied_fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForkChannel(JChannel main_channel, String fork_stack_id, String fork_channel_id, boolean create_fork_if_absent, ProtocolStack.Position position, Class<? extends Protocol> neighbor, Protocol ... protocols) throws Exception {
        super(false);
        FORK fork;
        if (main_channel == null) {
            throw new IllegalArgumentException("main channel cannot be null");
        }
        if (fork_stack_id == null) {
            throw new IllegalArgumentException("fork_stack_id cannot be null");
        }
        if (fork_channel_id == null) {
            throw new IllegalArgumentException("fork_channel_id cannot be null");
        }
        this.main_channel = main_channel;
        this.fork_channel_id = fork_channel_id;
        JChannel jChannel = this.main_channel;
        synchronized (jChannel) {
            fork = ForkChannel.getFORK(main_channel, position, neighbor, create_fork_if_absent);
        }
        this.prot_stack = fork.createForkStack(fork_stack_id, protocols == null ? null : Arrays.asList(protocols), true);
        this.flush_supported = main_channel.flushSupported();
        this.state = JChannel.State.OPEN;
    }

    public ForkChannel(JChannel main_channel, String fork_stack_id, String fork_channel_id, Protocol ... protocols) throws Exception {
        this(main_channel, fork_stack_id, fork_channel_id, false, ProtocolStack.Position.ABOVE, null, protocols);
    }

    @Override
    public ForkChannel setName(String name) {
        this.log.error("name (%s) cannot be set in a fork-channel", name);
        return this;
    }

    @Override
    public JChannel name(String name) {
        this.log.error("name (%s) cannot be set in a fork-channel", name);
        return this;
    }

    @Override
    public void channelConnected(JChannel channel) {
        this.copyFields();
        if (this.local_addr == null) {
            return;
        }
        Event evt = new Event(8, this.local_addr);
        if (this.up_handler != null) {
            this.up_handler.up(evt);
        }
    }

    @Override
    public void channelDisconnected(JChannel channel) {
        this.copyFields();
    }

    @Override
    public void channelClosed(JChannel channel) {
        this.copyFields();
    }

    @Override
    public ForkChannel connect(String cluster_name) throws Exception {
        if (!this.main_channel.isConnected()) {
            throw new IllegalStateException("main channel is not connected");
        }
        if (this.state == JChannel.State.CONNECTED) {
            return this;
        }
        if (this.state == JChannel.State.CLOSED) {
            throw new IllegalStateException("a closed fork channel cannot reconnect");
        }
        this.state = JChannel.State.CONNECTING;
        this.main_channel.addChannelListener(this);
        this.copyFields();
        JChannel existing_ch = ((ForkProtocolStack)this.prot_stack).putIfAbsent(this.fork_channel_id, this);
        if (existing_ch != null && existing_ch != this) {
            throw new IllegalArgumentException("fork-channel with id=" + this.fork_channel_id + " is already present");
        }
        this.setLocalAddress(this.local_addr);
        this.prot_stack.startStack();
        this.prot_stack.down(new Event(2, cluster_name));
        View current_view = this.main_channel.getView();
        if (current_view != null) {
            this.up(new Event(6, current_view));
            this.prot_stack.down(new Event(6, current_view));
        }
        this.state = JChannel.State.CONNECTED;
        this.notifyChannelConnected(this);
        return this;
    }

    @Override
    public ForkChannel connect(String cluster_name, Address target, long timeout2) throws Exception {
        this.connect(cluster_name);
        this.main_channel.getState(target, timeout2);
        return this;
    }

    @Override
    public ForkChannel disconnect() {
        if (this.state != JChannel.State.CONNECTED) {
            return this;
        }
        this.prot_stack.down(new Event(4, this.local_addr));
        this.prot_stack.stopStack(this.cluster_name);
        ((ForkProtocolStack)this.prot_stack).remove(this.fork_channel_id);
        this.nullFields();
        this.state = JChannel.State.OPEN;
        this.notifyChannelDisconnected(this);
        return this;
    }

    @Override
    public void close() {
        ((ForkProtocolStack)this.prot_stack).remove(this.fork_channel_id);
        if (this.state == JChannel.State.CLOSED) {
            return;
        }
        this.disconnect();
        this.prot_stack.destroy();
        this.state = JChannel.State.CLOSED;
        this.notifyChannelClosed(this);
    }

    @Override
    public Object down(Message msg) {
        this.setHeader(msg);
        return super.down(msg);
    }

    @Override
    public ForkChannel send(Message msg) throws Exception {
        this.checkClosedOrNotConnected();
        FORK.ForkHeader hdr = (FORK.ForkHeader)msg.getHeader(FORK.ID);
        if (hdr != null) {
            hdr.setForkChannelId(this.fork_channel_id);
        } else {
            hdr = new FORK.ForkHeader(null, this.fork_channel_id);
            msg.putHeader(FORK.ID, hdr);
        }
        this.prot_stack.down(msg);
        return this;
    }

    @Override
    public ForkChannel startFlush(List<Address> flushParticipants, boolean automatic_resume) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public ForkChannel startFlush(boolean automatic_resume) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public ForkChannel stopFlush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ForkChannel stopFlush(List<Address> flushParticipants) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ForkChannel getState(Address target, long timeout2) throws Exception {
        this.main_channel.getState(target, timeout2);
        return this;
    }

    @Override
    public ForkChannel addAddressGenerator(AddressGenerator address_generator) {
        this.main_channel.addAddressGenerator(address_generator);
        return this;
    }

    protected ForkChannel setLocalAddress(Address local_addr) {
        if (local_addr != null) {
            Event evt = new Event(8, local_addr);
            ((ForkProtocolStack)this.prot_stack).setLocalAddress(local_addr);
            if (this.up_handler != null) {
                this.up_handler.up(evt);
            }
        }
        return this;
    }

    protected static FORK getFORK(JChannel ch, ProtocolStack.Position position, Class<? extends Protocol> neighbor, boolean create_fork_if_absent) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        FORK fork = (FORK)stack.findProtocol((Class<? extends Protocol>)FORK.class);
        if (fork == null) {
            if (!create_fork_if_absent) {
                throw new IllegalArgumentException("FORK not found in main stack");
            }
            fork = new FORK();
            fork.setProtocolStack(stack);
            stack.insertProtocol((Protocol)fork, position, neighbor);
        }
        return fork;
    }

    protected void setHeader(Message msg) {
        FORK.ForkHeader hdr = (FORK.ForkHeader)msg.getHeader(FORK.ID);
        if (hdr != null) {
            hdr.setForkChannelId(this.fork_channel_id);
        } else {
            msg.putHeader(FORK.ID, new FORK.ForkHeader(null, this.fork_channel_id));
        }
    }

    protected void copyFields() {
        for (Field field : copied_fields) {
            Object value = Util.getField(field, this.main_channel);
            Util.setField(field, this, value);
        }
    }

    protected void nullFields() {
        for (Field field : copied_fields) {
            Util.setField(field, this, null);
        }
    }

    static {
        String[] fields = new String[]{"state", "local_addr", "name", "cluster_name", "view"};
        copied_fields = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field = Util.getField(JChannel.class, fields[i]);
            if (field == null) {
                throw new IllegalStateException("field \"" + fields[i] + "\" not found in JChannel");
            }
            ForkChannel.copied_fields[i] = field;
        }
    }
}

