/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class XSiteSetStateTransferModeCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 36;
    private String site;
    private XSiteStateTransferMode mode;

    public XSiteSetStateTransferModeCommand() {
        super(null);
    }

    public XSiteSetStateTransferModeCommand(ByteString cacheName) {
        super(cacheName);
    }

    public XSiteSetStateTransferModeCommand(ByteString cacheName, String site, XSiteStateTransferMode mode) {
        super(cacheName);
        this.site = site;
        this.mode = mode;
    }

    @Override
    public byte getCommandId() {
        return 36;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.site);
        MarshallUtil.marshallEnum(this.mode, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.site = input.readUTF();
        this.mode = MarshallUtil.unmarshallEnum(input, XSiteStateTransferMode::valueOf);
    }

    public CompletionStage<Void> invokeAsync(ComponentRegistry registry) throws Throwable {
        registry.getXSiteStateTransferManager().running().setAutomaticStateTransfer(this.site, this.mode);
        return CompletableFutures.completedNull();
    }
}

