/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.TakeOfflineConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.notification.SiteStatusListener;

@ThreadSafe
public class OfflineStatus {
    private static final Log log = LogFactory.getLog(OfflineStatus.class);
    private static final long NO_FAILURE = -1L;
    private final TimeService timeService;
    private final SiteStatusListener listener;
    private volatile TakeOfflineConfiguration takeOffline;
    @GuardedBy(value="this")
    private long firstFailureTime = -1L;
    @GuardedBy(value="this")
    private int failureCount = 0;
    @GuardedBy(value="this")
    private boolean isOffline = false;

    public OfflineStatus(TakeOfflineConfiguration takeOfflineConfiguration, TimeService timeService, SiteStatusListener listener) {
        this.takeOffline = takeOfflineConfiguration;
        this.timeService = timeService;
        this.listener = listener;
    }

    public synchronized void updateOnCommunicationFailure(long sendTimeMillis) {
        if (this.firstFailureTime == -1L) {
            this.firstFailureTime = sendTimeMillis;
        }
        ++this.failureCount;
        this.internalUpdateStatus();
    }

    public synchronized boolean isOffline() {
        return this.isOffline;
    }

    public synchronized boolean minTimeHasElapsed() {
        if (this.firstFailureTime == -1L) {
            return false;
        }
        return this.internalMinTimeHasElapsed();
    }

    public synchronized long millisSinceFirstFailure() {
        return this.internalMillisSinceFirstFailure();
    }

    public synchronized boolean bringOnline() {
        return this.isOffline && this.internalReset();
    }

    public synchronized int getFailureCount() {
        return this.failureCount;
    }

    public synchronized boolean isEnabled() {
        return this.takeOffline.enabled();
    }

    public synchronized void reset() {
        this.internalReset();
    }

    public TakeOfflineConfiguration getTakeOffline() {
        return this.takeOffline;
    }

    public synchronized boolean forceOffline() {
        if (this.isOffline) {
            return false;
        }
        this.isOffline = true;
        this.listener.siteOffline();
        return true;
    }

    public synchronized String toString() {
        return "OfflineStatus{takeOffline=" + this.takeOffline + ", recordingOfflineStatus=" + (this.firstFailureTime != -1L) + ", firstFailureTime=" + this.firstFailureTime + ", isOffline=" + this.isOffline + ", failureCount=" + this.failureCount + '}';
    }

    public void amend(Integer afterFailures, Long minTimeToWait) {
        TakeOfflineConfigurationBuilder builder = new TakeOfflineConfigurationBuilder(null, null);
        builder.read(this.getTakeOffline());
        if (afterFailures != null) {
            builder.afterFailures(afterFailures);
        }
        if (minTimeToWait != null) {
            builder.minTimeToWait(minTimeToWait);
        }
        this.amend(builder.create());
    }

    private void amend(TakeOfflineConfiguration takeOffline) {
        this.takeOffline = takeOffline;
        this.reset();
    }

    @GuardedBy(value="this")
    private void internalUpdateStatus() {
        boolean hasMinWait;
        if (this.isOffline) {
            return;
        }
        boolean bl = hasMinWait = this.takeOffline.minTimeToWait() > 0L;
        if (hasMinWait && !this.internalMinTimeHasElapsed()) {
            return;
        }
        long minFailures = this.takeOffline.afterFailures();
        if (minFailures > 0L) {
            if (minFailures <= (long)this.failureCount) {
                if (log.isTraceEnabled()) {
                    log.tracef("Site is failed: min failures (%s) reached (count=%s).", minFailures, (long)this.failureCount);
                }
                this.listener.siteOffline();
                this.isOffline = true;
            }
        } else if (hasMinWait) {
            if (log.isTraceEnabled()) {
                log.trace("Site is failed: minTimeToWait elapsed and we don't have a min failure number to wait for.");
            }
            this.listener.siteOffline();
            this.isOffline = true;
        }
    }

    @GuardedBy(value="this")
    private boolean internalMinTimeHasElapsed() {
        long minTimeToWait = this.takeOffline.minTimeToWait();
        if (minTimeToWait <= 0L) {
            throw new IllegalStateException("Cannot invoke this method if minTimeToWait is not enabled");
        }
        long millis = this.internalMillisSinceFirstFailure();
        if (millis >= minTimeToWait) {
            if (log.isTraceEnabled()) {
                log.tracef("The minTimeToWait has passed: minTime=%s, timeSinceFirstFailure=%s", minTimeToWait, millis);
            }
            return true;
        }
        return false;
    }

    @GuardedBy(value="this")
    private boolean internalReset() {
        boolean wasOffline = this.isOffline;
        this.firstFailureTime = -1L;
        this.failureCount = 0;
        this.isOffline = false;
        if (wasOffline) {
            this.listener.siteOnline();
        }
        return wasOffline;
    }

    @GuardedBy(value="this")
    private long internalMillisSinceFirstFailure() {
        return this.timeService.timeDuration(TimeUnit.MILLISECONDS.toNanos(this.firstFailureTime), TimeUnit.MILLISECONDS);
    }
}

