/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.jboss.logging.Logger;
import org.jboss.logging.NDC;

public class LogFactory {
    public static Log getLog(Class<?> clazz) {
        return Logger.getMessageLogger(Log.class, clazz.getName());
    }

    public static <T> T getLog(Class<?> clazz, Class<T> logClass) {
        return Logger.getMessageLogger(logClass, clazz.getName());
    }

    public static <T> T getLog(String category, Class<T> logClass) {
        return Logger.getMessageLogger(logClass, "org.infinispan." + category);
    }

    public static Logger getLogger(String category) {
        return Logger.getLogger("org.infinispan." + category);
    }

    public static void pushNDC(String cacheName, boolean isTrace) {
        if (isTrace) {
            NDC.push(cacheName);
        }
    }

    public static void pushNDC(ByteString cacheName, boolean isTrace) {
        if (isTrace) {
            NDC.push(cacheName.toString());
        }
    }

    public static void popNDC(boolean isTrace) {
        if (isTrace) {
            NDC.pop();
        }
    }
}

