/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.impl;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.StripedHashFunction;
import org.infinispan.util.concurrent.locks.DeadlockChecker;
import org.infinispan.util.concurrent.locks.ExtendedLockPromise;
import org.infinispan.util.concurrent.locks.impl.InfinispanLock;
import org.infinispan.util.concurrent.locks.impl.LockContainer;

@Scope(value=Scopes.NAMED_CACHE)
public class StripedLockContainer
implements LockContainer {
    private final InfinispanLock[] sharedLocks;
    private final StripedHashFunction<Object> hashFunction;

    public StripedLockContainer(int concurrencyLevel) {
        this.hashFunction = new StripedHashFunction(concurrencyLevel);
        this.sharedLocks = new InfinispanLock[this.hashFunction.getNumSegments()];
    }

    @Inject
    void inject(@ComponentName(value="org.infinispan.executors.non-blocking") Executor nonBlockingExecutor, TimeService timeService) {
        for (int i = 0; i < this.sharedLocks.length; ++i) {
            if (this.sharedLocks[i] == null) {
                this.sharedLocks[i] = new InfinispanLock(nonBlockingExecutor, timeService);
                continue;
            }
            this.sharedLocks[i].setTimeService(timeService);
        }
    }

    @Override
    public ExtendedLockPromise acquire(Object key, Object lockOwner, long time, TimeUnit timeUnit) {
        return this.getLock(key).acquire(lockOwner, time, timeUnit);
    }

    @Override
    public void release(Object key, Object lockOwner) {
        this.getLock(key).release(lockOwner);
    }

    @Override
    public InfinispanLock getLock(Object key) {
        return this.sharedLocks[this.hashFunction.hashToSegment(key)];
    }

    @Override
    public int getNumLocksHeld() {
        int count = 0;
        for (InfinispanLock lock : this.sharedLocks) {
            if (!lock.isLocked()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isLocked(Object key) {
        return this.getLock(key).isLocked();
    }

    @Override
    public int size() {
        return this.sharedLocks.length;
    }

    @Override
    public void deadlockCheck(DeadlockChecker deadlockChecker) {
        InfinispanCollections.forEach(this.sharedLocks, lock -> lock.deadlockCheck(deadlockChecker));
    }

    public String toString() {
        return "StripedLockContainer{locks=" + Arrays.toString(this.sharedLocks) + '}';
    }
}

