/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.CacheCollection;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.InjectiveFunction;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.SpliteratorMapper;
import org.infinispan.util.CollectionMapper;
import org.infinispan.util.MappedCacheStream;

public class WriteableCacheCollectionMapper<E, R>
extends CollectionMapper<E, R>
implements CacheCollection<R> {
    protected final CacheCollection<E> realCacheCollection;
    protected final Function<? super E, ? extends R> toNewTypeIteratorFunction;
    protected final Function<? super R, ? extends E> fromNewTypeFunction;
    protected final InjectiveFunction<Object, ?> keyFilterMapper;

    public WriteableCacheCollectionMapper(CacheCollection<E> realCollection, Function<? super E, ? extends R> toNewTypeFunction, Function<? super R, ? extends E> fromNewTypeFunction, InjectiveFunction<Object, ?> keyFilterFunction) {
        super(realCollection, toNewTypeFunction);
        this.realCacheCollection = realCollection;
        this.toNewTypeIteratorFunction = toNewTypeFunction;
        this.fromNewTypeFunction = fromNewTypeFunction;
        this.keyFilterMapper = keyFilterFunction;
    }

    public WriteableCacheCollectionMapper(CacheCollection<E> realCollection, Function<? super E, ? extends R> toNewTypeFunction, Function<? super E, ? extends R> toNewTypeIteratorFunction, Function<? super R, ? extends E> fromNewTypeFunction, InjectiveFunction<Object, ?> keyFilterFunction) {
        super(realCollection, toNewTypeFunction);
        this.realCacheCollection = realCollection;
        this.toNewTypeIteratorFunction = toNewTypeIteratorFunction;
        this.fromNewTypeFunction = fromNewTypeFunction;
        this.keyFilterMapper = keyFilterFunction;
    }

    @Override
    public CloseableIterator<R> iterator() {
        return new IteratorMapper<E, R>(this.realCollection.iterator(), this.toNewTypeIteratorFunction);
    }

    @Override
    public boolean contains(Object o) {
        return this.realCollection.contains(this.fromNewTypeFunction.apply(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.realCollection.containsAll(new CollectionMapper<R, E>(c, this.fromNewTypeFunction));
    }

    @Override
    public boolean add(R e) {
        return this.realCollection.add(this.fromNewTypeFunction.apply(e));
    }

    @Override
    public boolean addAll(Collection<? extends R> c) {
        return this.realCollection.addAll(new CollectionMapper<R, E>(c, this.fromNewTypeFunction));
    }

    @Override
    public boolean remove(Object o) {
        return this.realCollection.remove(this.fromNewTypeFunction.apply(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.realCollection.removeAll(new CollectionMapper<R, E>(c, this.fromNewTypeFunction));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.realCollection.retainAll(new CollectionMapper<R, E>(c, this.fromNewTypeFunction));
    }

    @Override
    public boolean removeIf(Predicate<? super R> filter) {
        return this.realCollection.removeIf((? super E e) -> filter.test((R)this.mapper.apply(e)));
    }

    @Override
    public void clear() {
        this.realCollection.clear();
    }

    @Override
    public CloseableSpliterator<R> spliterator() {
        return new SpliteratorMapper(this.realCacheCollection.spliterator(), this.mapper);
    }

    private CacheStream<R> getStream(CacheStream<E> parentStream) {
        return new MappedCacheStream(parentStream.map(this.mapper), this.keyFilterMapper);
    }

    @Override
    public CacheStream<R> stream() {
        return this.getStream((CacheStream<E>)this.realCacheCollection.stream());
    }

    @Override
    public CacheStream<R> parallelStream() {
        return this.getStream((CacheStream<E>)this.realCacheCollection.parallelStream());
    }
}

