/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class WildflyTransactionManagerLookup
implements TransactionManagerLookup {
    private static final String WILDFLY_TM_CLASS_NAME = "org.wildfly.transaction.client.ContextTransactionManager";
    private static final String WILDFLY_UT_CLASS_NAME = "org.wildfly.transaction.client.LocalUserTransaction";
    private static final String WILDFLY_STATIC_METHOD = "getInstance";
    private static final Log log = LogFactory.getLog(WildflyTransactionManagerLookup.class);
    private Method manager;
    private Method user;

    @Inject
    public void init(GlobalConfiguration globalCfg) {
        this.init(globalCfg.classLoader());
    }

    @Override
    public synchronized TransactionManager getTransactionManager() throws Exception {
        TransactionManager tm = (TransactionManager)this.manager.invoke(null, new Object[0]);
        if (log.isInfoEnabled()) {
            log.retrievingTm(tm);
        }
        return tm;
    }

    public UserTransaction getUserTransaction() throws Exception {
        return (UserTransaction)this.user.invoke(null, new Object[0]);
    }

    public String toString() {
        return "JBossStandaloneJTAManagerLookup";
    }

    private void init(ClassLoader classLoader) {
        try {
            this.manager = Util.loadClassStrict(WILDFLY_TM_CLASS_NAME, classLoader).getMethod(WILDFLY_STATIC_METHOD, new Class[0]);
            this.user = Util.loadClassStrict(WILDFLY_UT_CLASS_NAME, classLoader).getMethod(WILDFLY_STATIC_METHOD, new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

