/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.jgroups.Address;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.Util;

public class JGroupsTopologyAwareAddress
extends JGroupsAddress
implements TopologyAwareAddress {
    private static final byte[] SITE_KEY = Util.stringToBytes("site-id");
    private static final byte[] RACK_KEY = Util.stringToBytes("rack-id");
    private static final byte[] MACHINE_KEY = Util.stringToBytes("machine-id");

    public static ExtendedUUID randomUUID(String name, String siteId, String rackId, String machineId) {
        ExtendedUUID uuid = ExtendedUUID.randomUUID(name);
        if (name != null) {
            NameCache.add(uuid, name);
        }
        JGroupsTopologyAwareAddress.addId(uuid, SITE_KEY, siteId);
        JGroupsTopologyAwareAddress.addId(uuid, RACK_KEY, rackId);
        JGroupsTopologyAwareAddress.addId(uuid, MACHINE_KEY, machineId);
        return uuid;
    }

    private static void addId(ExtendedUUID uuid, byte[] key, String stringValue) {
        if (stringValue != null) {
            uuid.put(key, Util.stringToBytes(stringValue));
        }
    }

    public JGroupsTopologyAwareAddress(ExtendedUUID address) {
        super(address);
    }

    @Override
    public String getSiteId() {
        return this.getString(SITE_KEY);
    }

    @Override
    public String getRackId() {
        return this.getString(RACK_KEY);
    }

    @Override
    public String getMachineId() {
        return this.getString(MACHINE_KEY);
    }

    public boolean matches(String siteId, String rackId, String machineId) {
        return this.checkComponent(SITE_KEY, siteId) && this.checkComponent(RACK_KEY, rackId) && this.checkComponent(MACHINE_KEY, machineId);
    }

    @Override
    public boolean isSameSite(TopologyAwareAddress addr) {
        if (addr instanceof JGroupsTopologyAwareAddress) {
            ExtendedUUID otherUUID = ((JGroupsTopologyAwareAddress)addr).topologyAddress();
            return this.checkComponent(SITE_KEY, otherUUID);
        }
        return this.checkComponent(SITE_KEY, addr.getSiteId());
    }

    @Override
    public boolean isSameRack(TopologyAwareAddress addr) {
        if (addr instanceof JGroupsTopologyAwareAddress) {
            ExtendedUUID otherUUID = ((JGroupsTopologyAwareAddress)addr).topologyAddress();
            return this.checkComponent(SITE_KEY, otherUUID) && this.checkComponent(RACK_KEY, otherUUID);
        }
        return this.checkComponent(SITE_KEY, addr.getSiteId()) && this.checkComponent(RACK_KEY, addr.getRackId());
    }

    @Override
    public boolean isSameMachine(TopologyAwareAddress addr) {
        if (addr instanceof JGroupsTopologyAwareAddress) {
            ExtendedUUID otherUUID = ((JGroupsTopologyAwareAddress)addr).topologyAddress();
            return this.checkComponent(SITE_KEY, otherUUID) && this.checkComponent(RACK_KEY, otherUUID) && this.checkComponent(MACHINE_KEY, otherUUID);
        }
        return this.checkComponent(SITE_KEY, addr.getSiteId()) && this.checkComponent(RACK_KEY, addr.getRackId()) && this.checkComponent(MACHINE_KEY, addr.getMachineId());
    }

    private boolean checkComponent(byte[] key, ExtendedUUID uuid) {
        return this.checkComponent(key, uuid.get(key));
    }

    private boolean checkComponent(byte[] key, String stringValue) {
        return this.checkComponent(key, Util.stringToBytes(stringValue));
    }

    private boolean checkComponent(byte[] key, byte[] expectedValue) {
        return Arrays.equals(this.getBytes(key), expectedValue);
    }

    private String getString(byte[] key) {
        return Util.bytesToString(this.getBytes(key));
    }

    private byte[] getBytes(byte[] key) {
        return this.topologyAddress().get(key);
    }

    private ExtendedUUID topologyAddress() {
        return (ExtendedUUID)this.address;
    }

    public static final class Externalizer
    extends InstanceReusingAdvancedExternalizer<JGroupsTopologyAwareAddress> {
        public Externalizer() {
            super(false);
        }

        @Override
        public void doWriteObject(ObjectOutput output, JGroupsTopologyAwareAddress address) throws IOException {
            try {
                Util.writeAddress(address.address, output);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public JGroupsTopologyAwareAddress doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            try {
                Address jgroupsAddress = Util.readAddress(unmarshaller);
                return (JGroupsTopologyAwareAddress)JGroupsAddressCache.fromJGroupsAddress(jgroupsAddress);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public Set<Class<? extends JGroupsTopologyAwareAddress>> getTypeClasses() {
            return Collections.singleton(JGroupsTopologyAwareAddress.class);
        }

        @Override
        public Integer getId() {
            return 30;
        }
    }
}

