/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.IntSummaryStatistics;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.exts.SecurityActions;

public class IntSummaryStatisticsExternalizer
extends AbstractExternalizer<IntSummaryStatistics> {
    static final Field countField;
    static final Field sumField;
    static final Field minField;
    static final Field maxField;
    static final boolean canSerialize;
    static final Constructor<IntSummaryStatistics> constructor;

    @Override
    public Set<Class<? extends IntSummaryStatistics>> getTypeClasses() {
        return Util.asSet(IntSummaryStatistics.class);
    }

    private void verifySerialization() {
        if (!canSerialize) {
            throw new NotSerializableException("IntSummaryStatistics is not serializable, fields not available!");
        }
    }

    @Override
    public void writeObject(ObjectOutput output, IntSummaryStatistics object) throws IOException {
        this.verifySerialization();
        output.writeLong(object.getCount());
        output.writeLong(object.getSum());
        output.writeInt(object.getMin());
        output.writeInt(object.getMax());
    }

    @Override
    public IntSummaryStatistics readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        IntSummaryStatistics summaryStatistics;
        this.verifySerialization();
        long count = input.readLong();
        long sum = input.readLong();
        int min2 = input.readInt();
        int max = input.readInt();
        if (constructor != null) {
            try {
                summaryStatistics = constructor.newInstance(count, min2, max, sum);
            }
            catch (ReflectiveOperationException e) {
                throw new IOException(e);
            }
        }
        try {
            summaryStatistics = new IntSummaryStatistics();
            countField.setLong(summaryStatistics, count);
            sumField.setLong(summaryStatistics, sum);
            minField.setInt(summaryStatistics, min2);
            maxField.setInt(summaryStatistics, max);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        return summaryStatistics;
    }

    @Override
    public Integer getId() {
        return 16;
    }

    static {
        constructor = SecurityActions.getConstructor(IntSummaryStatistics.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE);
        if (constructor != null) {
            countField = null;
            sumField = null;
            minField = null;
            maxField = null;
            canSerialize = true;
        } else {
            countField = SecurityActions.getField(IntSummaryStatistics.class, "count");
            sumField = SecurityActions.getField(IntSummaryStatistics.class, "sum");
            minField = SecurityActions.getField(IntSummaryStatistics.class, "min");
            maxField = SecurityActions.getField(IntSummaryStatistics.class, "max");
            canSerialize = countField != null && sumField != null && minField != null && maxField != null;
        }
    }
}

