/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.marshall.LambdaExternalizer;
import org.infinispan.commons.marshall.ValueMatcherMode;
import org.infinispan.commons.util.Util;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.core.MarshallableFunctions;

public class MarshallableFunctionExternalizers {
    private static final short VALUE_MATCH_ALWAYS = 4096;
    private static final short VALUE_MATCH_EXPECTED = 8192;
    private static final short VALUE_MATCH_EXPECTED_OR_NEW = 12288;
    private static final short VALUE_MATCH_NON_NULL = 16384;
    private static final short VALUE_MATCH_NEVER = 20480;
    private static final int VALUE_MATCH_MASK = 61440;
    private static final int SET_VALUE_RETURN_PREV_OR_NULL = 4097;
    private static final int SET_VALUE_RETURN_VIEW = 4098;
    private static final int SET_VALUE_IF_ABSENT_RETURN_PREV_OR_NULL = 8195;
    private static final int SET_VALUE_IF_ABSENT_RETURN_BOOLEAN = 8196;
    private static final int SET_VALUE_IF_PRESENT_RETURN_PREV_OR_NULL = 16389;
    private static final int SET_VALUE_IF_PRESENT_RETURN_BOOLEAN = 16390;
    private static final int REMOVE_RETURN_PREV_OR_NULL = 4103;
    private static final int REMOVE_RETURN_BOOLEAN = 4104;
    private static final int REMOVE_IF_VALUE_EQUALS_RETURN_BOOLEAN = 8201;
    private static final int SET_VALUE_CONSUMER = 4106;
    private static final int REMOVE_CONSUMER = 4107;
    private static final int RETURN_READ_WRITE_FIND = 4108;
    private static final int RETURN_READ_WRITE_GET = 4109;
    private static final int RETURN_READ_WRITE_VIEW = 4110;
    private static final int RETURN_READ_ONLY_FIND_OR_NULL = 4111;
    private static final int RETURN_READ_ONLY_FIND_IS_PRESENT = 4112;
    private static final int IDENTITY = 4113;
    private static final int SET_INTERNAL_CACHE_VALUE_CONSUMER = 4114;

    static MetaParam.Writable[] readMetas(ObjectInput input) throws IOException, ClassNotFoundException {
        int len = input.readInt();
        MetaParam.Writable[] metas = new MetaParam.Writable[len];
        for (int i = 0; i < len; ++i) {
            metas[i] = (MetaParam.Writable)input.readObject();
        }
        return metas;
    }

    private static void writeMetas(ObjectOutput oo, MarshallableFunctions.LambdaWithMetas o) throws IOException {
        oo.writeInt(o.metas().length);
        for (MetaParam.Writable meta : o.metas()) {
            oo.writeObject(meta);
        }
    }

    public static final class SetValueIfEqualsReturnBooleanExternalizer
    implements LambdaExternalizer<MarshallableFunctions.SetValueIfEqualsReturnBoolean> {
        @Override
        public void writeObject(ObjectOutput oo, MarshallableFunctions.SetValueIfEqualsReturnBoolean o) throws IOException {
            oo.writeObject(o.oldValue);
            MarshallableFunctionExternalizers.writeMetas(oo, o);
        }

        @Override
        public MarshallableFunctions.SetValueIfEqualsReturnBoolean readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object oldValue = input.readObject();
            MetaParam.Writable[] metas = MarshallableFunctionExternalizers.readMetas(input);
            return new MarshallableFunctions.SetValueIfEqualsReturnBoolean(oldValue, metas);
        }

        @Override
        public ValueMatcherMode valueMatcher(Object o) {
            return ValueMatcherMode.MATCH_EXPECTED;
        }

        @Override
        public Set<Class<? extends MarshallableFunctions.SetValueIfEqualsReturnBoolean>> getTypeClasses() {
            return Util.asSet(MarshallableFunctions.SetValueIfEqualsReturnBoolean.class);
        }

        @Override
        public Integer getId() {
            return 108;
        }
    }

    public static final class LambdaWithMetasExternalizer
    implements LambdaExternalizer<MarshallableFunctions.LambdaWithMetas> {
        private final Map<Class<?>, Integer> numbers = new HashMap(7);

        public LambdaWithMetasExternalizer() {
            this.numbers.put(MarshallableFunctions.SetValueMetasReturnPrevOrNull.class, 4097);
            this.numbers.put(MarshallableFunctions.SetValueMetasReturnView.class, 4098);
            this.numbers.put(MarshallableFunctions.SetValueMetasIfAbsentReturnPrevOrNull.class, 8195);
            this.numbers.put(MarshallableFunctions.SetValueMetasIfAbsentReturnBoolean.class, 8196);
            this.numbers.put(MarshallableFunctions.SetValueMetasIfPresentReturnPrevOrNull.class, 16389);
            this.numbers.put(MarshallableFunctions.SetValueMetasIfPresentReturnBoolean.class, 16390);
            this.numbers.put(MarshallableFunctions.SetValueMetas.class, 4106);
        }

        @Override
        public ValueMatcherMode valueMatcher(Object o) {
            int i = this.numbers.getOrDefault(o.getClass(), -1);
            if (i > 0) {
                int valueMatcherId = ((i & 0xF000) >> 12) - 1;
                return ValueMatcherMode.valueOf(valueMatcherId);
            }
            return ValueMatcherMode.MATCH_ALWAYS;
        }

        @Override
        public Set<Class<? extends MarshallableFunctions.LambdaWithMetas>> getTypeClasses() {
            return Util.asSet(MarshallableFunctions.SetValueMetasReturnPrevOrNull.class, MarshallableFunctions.SetValueMetasReturnView.class, MarshallableFunctions.SetValueMetasIfAbsentReturnPrevOrNull.class, MarshallableFunctions.SetValueMetasIfAbsentReturnBoolean.class, MarshallableFunctions.SetValueMetasIfPresentReturnPrevOrNull.class, MarshallableFunctions.SetValueMetasIfPresentReturnBoolean.class, MarshallableFunctions.SetValueMetas.class);
        }

        @Override
        public Integer getId() {
            return 109;
        }

        @Override
        public void writeObject(ObjectOutput oo, MarshallableFunctions.LambdaWithMetas o) throws IOException {
            int id = this.numbers.getOrDefault(o.getClass(), -1);
            oo.writeShort(id);
            MarshallableFunctionExternalizers.writeMetas(oo, o);
        }

        @Override
        public MarshallableFunctions.LambdaWithMetas readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            short id = input.readShort();
            MetaParam.Writable[] metas = MarshallableFunctionExternalizers.readMetas(input);
            switch (id) {
                case 4097: {
                    return new MarshallableFunctions.SetValueMetasReturnPrevOrNull(metas);
                }
                case 8195: {
                    return new MarshallableFunctions.SetValueMetasIfAbsentReturnPrevOrNull(metas);
                }
                case 8196: {
                    return new MarshallableFunctions.SetValueMetasIfAbsentReturnBoolean(metas);
                }
                case 4098: {
                    return new MarshallableFunctions.SetValueMetasReturnView(metas);
                }
                case 16389: {
                    return new MarshallableFunctions.SetValueMetasIfPresentReturnPrevOrNull(metas);
                }
                case 16390: {
                    return new MarshallableFunctions.SetValueMetasIfPresentReturnBoolean(metas);
                }
                case 4106: {
                    return new MarshallableFunctions.SetValueMetas(metas);
                }
            }
            throw new IllegalStateException("Unknown lambda and meta parameters with ID: " + id);
        }
    }

    public static final class ConstantLambdaExternalizer
    implements LambdaExternalizer<Object> {
        private final Map<Class<?>, Integer> numbers = new HashMap(16);

        public ConstantLambdaExternalizer() {
            this.numbers.put(MarshallableFunctions.setValueReturnPrevOrNull().getClass(), 4097);
            this.numbers.put(MarshallableFunctions.setValueReturnView().getClass(), 4098);
            this.numbers.put(MarshallableFunctions.setValueIfAbsentReturnPrevOrNull().getClass(), 8195);
            this.numbers.put(MarshallableFunctions.setValueIfAbsentReturnBoolean().getClass(), 8196);
            this.numbers.put(MarshallableFunctions.setValueIfPresentReturnPrevOrNull().getClass(), 16389);
            this.numbers.put(MarshallableFunctions.setValueIfPresentReturnBoolean().getClass(), 16390);
            this.numbers.put(MarshallableFunctions.removeReturnPrevOrNull().getClass(), 4103);
            this.numbers.put(MarshallableFunctions.removeReturnBoolean().getClass(), 4104);
            this.numbers.put(MarshallableFunctions.removeIfValueEqualsReturnBoolean().getClass(), 8201);
            this.numbers.put(MarshallableFunctions.setValueConsumer().getClass(), 4106);
            this.numbers.put(MarshallableFunctions.removeConsumer().getClass(), 4107);
            this.numbers.put(MarshallableFunctions.returnReadWriteFind().getClass(), 4108);
            this.numbers.put(MarshallableFunctions.returnReadWriteGet().getClass(), 4109);
            this.numbers.put(MarshallableFunctions.returnReadWriteView().getClass(), 4110);
            this.numbers.put(MarshallableFunctions.returnReadOnlyFindOrNull().getClass(), 4111);
            this.numbers.put(MarshallableFunctions.returnReadOnlyFindIsPresent().getClass(), 4112);
            this.numbers.put(MarshallableFunctions.identity().getClass(), 4113);
            this.numbers.put(MarshallableFunctions.setInternalCacheValueConsumer().getClass(), 4114);
        }

        @Override
        public ValueMatcherMode valueMatcher(Object o) {
            int i = this.numbers.getOrDefault(o.getClass(), -1);
            if (i > 0) {
                int valueMatcherId = ((i & 0xF000) >> 12) - 1;
                return ValueMatcherMode.valueOf(valueMatcherId);
            }
            return ValueMatcherMode.MATCH_ALWAYS;
        }

        @Override
        public Set<Class<?>> getTypeClasses() {
            return Util.asSet(MarshallableFunctions.setValueReturnPrevOrNull().getClass(), MarshallableFunctions.setValueReturnView().getClass(), MarshallableFunctions.setValueIfAbsentReturnPrevOrNull().getClass(), MarshallableFunctions.setValueIfAbsentReturnBoolean().getClass(), MarshallableFunctions.setValueIfPresentReturnPrevOrNull().getClass(), MarshallableFunctions.setValueIfPresentReturnBoolean().getClass(), MarshallableFunctions.removeReturnPrevOrNull().getClass(), MarshallableFunctions.removeReturnBoolean().getClass(), MarshallableFunctions.removeIfValueEqualsReturnBoolean().getClass(), MarshallableFunctions.setValueConsumer().getClass(), MarshallableFunctions.removeConsumer().getClass(), MarshallableFunctions.returnReadWriteFind().getClass(), MarshallableFunctions.returnReadWriteGet().getClass(), MarshallableFunctions.returnReadWriteView().getClass(), MarshallableFunctions.returnReadOnlyFindOrNull().getClass(), MarshallableFunctions.returnReadOnlyFindIsPresent().getClass(), MarshallableFunctions.identity().getClass(), MarshallableFunctions.setInternalCacheValueConsumer().getClass());
        }

        @Override
        public Integer getId() {
            return 107;
        }

        @Override
        public void writeObject(ObjectOutput oo, Object o) throws IOException {
            int id = this.numbers.getOrDefault(o.getClass(), -1);
            oo.writeShort(id);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException {
            short id = input.readShort();
            switch (id) {
                case 4097: {
                    return MarshallableFunctions.setValueReturnPrevOrNull();
                }
                case 4098: {
                    return MarshallableFunctions.setValueReturnView();
                }
                case 8195: {
                    return MarshallableFunctions.setValueIfAbsentReturnPrevOrNull();
                }
                case 8196: {
                    return MarshallableFunctions.setValueIfAbsentReturnBoolean();
                }
                case 16389: {
                    return MarshallableFunctions.setValueIfPresentReturnPrevOrNull();
                }
                case 16390: {
                    return MarshallableFunctions.setValueIfPresentReturnBoolean();
                }
                case 4103: {
                    return MarshallableFunctions.removeReturnPrevOrNull();
                }
                case 4104: {
                    return MarshallableFunctions.removeReturnBoolean();
                }
                case 8201: {
                    return MarshallableFunctions.removeIfValueEqualsReturnBoolean();
                }
                case 4106: {
                    return MarshallableFunctions.setValueConsumer();
                }
                case 4107: {
                    return MarshallableFunctions.removeConsumer();
                }
                case 4108: {
                    return MarshallableFunctions.returnReadWriteFind();
                }
                case 4109: {
                    return MarshallableFunctions.returnReadWriteGet();
                }
                case 4110: {
                    return MarshallableFunctions.returnReadWriteView();
                }
                case 4111: {
                    return MarshallableFunctions.returnReadOnlyFindOrNull();
                }
                case 4112: {
                    return MarshallableFunctions.returnReadOnlyFindIsPresent();
                }
                case 4113: {
                    return MarshallableFunctions.identity();
                }
                case 4114: {
                    return MarshallableFunctions.setInternalCacheValueConsumer();
                }
            }
            throw new IllegalStateException("Unknown lambda ID: " + id);
        }
    }
}

