/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.DynamicModuleMetadataProvider;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.CyclicDependencyException;
import org.infinispan.util.DependencyGraph;

public final class ModuleRepository {
    private final List<ModuleLifecycle> moduleLifecycles;
    private final Map<String, ComponentAccessor<?>> components;
    private final Map<String, String> factoryNames;
    private final Map<String, MBeanMetadata> mbeans;

    private ModuleRepository(List<ModuleLifecycle> moduleLifecycles, Map<String, ComponentAccessor<?>> components, Map<String, String> factoryNames, Map<String, MBeanMetadata> mbeans) {
        this.moduleLifecycles = moduleLifecycles;
        this.components = components;
        this.factoryNames = factoryNames;
        this.mbeans = mbeans;
    }

    public static ModuleRepository newModuleRepository(ClassLoader classLoader, GlobalConfiguration globalConfiguration) {
        return new Builder(classLoader, globalConfiguration).build();
    }

    public ComponentAccessor<Object> getComponentAccessor(String componentClassName) {
        return this.components.get(componentClassName);
    }

    public String getFactoryName(String componentName) {
        return this.factoryNames.get(componentName);
    }

    public MBeanMetadata getMBeanMetadata(String componentName) {
        return this.mbeans.get(componentName);
    }

    public Collection<ModuleLifecycle> getModuleLifecycles() {
        return this.moduleLifecycles;
    }

    private static final class Builder
    implements ModuleMetadataBuilder.ModuleBuilder {
        private final List<ModuleLifecycle> moduleLifecycles = new ArrayList<ModuleLifecycle>();
        private final Map<String, ComponentAccessor<?>> components = new HashMap();
        private final Map<String, String> factoryNames = new HashMap<String, String>();
        private final Map<String, MBeanMetadata> mbeans = new HashMap<String, MBeanMetadata>();

        private Builder(ClassLoader classLoader, GlobalConfiguration globalConfiguration) {
            Collection<ModuleMetadataBuilder> serviceLoader = ServiceFinder.load(ModuleMetadataBuilder.class, ModuleRepository.class.getClassLoader(), classLoader);
            HashMap<String, ModuleMetadataBuilder> modulesMap = new HashMap<String, ModuleMetadataBuilder>();
            for (ModuleMetadataBuilder module : serviceLoader) {
                ModuleMetadataBuilder existing = modulesMap.put(module.getModuleName(), module);
                if (existing == null) continue;
                throw new IllegalStateException("Multiple modules registered with name " + module.getModuleName());
            }
            List<ModuleMetadataBuilder> modules = Builder.sortModuleDependencies(modulesMap);
            for (ModuleMetadataBuilder module : modules) {
                module.registerMetadata(this);
                ModuleLifecycle moduleLifecycle = module.newModuleLifecycle();
                this.moduleLifecycles.add(moduleLifecycle);
                if (!(moduleLifecycle instanceof DynamicModuleMetadataProvider)) continue;
                ((DynamicModuleMetadataProvider)((Object)moduleLifecycle)).registerDynamicMetadata(this, globalConfiguration);
            }
        }

        private ModuleRepository build() {
            return new ModuleRepository(this.moduleLifecycles, this.components, this.factoryNames, this.mbeans);
        }

        private static List<ModuleMetadataBuilder> sortModuleDependencies(Map<String, ModuleMetadataBuilder> modulesMap) {
            DependencyGraph<ModuleMetadataBuilder> dependencyGraph = new DependencyGraph<ModuleMetadataBuilder>();
            for (ModuleMetadataBuilder module : modulesMap.values()) {
                ModuleMetadataBuilder dependency;
                for (String dependencyName : module.getRequiredDependencies()) {
                    dependency = modulesMap.get(dependencyName);
                    if (dependency == null) {
                        throw new CacheConfigurationException("Missing required dependency: Module '" + module.getModuleName() + "' requires '" + dependencyName + "'");
                    }
                    dependencyGraph.addDependency(dependency, module);
                }
                for (String dependencyName : module.getOptionalDependencies()) {
                    dependency = modulesMap.get(dependencyName);
                    if (dependency == null) continue;
                    dependencyGraph.addDependency(dependency, module);
                }
            }
            try {
                List<ModuleMetadataBuilder> sortedBuilders = dependencyGraph.topologicalSort();
                for (ModuleMetadataBuilder module : modulesMap.values()) {
                    if (sortedBuilders.contains(module)) continue;
                    sortedBuilders.add(module);
                }
                return sortedBuilders;
            }
            catch (CyclicDependencyException e) {
                throw new CacheConfigurationException(e);
            }
        }

        @Override
        public void registerComponentAccessor(String componentClassName, List<String> factoryComponentNames, ComponentAccessor<?> accessor) {
            this.components.put(componentClassName, accessor);
            for (String factoryComponentName : factoryComponentNames) {
                this.factoryNames.put(factoryComponentName, componentClassName);
            }
        }

        @Override
        public void registerMBeanMetadata(String componentClassName, MBeanMetadata mBeanMetadata) {
            this.mbeans.put(componentClassName, mBeanMetadata);
        }

        @Override
        public String getFactoryName(String componentName) {
            return this.factoryNames.get(componentName);
        }
    }
}

