/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.SegmentAwareKey;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.irac.IracManager;

public abstract class BaseBackupInterceptor
extends DDAsyncInterceptor {
    @Inject
    protected BackupSender backupSender;
    @Inject
    protected TransactionTable txTable;
    @Inject
    protected IracManager iracManager;
    @Inject
    protected ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    protected CommandsFactory commandsFactory;
    private static final Log log = LogFactory.getLog(BaseBackupInterceptor.class);
    private final InvocationSuccessFunction<ClearCommand> handleClearReturn = this::handleClearReturn;
    private final InvocationSuccessFunction<RemoveExpiredCommand> handleBackupMaxIdle = this::handleBackupMaxIdle;
    private final InvocationSuccessAction<RemoveExpiredCommand> handleExpiredReturn = this::handleExpiredReturn;
    protected final InvocationSuccessFunction<DataWriteCommand> handleSingleKeyWriteReturn = this::handleSingleKeyWriteReturn;

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        if (!ctx.isOriginLocal() || BaseBackupInterceptor.skipXSiteBackup(command)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handleClearReturn);
    }

    Object invokeNextAndWaitForCrossSite(TxInvocationContext<?> ctx, VisitableCommand command, InvocationStage stage) {
        return this.invokeNextThenApply(ctx, command, stage::thenReturn);
    }

    @Override
    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) {
        if (BaseBackupInterceptor.skipXSiteBackup(command) || !command.isMaxIdle()) {
            return this.invokeNext(ctx, command);
        }
        int segment = command.getSegment();
        DistributionInfo dInfo = this.clusteringDependentLogic.getCacheTopology().getSegmentDistribution(segment);
        if (dInfo.isPrimary()) {
            CompletionStage<Boolean> expired = this.iracManager.checkAndTrackExpiration(command.getKey());
            return BaseBackupInterceptor.asyncValue(expired).thenApply(ctx, command, this.handleBackupMaxIdle);
        }
        return this.invokeNext(ctx, command);
    }

    private Object handleBackupMaxIdle(InvocationContext rCtx, RemoveExpiredCommand rCommand, Object rv) {
        if (((Boolean)rv).booleanValue()) {
            return this.invokeNextThenAccept(rCtx, rCommand, this.handleExpiredReturn);
        }
        rCommand.fail();
        return rv;
    }

    private void handleExpiredReturn(InvocationContext context, RemoveExpiredCommand command, Object returnValue) {
        if (command.isSuccessful()) {
            this.iracManager.trackExpiredKey(command.getSegment(), command.getKey(), command.getCommandInvocationId());
        }
    }

    boolean isTxFromRemoteSite(GlobalTransaction gtx) {
        LocalTransaction remoteTx = this.txTable.getLocalTransaction(gtx);
        return remoteTx != null && remoteTx.isFromRemoteSite();
    }

    boolean shouldInvokeRemoteTxCommand(TxInvocationContext<?> ctx) {
        boolean shouldBackupRemotely = ctx.isOriginLocal() && ctx.hasModifications() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer();
        log.tracef("Should backup remotely? %s", (Object)shouldBackupRemotely);
        return shouldBackupRemotely;
    }

    static boolean skipXSiteBackup(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP);
    }

    private static boolean backupToRemoteSite(WriteCommand command) {
        return !command.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP);
    }

    private Stream<SegmentAwareKey<?>> keyStream(WriteCommand command) {
        return command.getAffectedKeys().stream().map(key -> SegmentSpecificCommand.extractSegmentAwareKey(command, key, this.keyPartitioner));
    }

    private Object handleClearReturn(InvocationContext ctx, ClearCommand rCommand, Object rv) {
        this.iracManager.trackClear();
        return this.backupSender.backupClear(rCommand).thenReturn(ctx, rCommand, rv);
    }

    private Object handleSingleKeyWriteReturn(InvocationContext ctx, DataWriteCommand dataWriteCommand, Object rv) {
        if (!dataWriteCommand.isSuccessful()) {
            if (log.isTraceEnabled()) {
                log.tracef("Command %s is not successful, not replicating", (Object)dataWriteCommand);
            }
            return rv;
        }
        int segment = dataWriteCommand.getSegment();
        DistributionInfo dInfo = this.clusteringDependentLogic.getCacheTopology().getSegmentDistribution(segment);
        if (dInfo.isWriteOwner()) {
            this.iracManager.trackUpdatedKey(segment, dataWriteCommand.getKey(), dataWriteCommand.getCommandInvocationId());
        }
        if (dInfo.isPrimary()) {
            CacheEntry entry = ctx.lookupEntry(dataWriteCommand.getKey());
            WriteCommand crossSiteCommand = this.createCommandForXSite(entry, segment, dataWriteCommand.getFlagsBitSet());
            return this.backupSender.backupWrite(crossSiteCommand, dataWriteCommand).thenReturn(ctx, dataWriteCommand, rv);
        }
        return rv;
    }

    private WriteCommand createCommandForXSite(CacheEntry<?, ?> entry, int segment, long flagsBitSet) {
        return entry.isRemoved() ? this.commandsFactory.buildRemoveCommand(entry.getKey(), null, segment, flagsBitSet) : this.commandsFactory.buildPutKeyValueCommand(entry.getKey(), entry.getValue(), segment, entry.getMetadata(), flagsBitSet);
    }

    private boolean isWriteOwner(SegmentAwareKey<?> key) {
        return this.clusteringDependentLogic.getCacheTopology().isSegmentWriteOwner(key.getSegment());
    }

    protected Stream<WriteCommand> getModificationsFrom(CommitCommand cmd) {
        GlobalTransaction gtx = cmd.getGlobalTransaction();
        LocalTransaction localTx = this.txTable.getLocalTransaction(gtx);
        if (localTx == null) {
            RemoteTransaction remoteTx = this.txTable.getRemoteTransaction(gtx);
            if (remoteTx == null) {
                if (log.isDebugEnabled()) {
                    log.debugf("Transaction %s not found!", (Object)gtx);
                }
                return Stream.empty();
            }
            return remoteTx.getModifications().stream();
        }
        return localTx.getModifications().stream();
    }

    public Stream<SegmentAwareKey<?>> keysFromMods(Stream<WriteCommand> modifications) {
        return modifications.filter(WriteCommand::isSuccessful).filter(BaseBackupInterceptor::backupToRemoteSite).flatMap(this::keyStream).filter(this::isWriteOwner);
    }
}

