/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.globalstate.impl.VolatileLocalConfigurationStorage;
import org.infinispan.util.logging.Log;

public class OverlayLocalConfigurationStorage
extends VolatileLocalConfigurationStorage {
    private Set<String> persistentCaches = ConcurrentHashMap.newKeySet();
    private Set<String> persistentTemplates = ConcurrentHashMap.newKeySet();
    private final Lock persistenceLock = new ReentrantLock();

    @Override
    public void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
        if (!flags.contains((Object)CacheContainerAdmin.AdminFlag.VOLATILE) && !globalConfiguration.globalState().enabled()) {
            throw Log.CONFIG.globalStateDisabled();
        }
    }

    @Override
    public CompletionStage<Void> createTemplate(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        CompletionStage<Void> future = super.createTemplate(name, configuration, flags);
        if (!flags.contains((Object)CacheContainerAdmin.AdminFlag.VOLATILE)) {
            return this.blockingManager.thenApplyBlocking(future, v -> {
                this.persistentTemplates.add(name);
                this.storeTemplates();
                return v;
            }, name).toCompletableFuture();
        }
        return future;
    }

    @Override
    public CompletionStage<Void> removeTemplate(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this.blockingManager.supplyBlocking(() -> {
            if (this.persistentTemplates.remove(name)) {
                this.storeTemplates();
            }
            this.removeTemplateSync(name, flags);
            return null;
        }, name).toCompletableFuture();
    }

    @Override
    public CompletionStage<Void> createCache(String name, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        CompletionStage<Void> future = super.createCache(name, template, configuration, flags);
        if (!flags.contains((Object)CacheContainerAdmin.AdminFlag.VOLATILE)) {
            return this.blockingManager.thenApplyBlocking(future, v -> {
                this.persistentCaches.add(name);
                this.storeCaches();
                return v;
            }, name).toCompletableFuture();
        }
        return future;
    }

    @Override
    public CompletionStage<Void> updateConfiguration(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        CompletionStage<Void> future = super.updateConfiguration(name, configuration, flags);
        if (this.persistentCaches.contains(name)) {
            return this.blockingManager.thenApplyBlocking(future, v -> {
                this.storeCaches();
                return v;
            }, name).toCompletableFuture();
        }
        return future;
    }

    @Override
    public CompletionStage<Void> removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this.blockingManager.supplyBlocking(() -> {
            if (this.persistentCaches.remove(name)) {
                this.storeCaches();
            }
            this.removeCacheSync(name, flags);
            return null;
        }, name).toCompletableFuture();
    }

    @Override
    public Map<String, Configuration> loadAllCaches() {
        Map<String, Configuration> configs = this.load(this.getCachesFile());
        log.tracef("Loaded cache configurations from local persistence: %s", (Object)configs.keySet());
        return configs;
    }

    @Override
    public Map<String, Configuration> loadAllTemplates() {
        Map<String, Configuration> configs = this.load(this.getTemplateFile());
        log.tracef("Loaded templates from local persistence: %s", (Object)configs.keySet());
        return configs;
    }

    private Map<String, Configuration> load(File file) {
        HashMap<String, Configuration> hashMap;
        FileInputStream fis = new FileInputStream(file);
        try {
            HashMap<String, Configuration> configurations = new HashMap<String, Configuration>();
            ConfigurationBuilderHolder holder = this.parserRegistry.parse(fis, null, MediaType.APPLICATION_XML);
            for (Map.Entry<String, ConfigurationBuilder> entry : holder.getNamedConfigurationBuilders().entrySet()) {
                String name = entry.getKey();
                Configuration configuration = entry.getValue().build();
                configurations.put(name, configuration);
            }
            hashMap = configurations;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return Collections.emptyMap();
            }
            catch (IOException e) {
                throw new CacheConfigurationException(e);
            }
        }
        fis.close();
        return hashMap;
    }

    private void storeCaches() {
        this.persistConfigurations("caches", this.getCachesFile(), this.getCachesFileLock(), this.persistentCaches);
    }

    private void storeTemplates() {
        this.persistConfigurations("templates", this.getTemplateFile(), this.getTemplateFileLock(), this.persistentTemplates);
    }

    private void persistConfigurations(String prefix, File file, File lock, Set<String> configNames) {
        this.persistenceLock.lock();
        try {
            GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
            File sharedDirectory = new File(globalConfiguration.globalState().sharedPersistentLocation());
            sharedDirectory.mkdirs();
            File temp = File.createTempFile(prefix, null, sharedDirectory);
            HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
            for (String config : configNames) {
                configurationMap.put(config, this.configurationManager.getConfiguration(config, true));
            }
            try (ConfigurationWriter writer = ConfigurationWriter.to(new FileOutputStream(temp)).clearTextSecrets(true).prettyPrint(true).build();){
                this.parserRegistry.serialize(writer, null, configurationMap);
            }
            try {
                Util.renameTempFile(temp, lock, file);
            }
            catch (Exception e) {
                throw Log.CONFIG.cannotRenamePersistentFile(temp.getAbsolutePath(), file, e);
            }
        }
        catch (Exception e) {
            throw Log.CONFIG.errorPersistingGlobalConfiguration(e);
        }
        finally {
            this.persistenceLock.unlock();
        }
    }

    private File getCachesFile() {
        return new File(this.configurationManager.getGlobalConfiguration().globalState().sharedPersistentLocation(), "caches.xml");
    }

    private File getCachesFileLock() {
        return new File(this.configurationManager.getGlobalConfiguration().globalState().sharedPersistentLocation(), "caches.xml.lck");
    }

    private File getTemplateFile() {
        return new File(this.configurationManager.getGlobalConfiguration().globalState().sharedPersistentLocation(), "templates.xml");
    }

    private File getTemplateFileLock() {
        return new File(this.configurationManager.getGlobalConfiguration().globalState().sharedPersistentLocation(), "templates.xml.lck");
    }
}

